<?php
// Start session to handle messages
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Include the database connection
include('db.php');
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm_password'];
    
    // Check if passwords match
    if ($password !== $confirmPassword) {
        $_SESSION['message'] = "Passwords do not match!";
        $_SESSION['message_type'] = "error";
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }
    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
    
    // SQL query to insert the new user into the database
    $sql = "INSERT INTO users (name, phone, password) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $name, $phone, $hashedPassword);
    
    if ($stmt->execute()) {
        $_SESSION['message'] = "Account created successfully! Please wait Admin Verify Approval";
        $_SESSION['message_type'] = "success";
        header("Location: login.php");
        exit;
    } else {
        $_SESSION['message'] = "Failed to create an account. Please try again.";
        $_SESSION['message_type'] = "error";
    }
    // Redirect back to the same page to show the message
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>World BKash - নিবন্ধন</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="description" content="বিদেশ থেকে বাংলাদেশে টাকা পাঠানো এখন আরো সহজ ও নিরাপদ।">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        :root {
            --primary-color: #14b8a6; /* Teal primary color */
            --primary-dark: #0f766e; /* Darker teal for gradients */
            --primary-light: #ccfbf1; /* Light teal for backgrounds */
            --secondary-color: #0d9488; /* Dark teal as secondary for contrast */
            --accent-color: #FFD700;
            --light-bg: #e0f2fe; /* Light blue background */
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #e0f2fe, #bae6fd); /* Light blue gradient background */
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            line-height: 1.6;
            overflow-x: hidden;
            position: relative;
        }
        
        /* Static background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiPjxkZWZzPjxwYXR0ZXJuIGlkPSJwYXR0ZXJuIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHBhdHRlcm5Vbml0cz0idXNlclNwYWNlT25Vc2UiIHBhdHRlcm5UcmFuc2Zvcm09InJvdGF0ZSg0NSkiPjxyZWN0IHg9IjAiIHk9IjAiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgZmlsbD0icmdiYSgyMCwgMTg0LCAxNjYsIDAuMDMpIi8+PC9wYXR0ZXJuPjwvZGVmcz48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSJ1cmwoI3BhdHRlcm4pIi8+PC9zdmc+');
            opacity: 0.5;
            z-index: -1;
        }
        
        .signup-container {
            width: 100%;
            max-width: 400px;
            margin: 20px;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            background: white;
            position: relative;
            z-index: 1;
        }
        
        .signup-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            padding: 30px 20px;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .signup-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('vendors/images/login-page-img.png') no-repeat center center;
            background-size: cover;
            opacity: 0.15;
            z-index: 0;
        }
        
        .signup-header::after {
            content: '';
            position: absolute;
            top: -50px;
            right: -50px;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .signup-header-content {
            position: relative;
            z-index: 1;
        }
        
        .signup-header img {
            width: 70px;
            height: 70px;
            margin-bottom: 15px;
            border-radius: 50%;
            background: white;
            padding: 8px;
        }
        
        .signup-header h1 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 5px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        .signup-header p {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .signup-form {
            padding: 25px 20px;
        }
        
        .form-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 20px;
            text-align: center;
            position: relative;
        }
        
        .form-title::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .form-group {
            margin-bottom: 18px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: var(--text-primary);
            font-size: 14px;
        }
        
        .input-group {
            position: relative;
            transition: var(--transition);
        }
        
        .input-group:focus-within {
            transform: translateY(-3px);
        }
        
        .input-group-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 16px;
            transition: var(--transition);
            z-index: 1;
        }
        
        .input-group:focus-within .input-group-icon {
            color: var(--primary-color);
            transform: translateY(-50%) scale(1.1);
        }
        
        .form-control {
            width: 100%;
            padding: 14px 14px 14px 45px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 15px;
            transition: var(--transition);
            background-color: var(--primary-light);
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(20, 184, 166, 0.1);
        }
        
        .upload-area {
            margin-bottom: 20px;
            border: 2px dashed #e0e0e0;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            background-color: var(--primary-light);
            transition: var(--transition);
            position: relative;
        }
        
        .upload-area:hover {
            border-color: var(--primary-color);
            background-color: rgba(20, 184, 166, 0.05);
            transform: translateY(-3px);
        }
        
        .upload-area.dragover {
            border-color: var(--primary-color);
            background-color: rgba(20, 184, 166, 0.1);
        }
        
        .upload-icon {
            font-size: 36px;
            color: var(--text-secondary);
            margin-bottom: 10px;
            transition: var(--transition);
        }
        
        .upload-area:hover .upload-icon {
            color: var(--primary-color);
            transform: scale(1.1);
        }
        
        .upload-label {
            display: inline-block;
            padding: 10px 20px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            border-radius: 30px;
            cursor: pointer;
            font-weight: 500;
            font-size: 14px;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(20, 184, 166, 0.3);
        }
        
        .upload-label:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(20, 184, 166, 0.4);
        }
        
        .upload-input {
            display: none;
        }
        
        .upload-preview {
            margin-top: 15px;
            position: relative;
            display: none;
        }
        
        .upload-preview img {
            max-width: 100%;
            max-height: 150px;
            border-radius: 8px;
            box-shadow: var(--shadow);
        }
        
        .clear-button {
            position: absolute;
            top: 8px;
            right: 8px;
            background: var(--secondary-color);
            color: white;
            border: none;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
        
        .clear-button:hover {
            background: #0e7490;
            transform: scale(1.1);
        }
        
        .btn {
            display: inline-block;
            padding: 14px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            text-align: center;
            width: 100%;
            box-shadow: 0 4px 8px rgba(20, 184, 166, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }
        
        .btn:hover::before {
            left: 100%;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(20, 184, 166, 0.4);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn i {
            transition: var(--transition);
        }
        
        .btn:hover i {
            transform: translateX(3px);
        }
        
        .login-link {
            text-align: center;
            margin-top: 18px;
            font-size: 14px;
        }
        
        .login-link a {
            color: var(--primary-color);
            font-weight: 600;
            text-decoration: none;
            transition: var(--transition);
            position: relative;
        }
        
        .login-link a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-color);
            transition: width 0.3s ease;
        }
        
        .login-link a:hover::after {
            width: 100%;
        }
        
        .login-link a:hover {
            color: var(--secondary-color);
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 18px 0;
            color: var(--text-secondary);
        }
        
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background-color: #e0e0e0;
        }
        
        .divider span {
            padding: 0 10px;
            font-size: 14px;
        }
        
        .social-login {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 15px;
        }
        
        .social-btn {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f0f0f0;
            color: var(--text-secondary);
            font-size: 18px;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        
        .social-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1);
        }
        
        .social-btn.facebook:hover {
            background: #4267B2;
            color: white;
        }
        
        .social-btn.google:hover {
            background: #DB4437;
            color: white;
        }
        
        /* Toast notification styles */
        .toast-top-right {
            top: 20px;
            right: 20px;
        }
        
        .toast-success {
            background-color: var(--primary-color);
        }
        
        .toast-error {
            background-color: var(--secondary-color);
        }
        
        /* Floating shapes */
        .shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(20, 184, 166, 0.1);
            opacity: 0.5;
            z-index: -1;
        }
        
        .shape-1 {
            width: 120px;
            height: 120px;
            top: -40px;
            left: -40px;
        }
        
        .shape-2 {
            width: 80px;
            height: 80px;
            bottom: 40px;
            right: -30px;
        }
        
        .shape-3 {
            width: 60px;
            height: 60px;
            top: 40%;
            right: 10%;
        }
        
        @media (max-width: 480px) {
            .signup-container {
                margin: 10px;
                border-radius: 15px;
            }
            
            .signup-header {
                padding: 25px 20px;
            }
            
            .signup-header img {
                width: 60px;
                height: 60px;
            }
            
            .signup-header h1 {
                font-size: 20px;
            }
            
            .signup-form {
                padding: 20px 15px;
            }
            
            .form-title {
                font-size: 16px;
                margin-bottom: 15px;
            }
            
            .form-control {
                padding: 12px 12px 12px 40px;
                font-size: 14px;
            }
            
            .btn {
                padding: 12px;
                font-size: 15px;
            }
            
            .upload-area {
                padding: 15px;
            }
            
            .upload-icon {
                font-size: 30px;
            }
            
            .upload-label {
                padding: 8px 16px;
                font-size: 13px;
            }
            
            .shape-1 {
                width: 100px;
                height: 100px;
            }
            
            .shape-2 {
                width: 60px;
                height: 60px;
            }
            
            .shape-3 {
                width: 40px;
                height: 40px;
            }
        }
    </style>
</head>
<body class="signup-page">
    <!-- Floating shapes -->
    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>
    <div class="shape shape-3"></div>
    
    <div class="signup-container">
        <div class="signup-header">
            <div class="signup-header-content">
                <img src="vendors/images/logo.png" alt="World BKash লোগো">
                <h1>World BKash</h1>
                <p>বিশ্বমানের সাথে বাংলাদেশকে সংযুক্ত করার সহজ উপায়</p>
            </div>
        </div>
        
        <div class="signup-form">
            <h2 class="form-title">নিবন্ধন করুন</h2>
            
            <form method="POST" action="" enctype="multipart/form-data" id="signupForm">
                <div class="form-group">
                    <label for="name">পূর্ণ নাম</label>
                    <div class="input-group">
                        <i class="fas fa-user input-group-icon"></i>
                        <input type="text" class="form-control" name="name" id="name" placeholder="আপনার পূর্ণ নাম" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="phone">ফোন নম্বর</label>
                    <div class="input-group">
                        <i class="fas fa-phone-alt input-group-icon"></i>
                        <input type="tel" class="form-control" name="phone" id="phone" placeholder="আপনার ফোন নম্বর" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="password">পাসওয়ার্ড</label>
                    <div class="input-group">
                        <i class="fas fa-lock input-group-icon"></i>
                        <input type="password" class="form-control" name="password" id="password" placeholder="আপনার পাসওয়ার্ড" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="confirm_password">পাসওয়ার্ড নিশ্চিত করুন</label>
                    <div class="input-group">
                        <i class="fas fa-lock input-group-icon"></i>
                        <input type="password" class="form-control" name="confirm_password" id="confirm_password" placeholder="আবার পাসওয়ার্ড দিন" required>
                    </div>
                </div>
                
                <div class="upload-area" id="uploadArea">
                    <div class="upload-icon">
                        <i class="fas fa-cloud-upload-alt"></i>
                    </div>
                    <label for="imageUpload" class="upload-label">
                        নথি আপলোড করুন
                    </label>
                    <input type="file" id="imageUpload" name="image" accept="image/*" class="upload-input">
                    <div class="upload-preview" id="uploadPreview">
                        <img id="previewImage" src="" alt="Preview">
                        <button type="button" class="clear-button" id="clearImage">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-user-plus" style="margin-right: 6px;"></i> নিবন্ধন করুন
                </button>
                
                <div class="divider">
                    <span>অথবা</span>
                </div>
                
                <div class="social-login">
                    <a href="#" class="social-btn facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="social-btn google">
                        <i class="fab fa-google"></i>
                    </a>
                </div>
                
                <div class="login-link">
                    অ্যাকাউন্ট আছে? <a href="login.php">লগইন করুন</a>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        $(document).ready(function() {
            // Image upload functionality
            const uploadArea = $('#uploadArea');
            const imageUpload = $('#imageUpload');
            const uploadPreview = $('#uploadPreview');
            const previewImage = $('#previewImage');
            const clearButton = $('#clearImage');
            
            // Drag and drop functionality
            uploadArea.on('dragover', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).addClass('dragover');
            });
            
            uploadArea.on('dragleave', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).removeClass('dragover');
            });
            
            uploadArea.on('drop', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).removeClass('dragover');
                const files = e.originalEvent.dataTransfer.files;
                handleFileUpload(files);
            });
            
            // File input change
            imageUpload.change(function() {
                const files = this.files;
                handleFileUpload(files);
            });
            
            // Handle file upload
            function handleFileUpload(files) {
                if (files.length > 0) {
                    const file = files[0];
                    const reader = new FileReader();
                    
                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        toastr.error('অনুগ্রহ করে ছবি ফাইল নির্বাচন করুন');
                        return;
                    }
                    
                    // Validate file size (max 5MB)
                    if (file.size > 5 * 1024 * 1024) {
                        toastr.error('ফাইলের আকার 5MB এর কম হতে হবে');
                        return;
                    }
                    
                    reader.onload = function(e) {
                        previewImage.attr('src', e.target.result);
                        uploadPreview.show();
                    };
                    
                    reader.readAsDataURL(file);
                }
            }
            
            // Clear image
            clearButton.click(function() {
                imageUpload.val('');
                uploadPreview.hide();
            });
            
            // Input focus animation
            $('.form-control').on('focus', function() {
                $(this).closest('.input-group').addClass('focused');
            }).on('blur', function() {
                $(this).closest('.input-group').removeClass('focused');
            });
            
            // Form submission with loading animation
            $('#signupForm').on('submit', function() {
                // Add loading animation if needed
            });
            
            // Toastr notifications
            <?php if (isset($_SESSION['message'])): ?>
                var type = "<?php echo $_SESSION['message_type']; ?>";
                var message = "<?php echo $_SESSION['message']; ?>";
                
                // Configure toastr
                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": true,
                    "progressBar": true,
                    "positionClass": "toast-top-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                if (type === "success") {
                    toastr.success(message);
                } else if (type === "error") {
                    toastr.error(message);
                }
                
                // Clear session message after displaying
                <?php unset($_SESSION['message']); ?>
                <?php unset($_SESSION['message_type']); ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>