<?php
session_start();
include('db.php');
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id'];
$receiverId = $_GET['user_id']; // You can dynamically set this based on your application's needs
$pinError = '';
$successMessage = '';
$showErrorToast = false;  // Flag to determine if error toast should be shown
// Fetch receiver's name and phone number
$receiverQuery = $conn->prepare("SELECT name, phone FROM users WHERE id = ?");
$receiverQuery->bind_param("i", $receiverId);
$receiverQuery->execute();
$receiverResult = $receiverQuery->get_result();
$receiverData = $receiverResult->fetch_assoc();
$receiverName = $receiverData['name'];
$receiverPhone = $receiverData['phone'];
// Fetch user data including balance and PIN
$userQuery = $conn->prepare("SELECT name, balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userName = $userData['name'];
$userPin = $userData['pin'];
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $reference = $_POST['reference'];
    $inputPin = $_POST['pin'];
    // Check if PIN is correct
    if ($inputPin === $userPin) {
        // Check if the user has enough balance
        if ($amount > $userBalance) {
            $pinError = "Insufficient balance!";
            $showErrorToast = true;
        } else {
            // Transfer is valid, deduct from sender and add to receiver
            $newSenderBalance = $userBalance - $amount;
            // Update sender's balance
            $updateSenderQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $updateSenderQuery->bind_param("di", $newSenderBalance, $userId);
            $updateSenderQuery->execute();
            // Get receiver's balance
            $receiverQuery = $conn->prepare("SELECT balance FROM users WHERE id = ?");
            $receiverQuery->bind_param("i", $receiverId);
            $receiverQuery->execute();
            $receiverResult = $receiverQuery->get_result();
            $receiverData = $receiverResult->fetch_assoc();
            $receiverBalance = $receiverData['balance'];
            // Update receiver's balance
            $newReceiverBalance = $receiverBalance + $amount;
            $updateReceiverQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $updateReceiverQuery->bind_param("di", $newReceiverBalance, $receiverId);
            $updateReceiverQuery->execute();
            // Insert transaction into the transaction history
            $insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, receiver_id, amount, reference, status, title) VALUES (?, ?, ?, ?, 'completed', 'SEND MONEY')");
            $insertTransactionQuery->bind_param("iids", $userId, $receiverId, $amount, $reference);
            $insertTransactionQuery->execute();
            $successMessage = "Payment Successful!";
        }
    } else {
        $pinError = "Invalid PIN!";
        $showErrorToast = true;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment with Pin Verification</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #008080; /* Teal color */
            --secondary-color: #FF6B6B; /* Complementary coral color */
            --accent-color: #FFD700; /* Gold accent */
            --light-bg: #f0f8f8; /* Light teal background */
            --card-bg: #ffffff;
            --text-primary: #004d4d; /* Dark teal text */
            --text-secondary: #5a7a7a; /* Medium teal text */
            --shadow: 0 4px 12px rgba(0, 128, 128, 0.15); /* Teal shadow */
            --transition: all 0.3s ease;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), #006666); /* Darker teal gradient */
            color: white;
            padding: 15px 20px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
        }
        .back-icon:hover {
            transform: translateX(-5px);
        }
        .back-icon i {
            font-size: 20px;
            margin-right: 10px;
        }
        .header h3 {
            font-size: 22px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
        }
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 16px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .balance i {
            margin-right: 8px;
            color: var(--accent-color);
        }
        .main-container {
            max-width: 800px;
            margin: 25px auto;
            padding: 0 15px;
        }
        .page-title {
            text-align: center;
            margin: 30px 0 20px;
            color: var(--primary-color);
            position: relative;
            font-size: 24px;
            font-weight: 600;
        }
        .page-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: linear-gradient(to right, var(--primary-color), #00cccc); /* Lighter teal gradient */
            border-radius: 3px;
        }
        .user-info-container {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        .user-info-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), #00cccc); /* Lighter teal gradient */
        }
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 10px;
            color: var(--secondary-color);
        }
        .user-card {
            display: flex;
            align-items: center;
            padding: 20px;
            background: rgba(0, 128, 128, 0.05); /* Very light teal background */
            border-radius: 10px;
            border-left: 4px solid var(--primary-color);
        }
        .user-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary-color), #00cccc); /* Teal gradient */
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            font-weight: 600;
            font-size: 24px;
            margin-right: 20px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .user-details {
            flex-grow: 1;
        }
        .user-name {
            font-size: 18px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 5px;
        }
        .user-phone {
            font-size: 16px;
            color: var(--text-secondary);
            display: flex;
            align-items: center;
        }
        .user-phone i {
            margin-right: 8px;
            color: var(--accent-color);
        }
        .payment-input-container {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        .payment-input-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), #00cccc); /* Lighter teal gradient */
        }
        .input-group {
            margin-bottom: 20px;
            position: relative;
        }
        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 18px;
        }
        .input-group input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #e0f2f2; /* Light teal border */
            border-radius: 8px;
            font-size: 16px;
            box-sizing: border-box;
            transition: var(--transition);
            background-color: #f0f8f8; /* Very light teal background */
        }
        .input-group input:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 128, 128, 0.1); /* Teal focus shadow */
        }
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color), #006666); /* Darker teal gradient */
            color: white;
            border: none;
            padding: 15px;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            margin-top: 10px;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }
        .submit-btn i {
            margin-right: 10px;
        }
        .popup-overlay {
            visibility: hidden;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        .popup-overlay.show {
            visibility: visible;
            opacity: 1;
        }
        .popup {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 30px;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            transform: scale(0.7);
            transition: transform 0.3s ease;
        }
        .popup-overlay.show .popup {
            transform: scale(1);
        }
        .popup h4 {
            margin-top: 0;
            margin-bottom: 20px;
            text-align: center;
            font-size: 22px;
            color: var(--primary-color);
        }
        .popup input {
            width: 100%;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 16px;
            border: 2px solid #e0f2f2; /* Light teal border */
            border-radius: 8px;
            box-sizing: border-box;
            transition: var(--transition);
            background-color: #f0f8f8; /* Very light teal background */
        }
        .popup input:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 128, 128, 0.1); /* Teal focus shadow */
        }
        .verify-btn, .close-btn {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            margin-bottom: 10px;
        }
        .verify-btn {
            background: linear-gradient(135deg, var(--primary-color), #006666); /* Darker teal gradient */
            color: white;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .verify-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }
        .close-btn {
            background: linear-gradient(135deg, var(--secondary-color), #c62828);
            color: white;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .close-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }
        .toast {
            visibility: hidden;
            min-width: 300px;
            margin-left: -150px;
            background-color: var(--primary-color);
            color: white;
            text-align: center;
            border-radius: 50px;
            padding: 15px 25px;
            position: fixed;
            z-index: 1000;
            left: 50%;
            bottom: 30px;
            font-size: 16px;
            font-weight: 500;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.3s, transform 0.3s;
        }
        .toast.show {
            visibility: visible;
            opacity: 1;
            transform: translateY(0);
        }
        .toast.error {
            background-color: var(--secondary-color);
        }
        .toast i {
            margin-right: 10px;
            font-size: 18px;
        }
        @media (max-width: 768px) {
            .header {
                padding: 12px 15px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 14px;
                padding: 6px 12px;
            }
            
            .page-title {
                font-size: 20px;
            }
            
            .user-info-container, .payment-input-container {
                padding: 20px;
            }
            
            .user-avatar {
                width: 50px;
                height: 50px;
                font-size: 20px;
            }
            
            .user-name {
                font-size: 16px;
            }
            
            .user-phone {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>Payment Process</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>
    <!-- Main Container -->
    <div class="main-container">
        <h2 class="page-title">Send Money</h2>
        
        <!-- User Info Container -->
        <div class="user-info-container">
            <div class="section-title">
                <i class="fas fa-user"></i>
                Receiver Information
            </div>
            <div class="user-card">
                <?php 
                    // Get user's initials for avatar
                    $initials = implode('', array_map(function($part) { return strtoupper($part[0]); }, explode(' ', $receiverName)));
                    if (strlen($initials) > 2) $initials = substr($initials, 0, 2);
                ?>
                <div class="user-avatar"><?php echo $initials; ?></div>
                <div class="user-details">
                    <div class="user-name"><?php echo htmlspecialchars($receiverName); ?></div>
                    <div class="user-phone">
                        <i class="fas fa-phone-alt"></i>
                        <?php echo htmlspecialchars($receiverPhone); ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Payment Input Container -->
        <div class="payment-input-container">
            <div class="section-title">
                <i class="fas fa-money-bill-wave"></i>
                Payment Details
            </div>
            <form method="POST">
                <div class="input-group">
                    <i class="fas fa-money-bill-wave"></i>
                    <input type="number" name="amount" placeholder="Enter Amount" required>
                </div>
                <div class="input-group">
                    <i class="fas fa-sticky-note"></i>
                    <input type="text" name="reference" placeholder="Reference (Optional)">
                </div>
                <button type="button" class="submit-btn" onclick="showPopup()">
                    <i class="fas fa-paper-plane"></i>
                    Submit Payment
                </button>
                
                <!-- Pop-up for PIN verification -->
                <div class="popup-overlay" id="popupOverlay">
                    <div class="popup">
                        <h4><i class="fas fa-lock"></i> Enter PIN</h4>
                        <input type="password" name="pin" placeholder="Enter your 4-digit PIN" required maxlength="4" pattern="[0-9]{4}">
                        <button type="submit" class="verify-btn">
                            <i class="fas fa-check-circle"></i> Verify & Process
                        </button>
                        <button type="button" class="close-btn" onclick="closePopup()">
                            <i class="fas fa-times-circle"></i> Cancel
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <i class="fas fa-check-circle"></i>
        <span id="toastMessage"><?php echo $successMessage ?: $pinError; ?></span>
    </div>
    <script>
        function showPopup() {
            const popup = document.getElementById('popupOverlay');
            popup.classList.add('show');
        }
        
        function closePopup() {
            const popup = document.getElementById('popupOverlay');
            popup.classList.remove('show');
        }
        
        // Close popup when clicking outside
        document.getElementById('popupOverlay').addEventListener('click', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });
        
        // Show success or error toast
        <?php if ($successMessage): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const toast = document.getElementById('toast');
                const toastMessage = document.getElementById('toastMessage');
                
                toastMessage.innerHTML = '<i class="fas fa-check-circle"></i> <?php echo $successMessage; ?>';
                toast.classList.add('show');
                
                setTimeout(function() {
                    window.location.href = "dashboard.php"; // Redirect to dashboard after 1 second
                }, 1000);
            });
        <?php elseif ($showErrorToast): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const toast = document.getElementById('toast');
                const toastMessage = document.getElementById('toastMessage');
                
                toast.classList.add('error');
                toastMessage.innerHTML = '<i class="fas fa-exclamation-circle"></i> <?php echo $pinError; ?>';
                toast.classList.add('show');
                
                setTimeout(function() {
                    toast.classList.remove('show');
                }, 3000);
            });
        <?php endif; ?>
    </script>
</body>
</html>