<?php
session_start();
include('db.php');
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT reward_points, balance FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$rewardPoints = $user['reward_points'];
$balance = $user['balance'];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $convertReward = $_POST['convert_reward'];
    if (is_numeric($convertReward) && $convertReward > 0 && $convertReward <= $rewardPoints) {
        $convertedAmount = $convertReward / 100;
        $newBalance = $balance + $convertedAmount;
        $newRewardPoints = $rewardPoints - $convertReward;
        $updateStmt = $conn->prepare("UPDATE users SET balance = ?, reward_points = ? WHERE id = ?");
        $updateStmt->bind_param("dii", $newBalance, $newRewardPoints, $userId);
        $updateStmt->execute();
        $rewardPoints = $newRewardPoints;
        $balance = $newBalance;
        $_SESSION['message'] = "Rewards converted successfully!";
        $_SESSION['message_type'] = "success";
    } else {
        $_SESSION['message'] = "Invalid conversion amount!";
        $_SESSION['message_type'] = "error";
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reward Conversion</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        :root {
            --primary-color: #006A4E;
            --secondary-color: #F42A41;
            --accent-color: #FFD700;
            --light-bg: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --success-color: #28a745;
            --error-color: #dc3545;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            line-height: 1.6;
        }

        .container {
            width: 100%;
            max-width: 500px;
            background: var(--card-bg);
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }

        .header {
            margin-bottom: 30px;
        }

        .header h2 {
            font-size: 28px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 10px;
            position: relative;
            display: inline-block;
        }

        .header h2::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            border-radius: 3px;
        }

        .header p {
            font-size: 16px;
            color: var(--text-secondary);
        }

        .balance-cards {
            display: flex;
            gap: 15px;
            margin-bottom: 30px;
        }

        .balance-card {
            flex: 1;
            background: linear-gradient(135deg, var(--primary-color), #2e7d32);
            color: white;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 106, 78, 0.2);
            position: relative;
            overflow: hidden;
        }

        .balance-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(30px, -30px);
        }

        .reward-card {
            background: linear-gradient(135deg, var(--accent-color), #e6c200);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.2);
        }

        .card-icon {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .card-label {
            font-size: 14px;
            opacity: 0.9;
            margin-bottom: 5px;
        }

        .card-value {
            font-size: 22px;
            font-weight: 700;
        }

        .conversion-form {
            background: rgba(0, 106, 78, 0.05);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            border: 1px solid rgba(0, 106, 78, 0.1);
        }

        .form-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .form-title i {
            margin-right: 10px;
            color: var(--secondary-color);
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--text-primary);
        }

        .input-wrapper {
            position: relative;
        }

        .input-wrapper i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
        }

        .form-group input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 16px;
            box-sizing: border-box;
            transition: var(--transition);
            background-color: #f9f9f9;
        }

        .form-group input:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 106, 78, 0.1);
        }

        .conversion-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 15px;
            padding: 10px 15px;
            background: rgba(255, 215, 0, 0.1);
            border-radius: 8px;
            font-size: 14px;
            color: var(--text-secondary);
        }

        .conversion-rate {
            font-weight: 600;
            color: var(--accent-color);
        }

        .converted-amount {
            font-weight: 600;
            color: var(--primary-color);
        }

        .submit-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, var(--primary-color), #2e7d32);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .submit-btn i {
            margin-right: 10px;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition);
        }

        .back-link:hover {
            color: var(--secondary-color);
        }

        .back-link i {
            margin-right: 5px;
        }

        @media (max-width: 576px) {
            .container {
                padding: 30px 20px;
            }
            
            .header h2 {
                font-size: 24px;
            }
            
            .balance-cards {
                flex-direction: column;
            }
            
            .form-group input {
                padding: 12px 12px 12px 40px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Reward Conversion</h2>
            <p>Convert your reward points to balance</p>
        </div>
        
        <div class="balance-cards">
            <div class="balance-card">
                <div class="card-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <div class="card-label">Current Balance</div>
                <div class="card-value">৳<?= number_format($balance, 2) ?></div>
            </div>
            
            <div class="balance-card reward-card">
                <div class="card-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="card-label">Reward Points</div>
                <div class="card-value"><?= $rewardPoints ?></div>
            </div>
        </div>
        
        <form method="POST" action="">
            <div class="conversion-form">
                <div class="form-title">
                    <i class="fas fa-exchange-alt"></i>
                    Convert Points to Balance
                </div>
                
                <div class="form-group">
                    <label for="convert_reward">Points to Convert</label>
                    <div class="input-wrapper">
                        <i class="fas fa-coins"></i>
                        <input type="number" name="convert_reward" id="convert_reward" placeholder="Enter points to convert" min="1" max="<?= $rewardPoints ?>" required>
                    </div>
                </div>
                
                <div class="conversion-info">
                    <span>Conversion Rate: <span class="conversion-rate">100 Points = ৳1</span></span>
                    <span>You'll get: <span class="converted-amount" id="convertedAmount">৳0</span></span>
                </div>
            </div>
            
            <button type="submit" class="submit-btn">
                <i class="fas fa-exchange-alt"></i>
                Convert Points
            </button>
        </form>
        
        <div style="margin-top: 20px;">
            <a href="javascript:history.back()" class="back-link">
                <i class="fas fa-arrow-left"></i>
                Back to Profile
            </a>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Calculate converted amount in real-time
            $('#convert_reward').on('input', function() {
                const points = parseFloat($(this).val()) || 0;
                const convertedAmount = (points / 100).toFixed(2);
                $('#convertedAmount').text('৳' + convertedAmount);
            });
            
            // Show toastr notifications
            <?php if (isset($_SESSION['message'])): ?>
                var type = "<?php echo $_SESSION['message_type']; ?>";
                var message = "<?php echo $_SESSION['message']; ?>";
                
                // Configure toastr
                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": true,
                    "progressBar": true,
                    "positionClass": "toast-top-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                if (type === "success") {
                    toastr.success(message);
                } else if (type === "error") {
                    toastr.error(message);
                }
                
                // Clear session message after displaying
                <?php unset($_SESSION['message']); ?>
                <?php unset($_SESSION['message_type']); ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>