<?php
session_start();
error_reporting(E_ALL);
// Display errors on the webpage
ini_set('display_errors', 1);
include('db.php'); // Your database connection file
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id'];
$pinError = '';
$successMessage = '';
$showErrorToast = false;  // Flag to determine if error toast should be shown
// Fetch user data including balance and PIN
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];
// Fetch recharge notice from the settings table
$settingsQuery = $conn->prepare("SELECT rechage_notice FROM settings WHERE id = 1");
$settingsQuery->execute();
$settingsResult = $settingsQuery->get_result();
$settingsData = $settingsResult->fetch_assoc();
$rechargeNotice = $settingsData['rechage_notice']; // Recharge notice
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mobileNumber = $_POST['mobile_number'];
    $amount = $_POST['amount'];
    $inputPin = $_POST['pin'];
    $transactionType = $_POST['transaction_type']; // Get the value of Prepaid/Postpaid from the form
    // Check if PIN is correct
    if ($inputPin === $userPin) {
        // Check if the user has enough balance
        if ($amount > $userBalance) {
            $pinError = "Insufficient balance!";
            $showErrorToast = true;
        } else {
            // Deduct the recharge amount from the user's balance
            $newBalance = $userBalance - $amount;
            // Update the user's balance in the database
            $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $updateBalanceQuery->bind_param("di", $newBalance, $userId);
            $updateBalanceQuery->execute();
            // Insert transaction into the transactions table with status 'Pending'
            $insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, account_number, amount, status, transaction_type, title, type) VALUES (?, ?, ?, 'Pending', ?, 'MOBILE RECHARGE', 'other')");
            $insertTransactionQuery->bind_param("isds", $userId, $mobileNumber, $amount, $transactionType);
            $insertTransactionQuery->execute();
function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );
    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );
    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }
    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }
    $fields = json_encode($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Mobile Recharge)";
$response = sendOneSignalNotificationToAll($title, $message);
            $successMessage = "Recharge Successful!";
        }
    } else {
        $pinError = "Invalid PIN!";
        $showErrorToast = true;
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>মোবাইল রিচার্জ</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --teal-primary: #008080; /* Main teal color */
            --teal-light: #e0fffe; /* Very light teal */
            --teal-medium: #4dbdbd; /* Medium teal */
            --teal-dark: #004d40; /* Dark teal */
            --teal-bg-light: #f0f8f8; /* Very light teal background */
            --teal-text-dark: #004d40; /* Dark teal text */
            --teal-text-medium: #00695c; /* Medium teal text */
            --teal-text-light: #00a39a; /* Light teal text */
            --teal-gray-lightest: #f5fafa; /* Very light teal gray */
            --teal-gray-light: #e0f2f1; /* Light teal gray */
            --teal-gray: #80cbc4; /* Medium teal gray */
            --teal-gray-dark: #00695c; /* Dark teal gray */
            --teal-border: #b2dfdb; /* Light teal border */
            --teal-success: #2ecc71; /* Success color (unchanged) */
            --teal-warning: #f39c12; /* Warning color (unchanged) */
            --teal-danger: #e74c3c; /* Danger color (unchanged) */
            --teal-blue: #3498db; /* Blue accent (unchanged) */
            --transition: all 0.3s ease;
        }
        
        body {
            background: var(--teal-bg-light);
            color: var(--teal-text-dark);
            font-size: 14px;
            line-height: 1.4;
        }
        
        .app-container {
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
            padding-bottom: 70px;
        }
        
        /* Header Styles */
        .app-header {
            background: white;
            padding: 15px;
            color: var(--teal-text-dark);
            position: relative;
            border-bottom: 1px solid var(--teal-border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: var(--teal-light);
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--teal-primary);
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: var(--teal-primary);
            color: white;
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
        }
        
        .balance-badge {
            background: var(--teal-light);
            border-radius: 20px;
            padding: 6px 12px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 5px;
            color: var(--teal-primary);
        }
        
        /* Notice Container */
        .notice-container {
            margin: 15px;
            background: var(--teal-light);
            border-radius: 8px;
            padding: 12px;
            border-left: 4px solid var(--teal-primary);
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .notice-text {
            color: var(--teal-primary);
            font-size: 13px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .close-notice {
            background: none;
            border: none;
            color: var(--teal-primary);
            font-size: 16px;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .close-notice:hover {
            transform: scale(1.2);
        }
        
        /* Form Container */
        .form-container {
            padding: 15px;
        }
        
        .form-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--teal-text-dark);
            text-align: center;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: var(--teal-gray);
            font-size: 13px;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid var(--teal-border);
            border-radius: 8px;
            font-size: 14px;
            transition: var(--transition);
            background-color: white;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--teal-primary);
            box-shadow: 0 0 0 2px rgba(0, 128, 128, 0.2);
        }
        
        /* Custom Select Dropdown */
        .select-wrapper {
            position: relative;
        }
        
        .select-wrapper::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            top: 50%;
            right: 15px;
            transform: translateY(-50%);
            pointer-events: none;
            color: var(--teal-gray);
        }
        
        select.form-control {
            appearance: none;
            padding-right: 40px;
            cursor: pointer;
        }
        
        /* Input with Icon */
        .input-with-icon {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--teal-gray);
        }
        
        .input-with-icon .form-control {
            padding-left: 40px;
        }
        
        /* Submit Button */
        .submit-btn {
            background: var(--teal-primary);
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .submit-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 128, 128, 0.3);
        }
        
        .submit-btn:active {
            transform: translateY(0);
        }
        
        /* Popup Styles */
        .popup-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            animation: fadeIn 0.3s ease;
        }
        
        .popup-overlay.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .popup {
            background: white;
            border-radius: 12px;
            width: 90%;
            max-width: 320px;
            padding: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            animation: slideUp 0.3s ease;
        }
        
        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .popup-header {
            text-align: center;
            margin-bottom: 15px;
        }
        
        .popup-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--teal-text-dark);
        }
        
        .popup-body {
            margin-bottom: 15px;
        }
        
        .pin-input {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--teal-border);
            border-radius: 8px;
            font-size: 16px;
            text-align: center;
            letter-spacing: 5px;
            transition: var(--transition);
        }
        
        .pin-input:focus {
            outline: none;
            border-color: var(--teal-primary);
            box-shadow: 0 0 0 2px rgba(0, 128, 128, 0.2);
        }
        
        .popup-footer {
            display: flex;
            gap: 10px;
        }
        
        .popup-btn {
            flex: 1;
            padding: 10px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .verify-btn {
            background: var(--teal-primary);
            color: white;
        }
        
        .verify-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 128, 128, 0.3);
        }
        
        .cancel-btn {
            background: var(--teal-gray-lightest);
            color: var(--teal-gray);
        }
        
        .cancel-btn:hover {
            background: #e0e0e0;
        }
        
        /* Toast Notification */
        .toast {
            visibility: hidden;
            position: fixed;
            left: 50%;
            bottom: 30px;
            transform: translateX(-50%);
            background: white;
            color: var(--teal-text-dark);
            padding: 12px 16px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 2000;
            display: flex;
            align-items: center;
            gap: 8px;
            min-width: 250px;
            opacity: 0;
            transition: opacity 0.3s, bottom 0.3s;
        }
        
        .toast.show {
            visibility: visible;
            opacity: 1;
            bottom: 50px;
        }
        
        .toast.success {
            border-left: 4px solid var(--teal-success);
        }
        
        .toast.error {
            border-left: 4px solid var(--teal-danger);
        }
        
        .toast-icon {
            font-size: 18px;
        }
        
        .toast.success .toast-icon {
            color: var(--teal-success);
        }
        
        .toast.error .toast-icon {
            color: var(--teal-danger);
        }
        
        .toast-message {
            font-weight: 500;
        }
        
        /* Quick Amount Selection */
        .quick-amount {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
            margin-bottom: 15px;
        }
        
        .amount-chip {
            padding: 10px;
            background: white;
            border: 1px solid var(--teal-border);
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            transition: var(--transition);
            font-weight: 500;
            font-size: 13px;
        }
        
        .amount-chip:hover {
            border-color: var(--teal-primary);
            color: var(--teal-primary);
            transform: translateY(-2px);
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }
        
        .amount-chip.selected {
            background: var(--teal-primary);
            color: white;
            border-color: var(--teal-primary);
        }
        
        /* Form Card */
        .form-card {
            background: white;
            border-radius: 12px;
            margin: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            overflow: hidden;
        }
        
        .form-card-header {
            background: var(--teal-primary);
            color: white;
            padding: 12px;
            text-align: center;
        }
        
        .form-card-body {
            padding: 15px;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.1);
            z-index: 100;
            border-top: 1px solid var(--teal-border);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 8px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--teal-gray);
            transition: var(--transition);
            padding: 5px;
            border-radius: 8px;
            min-width: 60px;
            position: relative;
        }
        
        .nav-item.active {
            color: var(--teal-primary);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 3px;
            background: var(--teal-primary);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 2px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">মোবাইল রিচার্জ</h1>
            <div class="balance-badge">
                <i class="fas fa-wallet"></i>
                ৳<?php echo number_format($userBalance, 2); ?>
            </div>
        </div>
        
        <!-- Notice Container -->
        <div class="notice-container" id="noticeContainer">
            <div class="notice-text">
                <i class="fas fa-info-circle"></i>
                <span><?php echo htmlspecialchars($rechargeNotice); ?></span>
            </div>
            <button class="close-notice" onclick="closeNotice()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <!-- Form Card -->
        <div class="form-card">
            <div class="form-card-header">
                <h2 class="form-title">আপনার মোবাইল রিচার্জ করুন</h2>
            </div>
            <div class="form-card-body">
                <form id="rechargeForm" method="POST">
                    <div class="form-group">
                        <label class="form-label">সংযোগের ধরন</label>
                        <div class="select-wrapper">
                            <select name="transaction_type" class="form-control" required>
                                <option value="">প্রিপেইড/পোস্টপেইড নির্বাচন করুন</option>
                                <option value="prepaid">প্রিপেইড</option>
                                <option value="postpaid">পোস্টপেইড</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">মোবাইল নম্বর</label>
                        <div class="input-with-icon">
                            <i class="fas fa-mobile-alt input-icon"></i>
                            <input type="tel" name="mobile_number" class="form-control" placeholder="১১ ডিজিট মোবাইল নম্বর লিখুন" maxlength="11" pattern="\d{11}" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">দ্রুত পরিমাণ</label>
                        <div class="quick-amount">
                            <div class="amount-chip" onclick="setAmount(50)">৳৫০</div>
                            <div class="amount-chip" onclick="setAmount(100)">৳১০০</div>
                            <div class="amount-chip" onclick="setAmount(200)">৳২০০</div>
                            <div class="amount-chip" onclick="setAmount(500)">৳৫০০</div>
                            <div class="amount-chip" onclick="setAmount(1000)">৳১০০০</div>
                            <div class="amount-chip" onclick="clearAmount()">অন্যান্য</div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">পরিমাণ</label>
                        <div class="input-with-icon">
                            <i class="fas fa-money-bill-wave input-icon"></i>
                            <input type="number" name="amount" id="amountInput" class="form-control" placeholder="পরিমাণ লিখুন" required>
                        </div>
                    </div>
                    
                    <input type="hidden" id="pinInput" name="pin">
                    
                    <button type="button" class="submit-btn" onclick="showPopup()">
                        <i class="fas fa-paper-plane"></i>
                        এখনই রিচার্জ করুন
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Bottom Navigation -->
        <div class="bottom-nav">
            <div class="nav-list">
                <a href="/" class="nav-item">
                    <i class="fas fa-home nav-icon"></i>
                    <div class="nav-label">হোম</div>
                </a>
                <a href="history.php" class="nav-item">
                    <i class="fas fa-history nav-icon"></i>
                    <div class="nav-label">ইতিহাস</div>
                </a>
                <a href="coin.php" class="nav-item">
                    <i class="fas fa-qrcode nav-icon"></i>
                    <div class="nav-label">স্ক্যান</div>
                </a>
                <a href="coin.php" class="nav-item">
                    <img src="img/tt.png" alt="Rewards" style="width: 16px; height: 14px; margin-bottom: 1px;">
                    <div class="nav-label">রিওয়ার্ড</div>
                </a>
                <a href="profile.php" class="nav-item">
                    <i class="fas fa-user nav-icon"></i>
                    <div class="nav-label">প্রোফাইল</div>
                </a>
            </div>
        </div>
    </div>
    
    <!-- PIN Popup -->
    <div class="popup-overlay" id="popupOverlay">
        <div class="popup">
            <div class="popup-header">
                <h3 class="popup-title">পিন লিখুন</h3>
            </div>
            <div class="popup-body">
                <input type="password" id="pinEntry" class="pin-input" placeholder="••••" maxlength="4" required>
            </div>
            <div class="popup-footer">
                <button type="button" class="popup-btn cancel-btn" onclick="closePopup()">বাতিল</button>
                <button type="button" class="popup-btn verify-btn" onclick="submitForm()">যাচাই করুন</button>
            </div>
        </div>
    </div>
    
    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <i class="toast-icon fas"></i>
        <span class="toast-message"></span>
    </div>
    
    <script>
        // Close notice container
        function closeNotice() {
            const noticeContainer = document.getElementById('noticeContainer');
            noticeContainer.style.display = 'none';
        }
        
        // Show PIN popup
        function showPopup() {
            const form = document.getElementById('rechargeForm');
            if (form.checkValidity()) {
                const popupOverlay = document.getElementById('popupOverlay');
                popupOverlay.classList.add('show');
                document.getElementById('pinEntry').value = '';
                document.getElementById('pinEntry').focus();
            } else {
                form.reportValidity();
            }
        }
        
        // Close PIN popup
        function closePopup() {
            const popupOverlay = document.getElementById('popupOverlay');
            popupOverlay.classList.remove('show');
        }
        
        // Verify payment and submit the form
        function submitForm() {
            const enteredPin = document.getElementById('pinEntry').value;
            if (enteredPin.length === 4) {
                document.getElementById('pinInput').value = enteredPin;
                document.getElementById('rechargeForm').submit();
            } else {
                showToast('অনুগ্রহ করে ৪ ডিজিট পিন লিখুন', 'error');
            }
        }
        
        // Set amount from quick selection
        function setAmount(amount) {
            document.getElementById('amountInput').value = amount;
            
            // Update selected state
            document.querySelectorAll('.amount-chip').forEach(chip => {
                chip.classList.remove('selected');
            });
            event.target.classList.add('selected');
        }
        
        // Clear amount selection
        function clearAmount() {
            document.getElementById('amountInput').value = '';
            document.getElementById('amountInput').focus();
            
            // Update selected state
            document.querySelectorAll('.amount-chip').forEach(chip => {
                chip.classList.remove('selected');
            });
            event.target.classList.add('selected');
        }
        
        // Show toast notification
        function showToast(message, type = 'success') {
            const toast = document.getElementById('toast');
            const toastMessage = toast.querySelector('.toast-message');
            const toastIcon = toast.querySelector('.toast-icon');
            
            // Set toast content
            toastMessage.textContent = message;
            
            // Set toast type
            toast.className = 'toast';
            toast.classList.add(type);
            
            // Set icon based on type
            if (type === 'success') {
                toastIcon.className = 'toast-icon fas fa-check-circle';
            } else if (type === 'error') {
                toastIcon.className = 'toast-icon fas fa-exclamation-circle';
            }
            
            // Show toast
            toast.classList.add('show');
            
            // Hide toast after 3 seconds
            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }
        
        // Show toast notification based on PHP response
        <?php if ($successMessage): ?>
            showToast('<?php echo $successMessage; ?>', 'success');
            setTimeout(function() {
                window.location.href = "dashboard.php";
            }, 2000);
        <?php elseif ($showErrorToast): ?>
            showToast('<?php echo $pinError; ?>', 'error');
        <?php endif; ?>
        
        // Close popup when clicking outside
        document.getElementById('popupOverlay').addEventListener('click', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });
    </script>
</body>
</html>