<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>লোন - World BKash</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --teal-primary: #008080;
            --teal-light: #e0fffe;
            --teal-dark: #004d40;
            --teal-medium: #4dbdbd;
            --teal-text-dark: #004d40;
            --teal-text-medium: #00695c;
            --teal-text-light: #00a39a;
            --teal-gray-lightest: #f5fafa;
            --teal-gray-light: #e0f2f1;
            --teal-gray: #80cbc4;
            --teal-gray-dark: #00695c;
            --teal-border: #b2dfdb;
            --teal-success: #2ecc71;
            --teal-warning: #f39c12;
            --teal-danger: #e74c3c;
            --teal-blue: #3498db;
            --transition: all 0.3s ease;
            --shadow: 0 4px 12px rgba(0, 128, 128, 0.15);
        }
        
        body {
            background: var(--teal-gray-lightest);
            color: var(--teal-text-dark);
            font-size: 14px;
            line-height: 1.6;
            min-height: 100vh;
        }
        
        .app-container {
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        /* Header Styles */
        .app-header {
            background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
            color: white;
            padding: 15px 20px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
        }
        
        /* Hero Section */
        .hero-section {
            padding: 20px;
            text-align: center;
            background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .hero-section::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .hero-icon {
            font-size: 40px;
            margin-bottom: 10px;
            position: relative;
            z-index: 1;
        }
        
        .hero-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 5px;
            position: relative;
            z-index: 1;
        }
        
        .hero-subtitle {
            font-size: 14px;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }
        
        /* Loan Types Section */
        .loan-types {
            padding: 20px;
            background: white;
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--teal-primary);
            margin-bottom: 15px;
            text-align: center;
            position: relative;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -6px;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: var(--teal-primary);
            border-radius: 3px;
        }
        
        .loan-cards {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .loan-card {
            background: var(--teal-light);
            border-radius: 12px;
            padding: 15px;
            text-align: center;
            transition: var(--transition);
            cursor: pointer;
            border: 2px solid transparent;
        }
        
        .loan-card:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow);
        }
        
        .loan-card.active {
            border-color: var(--teal-primary);
            background: white;
        }
        
        .loan-icon {
            font-size: 30px;
            color: var(--teal-primary);
            margin-bottom: 10px;
        }
        
        .loan-name {
            font-size: 16px;
            font-weight: 600;
            color: var(--teal-text-dark);
            margin-bottom: 5px;
        }
        
        .loan-amount {
            font-size: 14px;
            color: var(--teal-text-medium);
        }
        
        /* Loan Details Section */
        .loan-details {
            padding: 0 20px 20px;
            display: none;
        }
        
        .loan-details.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .details-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: var(--shadow);
            margin-bottom: 20px;
        }
        
        .details-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--teal-primary);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        
        .details-title i {
            margin-right: 8px;
        }
        
        .details-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid var(--teal-gray-light);
        }
        
        .details-row:last-child {
            border-bottom: none;
        }
        
        .details-label {
            font-weight: 500;
            color: var(--teal-text-medium);
        }
        
        .details-value {
            font-weight: 600;
            color: var(--teal-text-dark);
        }
        
        .requirements-list {
            list-style: none;
            margin-top: 10px;
        }
        
        .requirements-list li {
            padding: 8px 0;
            padding-left: 25px;
            position: relative;
        }
        
        .requirements-list li::before {
            content: '\f00c';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 0;
            color: var(--teal-success);
        }
        
        /* Action Buttons */
        .action-buttons {
            padding: 0 20px 20px;
            display: flex;
            gap: 15px;
        }
        
        .action-btn {
            flex: 1;
            padding: 12px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
        }
        
        .details-btn {
            background: var(--teal-primary);
            color: white;
        }
        
        .details-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        .contact-btn {
            background: var(--teal-light);
            color: var(--teal-primary);
            border: 1px solid var(--teal-primary);
        }
        
        .contact-btn:hover {
            background: var(--teal-primary);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        .action-btn i {
            margin-right: 8px;
        }
        
        /* Contact Form */
        .contact-form {
            padding: 0 20px 20px;
            display: none;
        }
        
        .contact-form.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        .form-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: var(--shadow);
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: var(--teal-text-medium);
        }
        
        .form-input, .form-select, .form-textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--teal-border);
            border-radius: 6px;
            font-size: 14px;
            font-family: 'Hind Siliguri', sans-serif;
            transition: var(--transition);
        }
        
        .form-input:focus, .form-select:focus, .form-textarea:focus {
            outline: none;
            border-color: var(--teal-primary);
            box-shadow: 0 0 0 2px rgba(0, 128, 128, 0.2);
        }
        
        .form-textarea {
            resize: vertical;
            min-height: 100px;
        }
        
        .submit-btn {
            width: 100%;
            padding: 12px;
            background: var(--teal-primary);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .submit-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }
        
        /* Success Message */
        .success-message {
            display: none;
            background: var(--teal-success);
            color: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: 500;
        }
        
        .success-message.show {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        /* Footer */
        .footer {
            padding: 20px;
            text-align: center;
            color: var(--teal-text-medium);
            font-size: 13px;
            border-top: 1px solid var(--teal-border);
        }
        
        /* Responsive */
        @media (max-width: 480px) {
            .app-container {
                max-width: 100%;
            }
            
            .loan-cards {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">লোন</h1>
        </div>
        
        <!-- Hero Section -->
        <div class="hero-section">
            <div class="hero-icon">
                <i class="fas fa-hand-holding-usd"></i>
            </div>
            <h2 class="hero-title">দ্রুত লোন সুবিধা</h2>
            <p class="hero-subtitle">আপনার প্রয়োজনে সহজেই লোন নিন</p>
        </div>
        
        <!-- Loan Types Section -->
        <div class="loan-types">
            <h3 class="section-title">লোনের প্রকার</h3>
            <div class="loan-cards">
                <div class="loan-card active" onclick="selectLoan('personal')">
                    <div class="loan-icon">
                        <i class="fas fa-user"></i>
                    </div>
                    <h4 class="loan-name">ব্যক্তিগত লোন</h4>
                    <p class="loan-amount">৳৫,০০০ - ৳৫০,০০০</p>
                </div>
                <div class="loan-card" onclick="selectLoan('business')">
                    <div class="loan-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h4 class="loan-name">ব্যবসায়িক লোন</h4>
                    <p class="loan-amount">৳১০,০০০ - ৳১,০০,০০০</p>
                </div>
                <div class="loan-card" onclick="selectLoan('emergency')">
                    <div class="loan-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h4 class="loan-name">জরুরি লোন</h4>
                    <p class="loan-amount">৳২,০০০ - ৳২০,০০০</p>
                </div>
                <div class="loan-card" onclick="selectLoan('education')">
                    <div class="loan-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h4 class="loan-name">শিক্ষা লোন</h4>
                    <p class="loan-amount">৳৫,০০০ - ৳৫০,০০০</p>
                </div>
            </div>
        </div>
        
        <!-- Loan Details Section -->
        <div class="loan-details active" id="loan-details">
            <div class="details-card">
                <h3 class="details-title">
                    <i class="fas fa-info-circle"></i>
                    ব্যক্তিগত লোনের বিস্তারিত
                </h3>
                <div class="details-row">
                    <span class="details-label">লোনের পরিমাণ</span>
                    <span class="details-value">৳৫,০০০ - ৳৫০,০০০</span>
                </div>
                <div class="details-row">
                    <span class="details-label">সুদের হার</span>
                    <span class="details-value">৮% - ১২% (বার্ষিক)</span>
                </div>
                <div class="details-row">
                    <span class="details-label">মেয়াদ</span>
                    <span class="details-value">১ মাস - ১২ মাস</span>
                </div>
                <div class="details-row">
                    <span class="details-label">প্রসেসিং ফি</span>
                    <span class="details-value">৳১০০ - ৳৫০০</span>
                </div>
                <div class="details-row">
                    <span class="details-label">অনুমোদনের সময়</span>
                    <span class="details-value">২৪ - ৪৮ ঘন্টা</span>
                </div>
                
                <h4 class="details-title" style="margin-top: 20px; font-size: 16px;">
                    <i class="fas fa-list-check"></i>
                    প্রয়োজনীয় কাগজপত্র
                </h4>
                <ul class="requirements-list">
                    <li>জাতীয় পরিচয়পত্র (NID)</li>
                    <li>পাসপোর্ট সাইজ ছবি ২ কপি</li>
                    <li>আয়ের প্রমাণপত্র</li>
                    <li>ঠিকানার প্রমাণপত্র</li>
                    <li>ব্যাংক স্টেটমেন্ট (শেষ ৩ মাস)</li>
                </ul>
            </div>
        </div>
        
        <!-- Action Buttons -->
        <div class="action-buttons">
            <button class="action-btn details-btn" onclick="toggleDetails()">
                <i class="fas fa-info-circle"></i>
                বিস্তারিত
            </button>
            <button class="action-btn contact-btn" onclick="toggleContact()">
                <i class="fas fa-phone"></i>
                কন্ট্যাক্ট
            </button>
        </div>
        
        <!-- Contact Form -->
        <div class="contact-form" id="contact-form">
            <div class="form-card">
                <h3 class="details-title">
                    <i class="fas fa-envelope"></i>
                    লোনের জন্য আবেদন করুন
                </h3>
                <div class="success-message" id="success-message">
                    <i class="fas fa-check-circle"></i> আপনার আবেদন সফলভাবে WhatsApp এ পাঠানো হয়েছে!
                </div>
                <form id="loan-form">
                    <div class="form-group">
                        <label class="form-label">পূর্ণ নাম</label>
                        <input type="text" class="form-input" id="full-name" placeholder="আপনার পূর্ণ নাম লিখুন" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">মোবাইল নম্বর</label>
                        <input type="tel" class="form-input" id="mobile" placeholder="01XXXXXXXXX" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ইমেইল</label>
                        <input type="email" class="form-input" id="email" placeholder="your@email.com">
                    </div>
                    <div class="form-group">
                        <label class="form-label">লোনের প্রকার</label>
                        <select class="form-select" id="loan-type">
                            <option value="ব্যক্তিগত লোন">ব্যক্তিগত লোন</option>
                            <option value="ব্যবসায়িক লোন">ব্যবসায়িক লোন</option>
                            <option value="জরুরি লোন">জরুরি লোন</option>
                            <option value="শিক্ষা লোন">শিক্ষা লোন</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">লোনের পরিমাণ</label>
                        <input type="text" class="form-input" id="loan-amount" placeholder="প্রয়োজনীয় পরিমাণ" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">বার্তা</label>
                        <textarea class="form-textarea" id="message" placeholder="আপনার বার্তা লিখুন..."></textarea>
                    </div>
                    <button type="submit" class="submit-btn">আবেদন জমা দিন</button>
                </form>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>© ২০২৩ World BKash। সর্বস্বত্ব সংরক্ষিত।</p>
        </div>
    </div>
    
    <script>
        // Loan data
        const loanData = {
            personal: {
                name: "ব্যক্তিগত লোন",
                amount: "৳৫,০০০ - ৳৫০,০০০",
                interest: "৮% - ১২% (বার্ষিক)",
                duration: "১ মাস - ১২ মাস",
                fee: "৳১০০ - ৳৫০০",
                approval: "২৪ - ৪৮ ঘন্টা",
                requirements: [
                    "জাতীয় পরিচয়পত্র (NID)",
                    "পাসপোর্ট সাইজ ছবি ২ কপি",
                    "আয়ের প্রমাণপত্র",
                    "ঠিকানার প্রমাণপত্র",
                    "ব্যাংক স্টেটমেন্ট (শেষ ৩ মাস)"
                ]
            },
            business: {
                name: "ব্যবসায়িক লোন",
                amount: "৳১০,০০০ - ৳১,০০,০০০",
                interest: "১০% - ১৫% (বার্ষিক)",
                duration: "৩ মাস - ২৪ মাস",
                fee: "৳৫০০ - ৳২,০০০",
                approval: "৪৮ - ৭২ ঘন্টা",
                requirements: [
                    "ব্যবসার নিবন্ধনপত্র",
                    "ট্রেড লাইসেন্স",
                    "আয়কর রিটার্ন",
                    "ব্যাংক স্টেটমেন্ট (শেষ ৬ মাস)",
                    "ব্যবসায়িক ঠিকানার প্রমাণপত্র"
                ]
            },
            emergency: {
                name: "জরুরি লোন",
                amount: "৳২,০০০ - ৳২০,০০০",
                interest: "১২% - ১৮% (বার্ষিক)",
                duration: "৭ দিন - ৩০ দিন",
                fee: "৳৫০ - ৳২০০",
                approval: "১ - ৬ ঘন্টা",
                requirements: [
                    "জাতীয় পরিচয়পত্র (NID)",
                    "মোবাইল নম্বর",
                    "জরুরি প্রয়োজনের বিবরণ",
                    "একজন গ্যারান্টর",
                    "সক্রিয় World BKash অ্যাকাউন্ট"
                ]
            },
            education: {
                name: "শিক্ষা লোন",
                amount: "৳৫,০০০ - ৳৫০,০০০",
                interest: "৫% - ৮% (বার্ষিক)",
                duration: "৬ মাস - ২৪ মাস",
                fee: "৳২০০ - ৳১,০০০",
                approval: "৪৮ - ৭২ ঘন্টা",
                requirements: [
                    "শিক্ষার প্রমাণপত্র",
                    "প্রতিষ্ঠানের ভর্তির প্রমাণপত্র",
                    "অভিভাবকের আয়ের প্রমাণপত্র",
                    "জাতীয় পরিচয়পত্র (NID)",
                    "শিক্ষার খরচের বিবরণ"
                ]
            }
        };
        
        let selectedLoan = 'personal';
        let detailsVisible = true;
        let contactVisible = false;
        
        function selectLoan(loanType) {
            selectedLoan = loanType;
            
            // Update active card
            document.querySelectorAll('.loan-card').forEach(card => {
                card.classList.remove('active');
            });
            event.currentTarget.classList.add('active');
            
            // Update loan details
            updateLoanDetails();
            
            // Update loan type in form
            document.getElementById('loan-type').value = loanData[loanType].name;
        }
        
        function updateLoanDetails() {
            const loan = loanData[selectedLoan];
            const detailsSection = document.getElementById('loan-details');
            
            detailsSection.innerHTML = `
                <div class="details-card">
                    <h3 class="details-title">
                        <i class="fas fa-info-circle"></i>
                        ${loan.name} এর বিস্তারিত
                    </h3>
                    <div class="details-row">
                        <span class="details-label">লোনের পরিমাণ</span>
                        <span class="details-value">${loan.amount}</span>
                    </div>
                    <div class="details-row">
                        <span class="details-label">সুদের হার</span>
                        <span class="details-value">${loan.interest}</span>
                    </div>
                    <div class="details-row">
                        <span class="details-label">মেয়াদ</span>
                        <span class="details-value">${loan.duration}</span>
                    </div>
                    <div class="details-row">
                        <span class="details-label">প্রসেসিং ফি</span>
                        <span class="details-value">${loan.fee}</span>
                    </div>
                    <div class="details-row">
                        <span class="details-label">অনুমোদনের সময়</span>
                        <span class="details-value">${loan.approval}</span>
                    </div>
                    
                    <h4 class="details-title" style="margin-top: 20px; font-size: 16px;">
                        <i class="fas fa-list-check"></i>
                        প্রয়োজনীয় কাগজপত্র
                    </h4>
                    <ul class="requirements-list">
                        ${loan.requirements.map(req => `<li>${req}</li>`).join('')}
                    </ul>
                </div>
            `;
        }
        
        function toggleDetails() {
            const detailsSection = document.getElementById('loan-details');
            const contactForm = document.getElementById('contact-form');
            
            if (!detailsVisible) {
                detailsSection.classList.add('active');
                contactForm.classList.remove('active');
                detailsVisible = true;
                contactVisible = false;
            } else {
                detailsSection.classList.remove('active');
                detailsVisible = false;
            }
        }
        
        function toggleContact() {
            const detailsSection = document.getElementById('loan-details');
            const contactForm = document.getElementById('contact-form');
            
            if (!contactVisible) {
                contactForm.classList.add('active');
                detailsSection.classList.remove('active');
                contactVisible = true;
                detailsVisible = false;
            } else {
                contactForm.classList.remove('active');
                contactVisible = false;
            }
        }
        
        // Form submission to WhatsApp
        document.getElementById('loan-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Get form values
            const fullName = document.getElementById('full-name').value;
            const mobile = document.getElementById('mobile').value;
            const email = document.getElementById('email').value;
            const loanType = document.getElementById('loan-type').value;
            const loanAmount = document.getElementById('loan-amount').value;
            const message = document.getElementById('message').value;
            
            // Create WhatsApp message
            const whatsappMessage = `*World BKash লোন আবেদন*%0A%0A` +
                `*পূর্ণ নাম:* ${fullName}%0A` +
                `*মোবাইল নম্বর:* ${mobile}%0A` +
                `*ইমেইল:* ${email}%0A` +
                `*লোনের প্রকার:* ${loanType}%0A` +
                `*লোনের পরিমাণ:* ${loanAmount}%0A` +
                `*বার্তা:* ${message}`;
            
            // WhatsApp number
            const whatsappNumber = '8801314921868';
            
            // Create WhatsApp URL
            const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(whatsappMessage)}`;
            
            // Show success message
            document.getElementById('success-message').classList.add('show');
            
            // Open WhatsApp
            window.open(whatsappURL, '_blank');
            
            // Reset form
            this.reset();
            
            // Hide success message after 5 seconds
            setTimeout(() => {
                document.getElementById('success-message').classList.remove('show');
            }, 5000);
        });
    </script>
</body>
</html>