<?php

// Start session to handle messages

session_start();

ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);



// Include the database connection (MySQLi)

include('db.php');



// Check if the user is already logged in, if so, redirect them

if (isset($_SESSION['user_id']) && isset($_SESSION['phone'])) {

    // If user is logged in, redirect to pin.php

    header("Location: pin.php");

    exit(); // Always use exit after header redirect to stop further script execution

}



// Handle "Remember Me" functionality

if (isset($_COOKIE['remember_me'])) {

    $token = $_COOKIE['remember_me'];

    

    // MySQLi prepared statement to check token

    $stmt = $conn->prepare("SELECT * FROM users WHERE remember_token = ?");

    $stmt->bind_param("s", $token); // Bind the token parameter

    $stmt->execute();

    $result = $stmt->get_result();

    $user = $result->fetch_assoc();



    if ($user) {

        $_SESSION['user_id'] = $user['id'];

        $_SESSION['phone'] = $user['phone'];

        session_regenerate_id(true); // Prevent session fixation attacks

        header('Location: pin.php');

        exit();

    }

}



// Handle form submission

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $phone = $_POST['phone'];

    $password = $_POST['password'];

    $role = $_POST['options']; // Either 'bd' or 'other'



    // MySQLi query to find the user in the database

    $sql = "SELECT * FROM users WHERE phone = ? AND role = ?";

    $stmt = $conn->prepare($sql);

    $stmt->bind_param("ss", $phone, $role); // Bind parameters to prevent SQL injection

    $stmt->execute();

    $result = $stmt->get_result();

    $user = $result->fetch_assoc();



    // Check if the user exists and password is correct

    if ($user && password_verify($password, $user['password'])) {

        // Store user information in session

        $_SESSION['user_id'] = $user['id'];

        $_SESSION['phone'] = $user['phone'];

        $_SESSION['tt'] = "rayhan"; // Example of setting another session variable

        $_SESSION['message'] = "Login Successful!";

        $_SESSION['message_type'] = "success";



        // Generate a secure remember token

        $token = bin2hex(random_bytes(16));

        $stmt = $conn->prepare("UPDATE users SET remember_token = ? WHERE id = ?");

        $stmt->bind_param("si", $token, $user['id']);

        $stmt->execute();



        // Set secure cookie for "Remember Me"

        setcookie('remember_me', $token, time() + (86400 * 365 * 10), "/", "", true, true); // 10 years expiry, secure and HTTP-only



        // Regenerate session ID to avoid session fixation attacks

        session_regenerate_id(true);



        // Redirect to the dashboard or home page

        header('Location: pin.php');

        exit();

    } else {

        // Error message

        $_SESSION['message'] = "Invalid phone or password!";

        $_SESSION['message_type'] = "error";

    }



    // Redirect back to the same page to show the message

    header("Location: " . $_SERVER['PHP_SELF']);

    exit();

}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Basic Page Info -->
    <meta charset="utf-8">
    <title>Ramit Wallet - সহজ রেমিট্যান্স পাঠানোর মাধ্যম</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="বিদেশ থেকে বাংলাদেশে টাকা পাঠানো এখন আরো সহজ ও নিরাপদ। Ramit Wallet-এর মাধ্যমে আপনি যে কোনো সময়, যে কোনো স্থান থেকে দ্রুত এবং ঝামেলাহীনভাবে রেমিট্যান্স পাঠাতে পারেন। আমাদের সিস্টেম সম্পূর্ণ সুরক্ষিত এবং আপনার টাকার প্রতিটি পয়সা পৌঁছে যায় গন্তব্যে নিরাপদে। Ramit Wallet-এর সাথে থাকুন।">
    <meta property="og:title" content="Ramit Wallet - সহজ রেমিট্যান্স পাঠানোর মাধ্যম">
    <meta property="og:description" content="বিদেশ থেকে বাংলাদেশে টাকা পাঠানো এখন আরো সহজ ও নিরাপদ। Ramit Wallet-এর মাধ্যমে আপনি যে কোনো সময়, যে কোনো স্থান থেকে দ্রুত এবং ঝামেলাহীনভাবে রেমিট্যান্স পাঠাতে পারেন। আমাদের সিস্টেম সম্পূর্ণ সুরক্ষিত এবং আপনার টাকার প্রতিটি পয়সা পৌঁছে যায় গন্তব্যে নিরাপদে। Ramit Wallet-এর সাথে থাকুন।">
    <meta property="og:image" content="/images/ramitwallet.jpg">
    <meta property="og:image:type" content="image/jpeg">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">

    <link rel="stylesheet" type="text/css" href="vendors/styles/core.css">
    <link rel="stylesheet" type="text/css" href="vendors/styles/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <style>
        .select-role label {
            padding: 10px;
        }
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
        }
        body {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-wrap {
            width: 100%;
            height: 100%;
        }
        .container {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-box {
            width: 100%;
            max-width: 400px;
            padding: 0 20px;
        }
        .login-title {
            margin-bottom: 20px;
        }
        .login-image {
            max-width: 100%;
            width: 70%;
            height: 140px;
            display: block;
            margin: 0 auto;
        }
    </style>
</head>
<body class="login-page">
    <div class="login-wrap">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6 col-lg-7">
                    <img src="vendors/images/login-page-img.png" alt="" class="login-image">
                </div>
                <div class="col-md-6 col-lg-5">
                    <div class="login-box bg-white box-shadow border-radius-10">
                        <div class="login-title">
                            <h2 class="text-center text-primary">Login To Ramit Wallet</h2>
                        </div>
                         <form method="POST" action="">
                    <div class="select-role">
                        <div class="btn-group btn-group-toggle" data-toggle="buttons">
                            <label class="btn" id="bdBtn" style="display:none;">
                                <input type="radio" name="options" id="admin" value="bd" checked>
                                <div class="icon"><img src="vendors/images/briefcase.svg" alt=""></div>
                                <span>বাংলাদেশি</span>
                            </label>
                            <label class="btn" id="otherBtn" style="display:none;">
                                <input type="radio" name="options" id="user" value="other">
                                <div class="icon"><img src="vendors/images/person.svg" alt=""></div>
                                <span>প্রবাসী</span>
                            </label>
                        </div>
                    </div>
                    <div class="input-group custom">
                        <input type="number" class="form-control" name="phone" placeholder="Phone" required>
                    </div>
                    <div class="input-group custom">
                        <input type="password" class="form-control" name="password" placeholder="Password" required>
                    </div>
                    <div class="input-group">
                        <input class="btn btn-primary btn-block" type="submit" value="Sign In">
                    </div>
                    <div class="text-center">
                        <a href="signup.php">Don't have an account? Sign Up</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Toastr Notification Script -->
    <script>
        $(document).ready(function() {
            // Set initial color for Bangladeshi button
            $('#bdBtn').css('background-color', 'green').css('color', 'white');
            // Color change based on radio button selection
            $('input[name="options"]').change(function() {
                if ($('#admin').is(':checked')) {
                    $('#bdBtn').css('background-color', 'green').css('color', 'white');
                    $('#otherBtn').css('background-color', '').css('color', 'black');
                } else {
                    $('#otherBtn').css('background-color', 'red').css('color', 'white');
                    $('#bdBtn').css('background-color', '').css('color', 'black');
                }
            });

            // Toastr notifications
            <?php if (isset($_SESSION['message'])): ?>
                var type = "<?php echo $_SESSION['message_type']; ?>";
                var message = "<?php echo $_SESSION['message']; ?>";

                if (type === "success") {
                    toastr.success(message);
                } else if (type === "error") {
                    toastr.error(message);
                }

                // Clear session message after displaying
                <?php unset($_SESSION['message']); ?>
                <?php unset($_SESSION['message_type']); ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>
