<?php
// Start session to handle messages
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include('db.php');
if (isset($_SESSION['user_id']) && isset($_SESSION['phone'])) {
    header("Location: pin.php");
    exit(); 
}
if (isset($_COOKIE['remember_me'])) {
    $token = $_COOKIE['remember_me'];
    
    $stmt = $conn->prepare("SELECT * FROM users WHERE remember_token = ?");
    $stmt->bind_param("s", $token); 
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['phone'] = $user['phone'];
        session_regenerate_id(true); 
        header('Location: pin.php');
        exit();
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    // রোল অপশন সরিয়ে ফেলা হয়েছে
    $sql = "SELECT * FROM users WHERE phone = ?"; // রোল চেক সরানো হয়েছে
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $phone); // শুধুমাত্র ফোন নম্বর ব্যবহার করা হচ্ছে
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    if ($user) {
        // Removed verification check - users can now login without admin approval
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['phone'] = $user['phone'];
            $_SESSION['tt'] = "rayhan"; 
            $_SESSION['message'] = "Login Successful!";
            $_SESSION['message_type'] = "success";
            $token = bin2hex(random_bytes(16));
            $stmt = $conn->prepare("UPDATE users SET remember_token = ? WHERE id = ?");
            $stmt->bind_param("si", $token, $user['id']);
            $stmt->execute();
            setcookie('remember_me', $token, time() + (86400 * 365), "/", "", true, true); 
            session_regenerate_id(true);
            header('Location: pin.php');
            exit();
        } else {
            $_SESSION['message'] = "Invalid phone or password!";
            $_SESSION['message_type'] = "error";
        }
    } else {
        $_SESSION['message'] = "User not found!";
        $_SESSION['message_type'] = "error";
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <!-- Basic Page Info -->
    <meta charset="utf-8">
    <title>World BKash - লগইন</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="description" content="বিদেশ থেকে বাংলাদেশে টাকা পাঠানো এখন আরো সহজ ও নিরাপদ। World BKash-এর মাধ্যমে আপনি যে কোনো সময়, যে কোনো স্থান থেকে দ্রুত এবং ঝামেলাহীনভাবে রেমিট্যান্স পাঠাতে পারেন।">
    <meta property="og:title" content="World BKash - সহজ রেমিট্যান্স পাঠানোর মাধ্যম">
    <meta property="og:description" content="বিদেশ থেকে বাংলাদেশে টাকা পাঠানো এখন আরো সহজ ও নিরাপদ।">
    <meta property="og:image" content="/images/worldbkash.jpg">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        :root {
            --primary-color: #14b8a6;
            --primary-light: #ccfbf1;
            --secondary-color: #0f766e;
            --accent-color: #FFD700;
            --light-bg: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        body {
            font-family: 'Hind Siliguri', sans-serif;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            line-height: 1.5;
            overflow-x: hidden;
            position: relative;
        }
        
        /* Static background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiPjxkZWZzPjxwYXR0ZXJuIGlkPSJwYXR0ZXJuIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHBhdHRlcm5Vbml0cz0idXNlclNwYWNlT25Vc2UiIHBhdHRlcm5UcmFuc2Zvcm09InJvdGF0ZSg0NSkiPjxyZWN0IHg9IjAiIHk9IjAiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgZmlsbD0icmdiYSgyMCwgMTg0LCAxNjYsIDAuMDMpIi8+PC9wYXR0ZXJuPjwvZGVmcz48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSJ1cmwoI3BhdHRlcm4pIi8+PC9zdmc+');
            opacity: 0.5;
            z-index: -1;
        }
        
        .login-container {
            width: 100%;
            max-width: 350px;
            margin: 15px;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: var(--shadow);
            background: white;
            position: relative;
            z-index: 1;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 25px 20px;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .login-header::before {
            content: '';
            position: absolute;
            top: -15px;
            right: -15px;
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .login-header::after {
            content: '';
            position: absolute;
            bottom: -20px;
            left: -20px;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .login-header-content {
            position: relative;
            z-index: 1;
        }
        
        .logo-icon {
            font-size: 36px;
            margin-bottom: 10px;
            color: white;
        }
        
        .login-header h1 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 5px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        .login-header p {
            font-size: 12px;
            opacity: 0.9;
            max-width: 90%;
            margin: 0 auto;
        }
        
        .login-form {
            padding: 25px 20px;
            position: relative;
        }
        
        .form-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 20px;
            text-align: center;
            position: relative;
        }
        
        .form-title::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .form-group {
            margin-bottom: 18px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 600;
            color: var(--text-primary);
            font-size: 13px;
        }
        
        .input-group {
            position: relative;
            transition: var(--transition);
        }
        
        .input-group:focus-within {
            transform: translateY(-3px);
        }
        
        .input-group-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-color);
            font-size: 14px;
            z-index: 1;
            transition: var(--transition);
        }
        
        .input-group:focus-within .input-group-icon {
            color: var(--secondary-color);
            transform: translateY(-50%) scale(1.1);
        }
        
        .form-control {
            width: 100%;
            padding: 12px 12px 12px 40px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            transition: var(--transition);
            background-color: #f9f9f9;
            font-family: 'Hind Siliguri', sans-serif;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(20, 184, 166, 0.1);
        }
        
        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            cursor: pointer;
            z-index: 1;
            font-size: 14px;
            transition: var(--transition);
        }
        
        .password-toggle:hover {
            color: var(--primary-color);
        }
        
        .btn {
            display: inline-block;
            padding: 12px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            text-align: center;
            width: 100%;
            box-shadow: 0 4px 10px rgba(20, 184, 166, 0.3);
            position: relative;
            overflow: hidden;
            font-family: 'Hind Siliguri', sans-serif;
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }
        
        .btn:hover::before {
            left: 100%;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(20, 184, 166, 0.4);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn i {
            transition: var(--transition);
        }
        
        .btn:hover i {
            transform: translateX(3px);
        }
        
        .signup-link {
            text-align: center;
            margin-top: 20px;
            font-size: 13px;
            color: var(--text-secondary);
        }
        
        .signup-link a {
            color: var(--primary-color);
            font-weight: 600;
            text-decoration: none;
            transition: var(--transition);
            position: relative;
        }
        
        .signup-link a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-color);
            transition: width 0.3s ease;
        }
        
        .signup-link a:hover::after {
            width: 100%;
        }
        
        .signup-link a:hover {
            color: var(--secondary-color);
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 20px 0;
            color: var(--text-secondary);
        }
        
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background-color: #e0e0e0;
        }
        
        .divider span {
            padding: 0 8px;
            font-size: 12px;
        }
        
        .social-login {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-top: 15px;
        }
        
        .social-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f0f0f0;
            color: var(--text-secondary);
            font-size: 16px;
            transition: var(--transition);
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.05);
        }
        
        .social-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 10px rgba(0, 0, 0, 0.1);
        }
        
        .social-btn.facebook:hover {
            background: #4267B2;
            color: white;
        }
        
        .social-btn.google:hover {
            background: #DB4437;
            color: white;
        }
        
        /* Loading overlay */
        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .loading-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        
        .loader {
            width: 40px;
            height: 40px;
            position: relative;
        }
        
        .loader::before, .loader::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            border: 4px solid transparent;
            border-top-color: var(--primary-color);
        }
        
        .loader::before {
            z-index: 2;
        }
        
        .loader::after {
            border-top-color: var(--primary-light);
        }
        
        /* Toast notification styles */
        .toast-top-right {
            top: 20px;
            right: 20px;
        }
        
        .toast-success {
            background-color: var(--primary-color);
        }
        
        .toast-error {
            background-color: var(--secondary-color);
        }
        
        /* Floating shapes */
        .shape {
            position: absolute;
            border-radius: 50%;
            background: var(--primary-light);
            opacity: 0.2;
            z-index: -1;
        }
        
        .shape-1 {
            width: 100px;
            height: 100px;
            top: -30px;
            left: -30px;
        }
        
        .shape-2 {
            width: 70px;
            height: 70px;
            bottom: 30px;
            right: -20px;
        }
        
        .shape-3 {
            width: 60px;
            height: 60px;
            top: 40%;
            right: 10%;
        }
        
        @media (max-width: 480px) {
            .login-container {
                margin: 10px;
                border-radius: 12px;
            }
            
            .login-header {
                padding: 20px 15px;
            }
            
            .login-header h1 {
                font-size: 20px;
            }
            
            .login-form {
                padding: 20px 15px;
            }
            
            .form-title {
                font-size: 16px;
                margin-bottom: 15px;
            }
            
            .form-control {
                padding: 10px 10px 10px 35px;
                font-size: 13px;
            }
            
            .btn {
                padding: 10px;
                font-size: 13px;
            }
            
            .shape-1 {
                width: 80px;
                height: 80px;
            }
            
            .shape-2 {
                width: 50px;
                height: 50px;
            }
            
            .shape-3 {
                width: 40px;
                height: 40px;
            }
        }
    </style>
</head>
<body class="login-page">
    <!-- Floating shapes -->
    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>
    <div class="shape shape-3"></div>
    
    <div class="login-container">
        <div class="login-header">
            <div class="login-header-content">
                <div class="logo-icon">
                    <i class="fas fa-globe-asia"></i>
                </div>
                <h1>World BKash</h1>
                <p>বিশ্বমানের সাথে বাংলাদেশকে সংযুক্ত করার সহজ উপায়</p>
            </div>
        </div>
        
        <div class="login-form">
            <h2 class="form-title">লগইন করুন</h2>
            
            <form method="POST" action="" id="loginForm">
                <!-- রোল সিলেক্টর সরিয়ে ফেলা হয়েছে -->
                
                <div class="form-group">
                    <label for="phone">ফোন নম্বর</label>
                    <div class="input-group">
                        <i class="fas fa-phone-alt input-group-icon"></i>
                        <input type="tel" class="form-control" name="phone" id="phone" placeholder="আপনার ফোন নম্বর" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="password">পাসওয়ার্ড</label>
                    <div class="input-group">
                        <i class="fas fa-lock input-group-icon"></i>
                        <input type="password" class="form-control" name="password" id="password" placeholder="আপনার পাসওয়ার্ড" required>
                        <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                    </div>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-sign-in-alt" style="margin-right: 6px;"></i> লগইন করুন
                </button>
                
                <div class="signup-link">
                    অ্যাকাউন্ট নেই? <a href="signup.php">নিবন্ধন করুন</a>
                </div>
            </form>
            
            <div class="divider">
                <span>অথবা</span>
            </div>
            
            <div class="social-login">
                <a href="#" class="social-btn facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="#" class="social-btn google">
                    <i class="fab fa-google"></i>
                </a>
            </div>
            
            <!-- Loading overlay -->
            <div class="loading-overlay" id="loadingOverlay">
                <div class="loader"></div>
            </div>
        </div>
    </div>
    
    <!-- Toastr Notification Script -->
    <script>
        $(document).ready(function() {
            // Password visibility toggle
            $('#togglePassword').on('click', function() {
                const passwordField = $('#password');
                const passwordFieldType = passwordField.attr('type');
                
                if (passwordFieldType === 'password') {
                    passwordField.attr('type', 'text');
                    $(this).removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    passwordField.attr('type', 'password');
                    $(this).removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });
            
            // Form submission with loading animation
            $('#loginForm').on('submit', function() {
                $('#loadingOverlay').addClass('active');
            });
            
            // Input focus animation
            $('.form-control').on('focus', function() {
                $(this).closest('.input-group').addClass('focused');
            }).on('blur', function() {
                $(this).closest('.input-group').removeClass('focused');
            });
            
            // Toastr notifications
            <?php if (isset($_SESSION['message'])): ?>
                var type = "<?php echo $_SESSION['message_type']; ?>";
                var message = "<?php echo $_SESSION['message']; ?>";
                
                // Configure toastr
                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": true,
                    "progressBar": true,
                    "positionClass": "toast-top-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                if (type === "success") {
                    toastr.success(message);
                } else if (type === "error") {
                    toastr.error(message);
                }
                
                // Clear session message after displaying
                <?php unset($_SESSION['message']); ?>
                <?php unset($_SESSION['message_type']); ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>