<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>লোন সার্ভিস নোটিশ</title>
  <style>
    body{
      margin:0; padding:0; font-family: 'Segoe UI', sans-serif;
      display:flex; justify-content:center; align-items:center;
      height:100vh; text-align:center;
      background:linear-gradient(135deg, #06b6d4, #3b82f6);
      color:#111827; overflow:hidden;
    }
    .notice{
      background:#ffffffdd; padding:40px 30px; border-radius:16px;
      box-shadow:0 8px 20px rgba(0,0,0,.15);
      max-width:420px; position:relative;
      animation: float 3s ease-in-out infinite;
    }
    h1{font-size:1.8rem; margin-bottom:12px; color:#1e3a8a;}
    p{margin:8px 0; font-size:1.05rem; color:#374151;}
    .status{
      display:inline-block; margin:18px 0; padding:8px 18px;
      border-radius:24px; font-weight:bold; font-size:1rem;
      background:#fef3c7; color:#92400e; border:1px solid #fcd34d;
      animation: pulse 2s infinite;
    }
    @keyframes pulse{
      0%{transform:scale(1); opacity:1}
      50%{transform:scale(1.08); opacity:.8}
      100%{transform:scale(1); opacity:1}
    }
    @keyframes float{
      0%{ transform:translateY(0px)}
      50%{ transform:translateY(-10px)}
      100%{ transform:translateY(0px)}
    }
    .bubble{
      position:absolute; border-radius:50%; background:rgba(255,255,255,.15);
      animation: rise 12s linear infinite;
    }
    @keyframes rise{
      0%{transform:translateY(100vh) scale(0.5); opacity:0}
      50%{opacity:0.6}
      100%{transform:translateY(-20vh) scale(1); opacity:0}
    }
  </style>
</head>
<body>
  <div class="notice">
    <h1>লোন সার্ভিস নোটিশ</h1>
    <p class="status">অপাতত বন্ধ আছে</p>
    <p>চালু হলে জানানো হবে।</p>
  </div>

  <script>
    // Bubble animation generator
    for(let i=0; i<12; i++){
      let b=document.createElement('div');
      b.className='bubble';
      let size=Math.random()*40+20;
      b.style.width=size+'px'; b.style.height=size+'px';
      b.style.left=Math.random()*100+'%';
      b.style.animationDuration=(8+Math.random()*6)+'s';
      document.body.appendChild(b);
    }
  </script>
</body>
</html>
