<?php
session_start();
include('db.php'); // Your database connection

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id']; // Current logged-in user

// Fetch the offer details based on the offer ID passed in the URL
$offerId = isset($_GET['id']) ? $_GET['id'] : null;

if ($offerId) {
    $offerQuery = $conn->prepare("SELECT * FROM offers WHERE id = ?");
    $offerQuery->bind_param("i", $offerId);
    $offerQuery->execute();
    $offerResult = $offerQuery->get_result();
    $offer = $offerResult->fetch_assoc();
    
    if (!$offer) {
        echo "Offer not found!";
        exit;
    }
} else {
    echo "Invalid Offer!";
    exit;
}

$balanceError = '';
$successMessage = '';
$pinError = '';
$userBalance = 0;

// Fetch user data (balance and PIN) from the database
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];

// Handle the form submission for mobile recharge
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mobileNumber = $_POST['mobile_number'];
    $reference = $_POST['reference'];
    $enteredPin = $_POST['pin'];

    // Verify the entered PIN
    if ($enteredPin !== $userPin) {
        $pinError = "Invalid PIN!";
    } elseif ($offer['price'] > $userBalance) {
        // Check if the user has enough balance
        $balanceError = "Insufficient balance!";
    } else {
        // Deduct the offer price from the user's balance
        $newBalance = $userBalance - $offer['price'];
        $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
        $updateBalanceQuery->bind_param("di", $newBalance, $userId);
        $updateBalanceQuery->execute();

        // Ensure you have the correct field for offer name in the offers table
        $offerName = $offer['offer_name']; // Make sure this column exists in your offers table

        // Insert the transaction record
        $insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, offer_name, account_number, amount, reference, status, title, type) VALUES (?, ?, ?, ?, ?, 'pending', 'SIM OFFER', 'other')");
        $insertTransactionQuery->bind_param("issds", $userId, $offerName, $mobileNumber, $offer['price'], $reference);
        $insertTransactionQuery->execute();

        // Set success message and trigger the redirect
        
        function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );

    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );

    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }

    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Drive Offer)";
$response = sendOneSignalNotificationToAll($title, $message);

        $successMessage = "Payment Successful!";
        echo "<script>
                setTimeout(function(){
                    window.location.href = 'dashboard.php';
                }, 800);
              </script>";
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Offer Details</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #4CAF50;
            color: white;
            padding: 1px 7px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            height: 50px;
        }
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
        }
        .back-icon img {
            width: 18px;
            height: 18px;
            margin-right: 8px;
        }
        .header h3 {
            font-size: 20px;
            margin-left: -60px;
        }
        .balance {
            font-size: 14px;
            background-color: #2E7D32;
            padding: 5px 10px;
            border-radius: 12px;
            display: flex;
            align-items: center;
        }
       .main-container {
            max-width: 800px;
            margin: 20px auto;
            background-color: #fff;
            padding: 15px;
            margin: 10px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        /* Offer Details Container */
        .offer-details-container {
            background-color: #f0f4c3;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        .offer-name {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .price {
            font-size: 18px;
            color: #4CAF50;
            font-weight: bold;
        }
        /* Form Container */
        .form-container {
            padding: 15px;
            background-color: #e8f5e9;
            border-radius: 8px;
        }
        .form-container input {
            width: 91.5%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }
        .submit-btn {
            background-color: #4CAF50;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            width: calc(100% - 40px);
            margin: 20px auto 0;
            display: block;
        }
        .error {
            color: red;
            font-size: 14px;
        }
        .success {
            color: green;
            font-size: 14px;
        }
        /* Pop-up styling */
        .popup {
            visibility: hidden;
            position: fixed;
            top: -200px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            width: 300px;
            z-index: 100;
            transition: top 0.5s ease;
        }
        .popup.show {
            visibility: visible;
            top: 20px;
        }
        .popup h4 {
            margin-top: 0;
            text-align: center;
            font-size: 20px;
        }
        .popup input {
            padding: 10px;
            width: 100%;
            margin-bottom: 15px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .verify-btn, .close-btn {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            width: 100%;
            cursor: pointer;
            font-size: 16px;
        }
        .close-btn {
            background-color: #f44336;
            margin-top: 10px;
        }
        /* Toast styles */
        .toast {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #4CAF50;
            color: white;
            text-align: center;
            border-radius: 5px;
            padding: 10px;
            position: fixed;
            z-index: 1;
            left: 50%;
            bottom: 0; /* Start at the very bottom */
            font-size: 17px;
            opacity: 0; /* Start with invisible */
            transition: bottom 0.5s ease-in-out, opacity 0.5s ease-in-out; /* Animate bottom and opacity */
        }

        .toast.show {
            visibility: visible;
            bottom: 50px; /* Move up slightly */
            opacity: 1; /* Fade in */
        }

        @keyframes fadeout {
            from {bottom: 50px; opacity: 1;}
            to {bottom: 0; opacity: 0;}
        }

        .white-image {
            filter: brightness(0) invert(1);
            height: 28px !important;
            width: 28px !important;
        }
    </style>
    <script>
        function showPopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.add('show');
            window.scrollTo(0, 0); // Scroll to top for visibility
        }

        function closePopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.remove('show');
        }
    </script>
</head>
<body>

    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
    <img src="https://cdn-icons-png.flaticon.com/512/93/93634.png" alt="Back" class="white-image">
</div>

        <h3>Offer Details</h3>
        <div class="balance">
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>

    <!-- Main Container -->
    <div class="main-container">
        
        <!-- Offer Details Container -->
        <div class="offer-details-container">
            <div class="offer-name"><?php echo htmlspecialchars($offer['offer_name']); ?></div>
            <div class="price">৳<?php echo number_format($offer['price'], 2); ?></div>
        </div>

        <!-- Form Container -->
        <div class="form-container">
            <form method="POST">
                <input type="tel" name="mobile_number" placeholder="Enter Mobile Number" maxlength="11" pattern="\d{11}" required>
                <input type="text" name="reference" placeholder="Reference (Optional)">
                <button type="button" class="submit-btn" onclick="showPopup()">Submit</button>

                <!-- Pop-up for PIN verification -->
                <div class="popup" id="pinPopup">
                    <h4>Enter PIN</h4>
                    <input type="password" name="pin" placeholder="Enter your 4-digit PIN" required>
                    <button class="verify-btn" type="submit">Verify</button>
                    <button class="close-btn" type="button" onclick="closePopup()">Close</button>
                </div>
            </form>
        </div>

        <!-- Display errors or success -->
        <?php if ($balanceError): ?>
            <div class="error"><?php echo $balanceError; ?></div>
        <?php endif; ?>
        <?php if ($pinError): ?>
            <div class="error"><?php echo $pinError; ?></div>
        <?php endif; ?>
        <?php if ($successMessage): ?>
            <div class="success"><?php echo $successMessage; ?></div>
        <?php endif; ?>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="toast">Payment Successful!</div>

</body>
</html>
