<?php
// Start the session
session_start();
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    // If the user is not logged in, redirect to the login page
    header("Location: login.php");
    exit;
}
if (isset($_SESSION['tt']) && $_SESSION['tt'] === 'rayhan') {
    // Admin user
    $is_admin = true;
} else {
    $is_admin = false;
}
// Include the database connection
include('db.php');
// Handle image deletion (only for admin)
if (isset($_GET['delete_id']) && $is_admin) {
    $id = $_GET['delete_id'];
    
    // Get image path before deletion
    $sql = "SELECT image_url FROM banners WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    if ($row) {
        $imagePath = $row['image_url'];
        
        // Delete from database
        $sql = "DELETE FROM banners WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            // Delete file from server
            if (file_exists($imagePath)) {
                unlink($imagePath);
            }
            $delete_success = "Image deleted successfully!";
        } else {
            $delete_error = "Error deleting image: " . $conn->error;
        }
    }
}
// Fetch notice from the database
$sql = "SELECT home FROM settings WHERE id = 1";
$result = $conn->query($sql);
$settings = $result->fetch_assoc();
$notice = $settings['home'] ?? '';
// Fetch notices from the database
$sql = "SELECT message FROM notices ORDER BY created_at DESC";
$result = $conn->query($sql);
$notices = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $notices[] = $row['message'];
    }
}
// Convert notices array to a single string for display
$scrollingText = implode(' | ', $notices);
// Check if the popup should be shown (based on session)
$showPopup = !isset($_SESSION['notice']);
// If the popup is dismissed, set the session 'notice' to true
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['dismiss_popup'])) {
    $_SESSION['notice'] = true;
    echo json_encode(['status' => 'Popup dismissed']);
    exit;
}
// Fetch the logged-in user information including the PIN
$sql = "SELECT name, balance, reward_points, profile_image, pin FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
// If no user is found, redirect to the login page
if (!$user) {
    $_SESSION['message'] = "User not found!";
    $_SESSION['message_type'] = "error";
    header("Location: login.php");
    exit;
}
// Check if the user has no PIN
if (empty($user['pin'])) {
    // Store a session variable to indicate PIN setup
    $_SESSION['setup_pin'] = true;
    header("Location: pin.php");
    exit;
}
// Fetch banners from the database
$sql_banners = "SELECT id, image_url FROM banners ORDER BY id DESC";
$stmt_banners = $conn->prepare($sql_banners);
$stmt_banners->execute();
$result_banners = $stmt_banners->get_result();
$banners = $result_banners->fetch_all(MYSQLI_ASSOC);
// Add the hardcoded images to the banners array
$hardcoded_images = [
    ['id' => -1, 'image_url' => 'https://ibb.co.com/vxwJxQzY'],
    ['id' => -2, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-2.png'],
    ['id' => -3, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-3.png'],
    ['id' => -4, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-4.png'],
    ['id' => -5, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-5.png'],
    ['id' => -6, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-5.png'],
];
// Merge database banners with hardcoded images
$all_banners = array_merge($banners, $hardcoded_images);
// Array of recipient users (this data could also come from the database if needed)
$recipients = [
    ['name' => 'Dubai', 'image' => 'https://flagcdn.com/w320/ae.png'],
    ['name' => 'Qatar', 'image' => 'https://www.countryflags.com/wp-content/uploads/qatar-flag-png-large.png'],
    ['name' => 'Saudi Arab', 'image' => 'https://flagcdn.com/w320/sa.png'], 
    ['name' => 'Malaysia', 'image' => 'https://flagcdn.com/w320/my.png'],
    ['name' => 'Oman', 'image' => 'https://www.countryflags.com/wp-content/uploads/oman-flag-png-large.png'],
    ['name' => 'Bahrain', 'image' => 'https://flagpedia.net/data/flags/w580/bh.webp'],
    ['name' => 'Kuwait', 'image' => 'https://flagpedia.net/data/flags/w580/kw.webp'],
];
?>
<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Ramit Wallet — Home</title>
  <style>
    :root{
      --teal: #14b8a6;
      --teal-dark: #0f766e;
      --teal-light: #5eead4;
      --teal-soft: #ccfbf1;
      --muted: #6b6b6b;
      --bg: #f5f6f8;
      --card: #ffffff;
      --soft: #e0f2fe;
      --nav-height: 64px;
      font-family: "Noto Sans", "Noto Sans Bengali", system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
    }
    /* Reset */
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0;
      background:var(--bg);
      color:#111;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
      line-height:1.3;
    }
    /* App frame (centered mobile width) */
    .device{
      width:100%;
      max-width:420px;
      margin:8px auto 24px;
      background:var(--card);
      border-radius:14px;
      overflow:hidden;
      box-shadow:0 8px 30px rgba(20,20,30,0.08);
      border:1px solid rgba(0,0,0,0.04);
      min-height: calc(100vh - 40px);
      display:flex;
      flex-direction:column;
    }
    /* Topbar */
    .topbar{
      background: linear-gradient(135deg, var(--teal), var(--teal-dark));
      color:#fff;
      padding:16px 16px;
      display:flex;
      gap:12px;
      align-items:center;
      position: relative;
      overflow: hidden;
    }
    .topbar::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -50%;
      width: 200%;
      height: 200%;
      background: radial-gradient(circle, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0) 70%);
      z-index: 1;
    }
    .dp{
      width:50px;
      height:50px;
      border-radius:50%;
      background: #fff;
      display:flex;
      align-items:center;
      justify-content:center;
      font-weight:700;
      color:var(--teal-dark);
      font-size:13px;
      flex:0 0 50px;
      box-shadow:0 4px 12px rgba(0,0,0,0.15);
      border: 2px solid rgba(255,255,255,0.3);
      overflow: hidden;
      z-index: 2;
      position: relative;
    }
    .dp img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }
    .top-info{
      flex:1;
      z-index: 2;
      position: relative;
    }
    .top-info .acc{
      font-size:16px;
      font-weight:700;
      margin-bottom:2px;
    }
    .top-info .sub{
      font-size:13px;
      opacity:0.95;
      height: 36px; /* Fixed height for the balance button */
      position: relative;
      overflow: hidden;
      display: flex;
      align-items: center;
    }
    .balance-btn{
      background:rgba(255,255,255,0.2);
      backdrop-filter: blur(5px);
      padding:4px 10px;
      border-radius:16px;
      font-weight:600;
      font-size:12px;
      white-space: nowrap;
      cursor: pointer;
      position: relative;
      overflow: hidden;
      width: auto;
      text-align: center;
      border: 1px solid rgba(255,255,255,0.2);
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      transition: all 0.3s ease;
      display: inline-flex;
      align-items: center;
      gap: 4px;
    }
    .balance-btn:hover {
      background: rgba(255,255,255,0.3);
      transform: translateY(-1px);
    }
    .balance-btn:active {
      transform: scale(0.98);
    }
    .balance-icon {
      font-size: 10px;
      opacity: 0.8;
    }
    .balance-value {
      display: inline-block;
      transition: transform 0.5s ease, opacity 0.5s ease;
    }
    .balance-hidden {
      transform: translateY(100%);
      opacity: 0;
      position: absolute;
    }
    .balance-visible {
      transform: translateY(0);
      opacity: 1;
    }
    .top-action{
      width:40px;
      height:40px;
      border-radius:50%;
      background:rgba(255,255,255,0.2);
      backdrop-filter: blur(5px);
      display:flex;
      align-items:center;
      justify-content:center;
      font-size:16px;
      border: 1px solid rgba(255,255,255,0.2);
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      z-index: 2;
      position: relative;
    }
    .notification-badge {
      position: absolute;
      top: -2px;
      right: -2px;
      background: #ff4757;
      color: white;
      border-radius: 50%;
      width: 16px;
      height: 16px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 9px;
      font-weight: bold;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    /* Grid of features */
    .features{
      padding:14px;
      display:grid;
      grid-template-columns:repeat(4,1fr);
      gap:14px;
      background:var(--card);
    }
    .feature{
      text-align:center;
      user-select:none;
    }
    .feature .round{
      width:56px;height:56px;border-radius:12px;
      display:flex;align-items:center;justify-content:center;margin:0 auto 8px;
      background:linear-gradient(180deg,#fff,#fff);
      box-shadow:0 2px 6px rgba(0,0,0,0.04);
      font-size:20px;
    }
    .feature span{display:block;font-size:13px;color:#111}
    /* small banner */
    .banner{
      margin:8px 14px 0;
      background:#0b0b0b;color:#fff;padding:10px;border-radius:8px;text-align:center;font-weight:600;font-size:13px;
      overflow:hidden;
      white-space:nowrap;
    }
    .banner .notice-text {
      display:inline-block;
      padding-left:100%;
      animation:scroll 30s linear infinite;
    }
    @keyframes scroll {
      0% { transform: translateX(0); }
      100% { transform: translateX(-100%); }
    }
    /* Section card */
    .card{
      margin:10px 14px;
      background:var(--card);
      padding:12px;
      border-radius:10px;
      box-shadow:0 2px 6px rgba(0,0,0,0.03);
    }
    .card .title{font-weight:700;margin-bottom:10px;color:#222;font-size:14px}
    /* Mobile banking row (with logos requested) */
    .banks{
      display:flex;
      gap:12px;
      align-items:center;
      justify-content:space-between;
    }
    .bank{
      flex:1;
      text-align:center;
      font-size:12px;
      color:#111;
    }
    .bank img{
      width:56px;height:56px;border-radius:10px;object-fit:contain;background:#fff;border:1px solid rgba(0,0,0,0.03);padding:6px;
      box-shadow:0 2px 6px rgba(0,0,0,0.03);
    }
    .bank span{display:block;margin-top:8px;font-size:13px}
    /* Promo Slider */
    .promo-slider {
      margin-top: 12px;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }
    .promo-slide img {
      width: 100%;
      height: 180px;
      object-fit: cover;
      display: block;
    }
    /* Currency flags row */
    .rates{
      display:flex;gap:12px;overflow:auto;padding:8px 0;margin-top:8px;
    }
    .rate{min-width:68px;text-align:center}
    .flag{
      width:64px;height:38px;border-radius:8px;background:#fff;display:flex;align-items:center;justify-content:center;font-size:18px;margin:0 auto 6px;border:1px solid rgba(0,0,0,0.03)
    }
    .flag img {
      width:100%;
      height:100%;
      object-fit:cover;
      border-radius:8px;
    }
    .rate span{font-size:12px;color:#111}
    /* bottom nav */
    .spacer{height:var(--nav-height)} /* keep content above nav */
    .bottom{
      position:fixed;
      left:50%;
      transform:translateX(-50%);
      bottom:12px;
      width:calc(100% - 40px);
      max-width:420px;
      background:linear-gradient(180deg,#fff,#fafafa);
      border-radius:20px;
      box-shadow:0 10px 30px rgba(20,20,30,0.08);
      display:flex;
      justify-content:space-around;
      align-items:center;
      padding:8px 0;
      border:1px solid rgba(0,0,0,0.04);
      z-index:60;
      height:var(--nav-height);
      overflow:hidden;
    }
    .nav-item{
      flex:1;
      text-align:center;
      font-size:11px;
      color:var(--muted);
      display:flex;
      flex-direction:column;
      align-items:center;
      justify-content:center;
      gap:4px;
      transition:all .3s ease;
      user-select:none;
      position:relative;
      padding:8px 0;
    }
    .nav-item::before {
      content: '';
      position: absolute;
      top: 0;
      left: 50%;
      transform: translateX(-50%);
      width: 0;
      height: 3px;
      background: var(--teal);
      border-radius: 3px;
      transition: width 0.3s ease;
    }
    .nav-item.active::before {
      width: 24px;
    }
    .nav-item.active {
      color: var(--teal);
    }
    .nav-icon {
      width: 24px;
      height: 24px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-bottom: 2px;
      transition: all 0.3s ease;
    }
    .nav-icon img {
      width: 24px;
      height: 24px;
      display: block;
      transition: all 0.3s ease;
    }
    .nav-item.active .nav-icon {
      transform: translateY(-2px);
    }
    .nav-label {
      font-size:12px;
      transition: all 0.3s ease;
    }
    .nav-item.active .nav-label {
      font-weight: 600;
    }
    /* hover & touch */
    .feature:active .round, .nav-item:active {
      transform:scale(0.95);
    }
    .nav-item:hover {
      color: var(--teal);
    }
    .nav-item:hover .nav-icon {
      transform: translateY(-2px);
    }
    a{color:inherit;text-decoration:none}
    /* Popup Notice */
    .popup-overlay {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.5);
      z-index: 1000;
      animation: fadeIn 0.3s ease;
    }
    .popup-overlay.show {
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }
    .popup-notice {
      background: white;
      border-radius: 12px;
      padding: 20px;
      max-width: 90%;
      width: 350px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
      animation: slideUp 0.3s ease;
    }
    @keyframes slideUp {
      from { 
        opacity: 0;
        transform: translateY(30px);
      }
      to { 
        opacity: 1;
        transform: translateY(0);
      }
    }
    .popup-header {
      text-align: center;
      margin-bottom: 15px;
    }
    .popup-title {
      font-size: 18px;
      font-weight: 600;
      color: var(--teal-dark);
      margin-bottom: 5px;
    }
    .popup-content {
      font-size: 14px;
      color: var(--muted);
      line-height: 1.6;
      margin-bottom: 15px;
    }
    .popup-close {
      background: var(--teal);
      color: white;
      border: none;
      border-radius: 25px;
      padding: 10px 25px;
      font-weight: 600;
      cursor: pointer;
      transition: all .18s ease;
      display: block;
      margin: 0 auto;
      font-size: 14px;
    }
    .popup-close:hover {
      background: var(--teal-dark);
    }
    /* responsive small */
    @media (max-width:420px){
      .device{border-radius:8px}
      .bank img{width:52px;height:52px}
      .nav-icon img{width:22px;height:22px}
    }
  </style>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
</head>
<body>
  <div class="device" role="application" aria-label="Ramit Wallet">
    <!-- topbar -->
    <div class="topbar">
      <div class="dp">
        <img src="image/logo.jpg" alt="Profile">
      </div>
      <div class="top-info" aria-hidden="false">
        <div class="acc"><?php echo $user['name']; ?></div>
        <div class="sub">
          <div class="balance-btn" id="balanceBtn">
            <span class="balance-icon">৳</span>
            <span class="balance-value balance-visible" id="balanceHidden">চেক ব্যালেন্স</span>
            <span class="balance-value balance-hidden" id="balanceVisible"><?php echo number_format($user['balance'], 2); ?></span>
          </div>
        </div>
      </div>
      <div class="top-action" title="Notifications">
        <i class="fas fa-bell"></i>
        <span class="notification-badge">2</span>
      </div>
    </div>
    
    <!-- features grid - First Row -->
    <div class="features" role="list">
      <div class="feature" role="listitem">
        <a href="addmoney.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="/image/addmoney.jpg" alt="অ্যাড মানি" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>অ্যাড মানি</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="sendmoney.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="/image/s.jpg" alt="সেন্ড মানি" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>সেন্ড মানি</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="drive.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="icon/offer.png" alt="ড্রাইভ অফার" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>ড্রাইভ অফার</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="recharge.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="/image/r.jpg" alt="মোবাইল রিচার্জ" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>মোবাইল রিচার্জ</span>
        </a>
      </div>
    </div>
    
    <!-- features grid - Second Row -->
    <div class="features" role="list">
      <div class="feature" role="listitem">
        <a href="coin.php?id=1" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="img/20240915_220918.png" alt="স্পেশাল অফার" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>স্পেশাল অফার</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="reward_convert.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="icon/reward.png" alt="কমিশন" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>কমিশন</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="loan.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="https://e7.pngegg.com/pngimages/873/511/png-clipart-computer-icons-loan-finance-bank-donate-text-trademark.png" alt="লোন" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>লোন</span>
        </a>
      </div>
      <div class="feature" role="listitem">
        <a href="paybill.php" style="text-decoration:none;color:inherit">
          <div class="round">
            <img src="/icon/paybill.png" alt="পে বিল" style="width:40px;height:40px;border-radius:50%;">
          </div>
          <span>পে বিল</span>
        </a>
      </div>
    </div>
    
    <!-- small banner -->
    <?php if (!empty($scrollingText)): ?>
    <div class="banner">
      <div class="notice-text"><?php echo htmlspecialchars($scrollingText); ?></div>
    </div>
    <?php endif; ?>
    
    <!-- cards -->
    <div class="card" style="margin-top:10px">
      <div class="title">মোবাইল ব্যাংকিং</div>
      <!-- BANK LOGOS -->
      <div class="banks" aria-hidden="false">
        <div class="bank" title="bKash">
          <a href="m-bank.php?id=2">
            <img src="icon/bkash.png" alt="bKash logo">
            <span>বিকাশ</span>
          </a>
        </div>
        <div class="bank" title="Nagad">
          <a href="m-bank.php?id=3">
            <img src="icon/nagad.png" alt="Nagad logo">
            <span>নগদ</span>
          </a>
        </div>
        <div class="bank" title="Rocket">
          <a href="m-bank.php?id=4">
            <img src="icon/rocket.png" alt="Rocket logo">
            <span>রকেট</span>
          </a>
        </div>
        <div class="bank" title="Upay">
          <a href="bank.php">
            <img src="icon/mobile-banking.png" alt="Upay logo">
            <span>ব্যাংক</span>
          </a>
        </div>
      </div>
      
      <!-- Promo Slider with 6 images -->
      <div class="promo-slider">
        <div class="swiper">
          <div class="swiper-wrapper">
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/1.png
" alt="Promo 1">
              </div>
            </div>
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/2.png
" alt="Promo 2">
              </div>
            </div>
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/3.png
" alt="Promo 3">
              </div>
            </div>
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/4.png
" alt="Promo 4">
              </div>
            </div>
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/5.png
" alt="Promo 5">
              </div>
            </div>
            <div class="swiper-slide">
              <div class="promo-slide">
                <img src="image/banner/6.png
" alt="Promo 6">
              </div>
            </div>
          </div>
          <div class="swiper-pagination"></div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
      </div>
    </div>
    
    <div class="card" style="margin-top:8px">
      <div class="title">আজকে আমাদের কোম্পানির চলমান রেট সমূহ</div>
      <div class="rates" aria-hidden="false">
        <?php foreach ($recipients as $recipient): ?>
        <div class="rate">
          <a href="/country/<?php echo strtolower(str_replace(' ', '', $recipient['name'])); ?>.php" style="text-decoration:none;color:inherit">
            <div class="flag">
              <img src="<?php echo $recipient['image']; ?>" alt="<?php echo $recipient['name']; ?>">
            </div>
            <span><?php echo $recipient['name']; ?></span>
          </a>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
    
    <div class="spacer"></div> <!-- keep space for bottom nav -->
    
    <!-- bottom nav (fixed floating bar) -->
    <nav class="bottom" role="navigation" aria-label="main navigation">
      <a href="/" class="nav-item active">
        <div class="nav-icon">
          <img src="https://img.icons8.com/fluency-systems-filled/48/000000/home.png" alt="home icon">
        </div>
        <div class="nav-label">হোম</div>
      </a>
      <a href="profile.php" class="nav-item">
        <div class="nav-icon">
          <img src="https://img.icons8.com/fluency-systems-filled/48/000000/user-male-circle.png" alt="profile icon">
        </div>
        <div class="nav-label">প্রোফাইল</div>
      </a>
      <a href="history.php" class="nav-item">
        <div class="nav-icon">
          <img src="https://img.icons8.com/fluency-systems-filled/48/000000/time-machine.png" alt="history icon">
        </div>
        <div class="nav-label">হিস্ট্রি</div>
      </a>
      <a href="helpline.php" class="nav-item">
        <div class="nav-icon">
          <img src="https://img.icons8.com/fluency-systems-filled/48/000000/phone.png" alt="help icon">
        </div>
        <div class="nav-label">হেল্পলাইন</div>
      </a>
    </nav>
  </div>
  
  <!-- Popup Notice -->
  <div class="popup-overlay" id="popupOverlay">
    <div class="popup-notice">
      <div class="popup-header">
        <h2 class="popup-title">আজকের নোটিশ</h2>
      </div>
      <div class="popup-content">
        <?php echo nl2br(htmlspecialchars($notice)); ?>
      </div>
      <button class="popup-close" id="closePopup">বন্ধ করুন</button>
    </div>
  </div>
  
  <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>
  <script>
    // Initialize Swiper slider for promo section
    const promoSwiper = new Swiper('.promo-slider .swiper', {
      slidesPerView: 1,
      spaceBetween: 0,
      loop: true,
      autoplay: {
        delay: 3000,
        disableOnInteraction: false,
      },
      pagination: {
        el: '.swiper-pagination',
        clickable: true,
      },
      navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
      },
    });
    
    // Balance reveal functionality
    document.getElementById('balanceBtn').addEventListener('click', function() {
      const hidden = document.getElementById('balanceHidden');
      const visible = document.getElementById('balanceVisible');
      
      hidden.classList.remove('balance-visible');
      hidden.classList.add('balance-hidden');
      
      visible.classList.remove('balance-hidden');
      visible.classList.add('balance-visible');
      
      // Auto-hide after 5 seconds
      setTimeout(() => {
        visible.classList.remove('balance-visible');
        visible.classList.add('balance-hidden');
        
        hidden.classList.remove('balance-hidden');
        hidden.classList.add('balance-visible');
      }, 5000);
    });
    
    // Popup functionality
    const popupOverlay = document.getElementById('popupOverlay');
    const closePopup = document.getElementById('closePopup');
    const notificationBtn = document.querySelector('.top-action');
    
    let showPopup = <?php echo $showPopup ? 'true' : 'false'; ?>;
    
    if (showPopup) {
      setTimeout(() => {
        popupOverlay.classList.add('show');
      }, 1000);
    }
    
    closePopup.addEventListener('click', () => {
      popupOverlay.classList.remove('show');
      fetch('', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'dismiss_popup=true'
      }).then(response => response.json())
        .then(data => console.log('Popup dismissed'));
    });
    
    notificationBtn.addEventListener('click', () => {
      popupOverlay.classList.add('show');
    });
    
    // Close popup when clicking outside
    popupOverlay.addEventListener('click', (e) => {
      if (e.target === popupOverlay) {
        popupOverlay.classList.remove('show');
      }
    });
    
    // Small JS for interactions:
    // 1) Feature click bounce
    (function(){
      // feature press animation
      document.querySelectorAll('.feature').forEach(function(f){
        f.addEventListener('click', function(){
          var r = this.querySelector('.round');
          r.style.transform = 'scale(0.96)';
          setTimeout(function(){ r.style.transform = ''; }, 120);
        });
      });
      
      // lazy fallback for images that sometimes 404: replace with placeholder
      document.querySelectorAll('img').forEach(function(img){
        img.addEventListener('error', function(){
          // tiny neutral placeholder
          this.src = 'data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"120\" height=\"120\"><rect width=\"100%\" height=\"100%\" fill=\"%23f4f4f4\"/><text x=\"50%\" y=\"50%\" dominant-baseline=\"middle\" text-anchor=\"middle\" fill=\"%23999\" font-size=\"14\">image</text></svg>';
        });
      });
    })();
  </script>
</body>
</html>