<?php
include 'db.php'; // Include the database connection
// Fetch the current content from the database
$sql = "SELECT content FROM currency_texts WHERE id = 6"; // Bahrain এর জন্য ID পরিবর্তন করা হয়েছে
$result = $conn->query($sql);
$row = $result->fetch_assoc();
$current_content = $row['content'];
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bahrain Rate</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .card {
            width: 400px;
            height: 615px;
            margin: 50px auto;
            border-radius: 15px;
            background-color: #f6fcfe;
            box-shadow: 0px 20px 70px 0px rgba(0,0,0,0.21);
            position: relative;
            overflow: hidden;
        }
        
        .card .inside {
            text-align: center;
            position: absolute;
            left: 0;
            right: 0;
            top: 50%;
            margin-top: -120px;
            font-weight: 600;
            z-index: 1;
            background: rgba(255, 255, 255, 0.95);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transform: translateY(20px);
            opacity: 0;
            transition: all 0.5s ease-in-out;
            backdrop-filter: blur(10px);
        }
        
        .pCard_on .inside {
            transform: translateY(0);
            opacity: 1;
        }
        
        .card .upside {
            position: absolute;
            width: 100%;
            height: 437px;
            background-image: url('https://upload.wikimedia.org/wikipedia/commons/thumb/2/2c/Flag_of_Bahrain.svg/1280px-Flag_of_Bahrain.svg.png');
            background-position: center;
            background-size: cover;
            z-index: 3;
            text-align: center;
            transition: 0.5s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        
        .card .upside::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }
        
        .pCard_on .upside {
            height: 100px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.2);
        }
        
        .card .upside .text {
            position: absolute;
            top: 320px;
            left: 0;
            right: 0;
            color: #fff;
            transition: 0.5s ease-in-out;
            z-index: 2;
        }
        
        .pCard_on .upside .text {
            top: 20px;
        }
        
        .card .upside .text h2 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            letter-spacing: 1px;
            color: #fff;
        }
        
        .card .upside .text p {
            margin: 10px 0 0;
            font-size: 16px;
            color: #f0f0f0;
            font-weight: 500;
            background: rgba(0, 0, 0, 0.3);
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            backdrop-filter: blur(5px);
        }
        
        .card .upside .add {
            border-radius: 50%;
            background: linear-gradient(135deg, #6615a8 0%, #4a0d7a 100%);
            box-shadow: 0px 5px 24px 0px rgba(102, 21, 168, 0.4);
            position: absolute;
            top: 392px;
            left: 0;
            right: 0;
            margin: auto;
            width: 70px;
            height: 70px;
            cursor: pointer;
            transition: 0.5s ease-in-out;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 4;
        }
        
        .card .upside .add:hover {
            transform: scale(1.1);
        }
        
        .pCard_on .upside .add {
            transform: rotate(360deg) scale(0.7);
            top: 470px;
        }
        
        .card .upside .add i {
            color: white;
            font-size: 28px;
            line-height: 1;
            transition: 0.3s ease;
        }
        
        .card .bottom {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            position: absolute;
            bottom: 0px;
            width: 100%;
            height: 178px;
            z-index: 2;
            transition: 0.5s ease-in-out;
            display: flex;
            justify-content: space-around;
            padding: 0 20px;
            border-top: 1px solid #eee;
        }
        
        .pCard_on .bottom {
            height: 100px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.1);
        }
        
        .card .bottom div {
            width: 33.333%;
            text-align: center;
            margin-top: 50px;
            font-size: 18px;
            transition: 0.5s ease-in-out;
        }
        
        .pCard_on .bottom div {
            margin-top: 15px;
        }
        
        .card .bottom div p:first-of-type {
            color: #68818c;
            margin-bottom: 8px;
            font-size: 16px;
            font-weight: 500;
        }
        
        .card .bottom div p:last-of-type {
            color: #334750;
            font-weight: 700;
            margin-top: 0;
            font-size: 18px;
        }
        
        .card .inside p {
            margin-bottom: 20px;
            color: #334750;
            font-size: 18px;
        }
        
        .card .inside .social-links {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .card .inside a {
            margin: 0 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            transition: 0.3s ease;
        }
        
        .card .inside a i {
            font-size: 22px;
            transition: 0.3s ease;
        }
        
        .card .inside a:hover {
            transform: translateY(-5px);
        }
        
        .card .inside a:nth-of-type(1) {
            color: #3b5998;
            border: 2px solid #3b5998;
        }
        
        .card .inside a:nth-of-type(1):hover {
            background: #3b5998;
            color: white;
        }
        
        .card .inside a:nth-of-type(2) {
            color: #25D366;
            border: 2px solid #25D366;
        }
        
        .card .inside a:nth-of-type(2):hover {
            background: #25D366;
            color: white;
        }
        
        .card .inside a:nth-of-type(3) {
            color: #0088cc;
            border: 2px solid #0088cc;
        }
        
        .card .inside a:nth-of-type(3):hover {
            background: #0088cc;
            color: white;
        }
        
        .card .inside #follow-date {
            font-size: 16px;
            color: #666;
            margin-bottom: 10px;
            font-weight: 500;
        }
        
        .card .inside p:last-of-type {
            font-size: 16px;
            color: #666;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="upside">
            <div class="text">
                <h2>Bahrain</h2>
                <p id="bahrain-time"></p> <!-- Bahrain time will be displayed here -->
            </div>
            <div class="add"><i class="fa fa-plus"></i></div>
        </div>
        <div class="bottom">
            <div>
                <p>Country</p>
                <p>Bahrain</p>
            </div>
            <div>
                <p>Dinar</p>
                <p>1 Dinar =</p>
            </div>
            <div>
                <p>BANGLADESHI</p>
                <p><?php echo htmlspecialchars($current_content); ?></p> <!-- Display content for Bahrain -->
            </div>
        </div>
        <div class="inside">
            <p>Follow us for updates</p>
            <div class="social-links">
                <a href="https://www.facebook.com" target="_blank"><i class="fa fa-facebook"></i></a>
                <a href="https://wa.me/1234567890" target="_blank"><i class="fa fa-whatsapp"></i></a>
                <a href="https://telegram.me/yourusername" target="_blank"><i class="fa fa-telegram"></i></a>
            </div>
            <p id="follow-date"></p>
            <p>Check the current rates and visit our special offers.</p>
        </div>
    </div>
    <script>
        $(function() {
            $(".add").click(function() {
                $(".card").toggleClass("pCard_on");
                $(".add i").toggleClass("fa-minus");
            });
            const today = new Date();
            const day = String(today.getDate()).padStart(2, '0');
            const month = String(today.getMonth() + 1).padStart(2, '0');
            const year = today.getFullYear();
            document.getElementById('follow-date').textContent = `আজকের তারিখ: ${day}-${month}-${year}`; // Date for Bahrain
            function updateBahrainTime() {
                const bahrainTime = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Bahrain" }));
                let bahrainHour = bahrainTime.getHours();
                const bahrainMinute = String(bahrainTime.getMinutes()).padStart(2, '0');
                const bahrainSecond = String(bahrainTime.getSeconds()).padStart(2, '0');
                
                const ampm = bahrainHour >= 12 ? 'PM' : 'AM';
                bahrainHour = bahrainHour % 12;
                bahrainHour = bahrainHour ? String(bahrainHour).padStart(2, '0') : '12';
                document.getElementById('bahrain-time').textContent = `বর্তমান সময়: ${bahrainHour}:${bahrainMinute}:${bahrainSecond} ${ampm}`; // Update Bahrain time
            }
            updateBahrainTime();
            setInterval(updateBahrainTime, 1000);
        });
    </script>
</body>
</html>