<?php
include 'db.php'; // Include the database connection

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $content = $conn->real_escape_string($_POST['content']);
    
    // Update content based on selected ID
    $sql = "UPDATE currency_texts SET content = '$content' WHERE id = $id";
    if ($conn->query($sql) === TRUE) {
        echo "<script>alert('Content updated successfully!');</script>";
    } else {
        echo "<script>alert('Error updating record: " . $conn->error . "');</script>";
    }
}

// Fetch current contents for display
$sql = "SELECT id, content FROM currency_texts"; // Ensure this matches your table name
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="style.css"> <!-- Add your custom CSS file -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h1, h2 {
            text-align: center;
            color: #333;
        }
        form {
            margin-bottom: 30px;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        label {
            font-weight: bold;
        }
        select, textarea, button {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #4cae4c;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            background: #e7f3fe;
            margin: 5px 0;
            padding: 10px;
            border-radius: 4px;
            display: flex;
            justify-content: space-between;
        }
        .content-item {
            flex: 1;
            margin-right: 10px;
        }
        .edit-icon {
            color: #007bff;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Admin Panel</h1>
        <form method="POST">
            <label for="id">Select Page:</label>
            <select name="id" id="id" required>
                <option value="1">Saudi Arabia</option>
                <option value="2">UAE</option>
                <option value="3">Qatar</option>
                <option value="4">Malaysia</option>
                <option value="5">Oman</option>
                <option value="6">Bahrain</option>
                <option value="7">Kuwait</option>
            </select>
            <label for="content">Content:</label>
            <textarea name="content" id="content" rows="5" required></textarea>
            <button type="submit">Update Content</button>
        </form>

        <h2>Current Content</h2>
        <ul>
            <?php while ($row = $result->fetch_assoc()): ?>
                <li>
                    <div class="content-item"><?php echo "ID: " . $row['id'] . " - Content: " . htmlspecialchars($row['content']); ?></div>
                    <div class="edit-icon"><i class="fas fa-edit"></i></div>
                </li>
            <?php endwhile; ?>
        </ul>
    </div>

    <?php $conn->close(); ?>
</body>
</html>
