<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('db.php'); // Your database connection

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id']; // Current logged-in user
$billId = isset($_GET['id']) ? $_GET['id'] : null;

$balanceError = '';
$pinError = '';
$successMessage = '';

// Fetch bill details
if ($billId) {
    $billQuery = $conn->prepare("SELECT name, description FROM paybills WHERE id = ?");
    $billQuery->bind_param("i", $billId);
    $billQuery->execute();
    $billResult = $billQuery->get_result();
    $bill = $billResult->fetch_assoc();
    
    if (!$bill) {
        echo "Bill not found!";
        exit;
    }
} else {
    echo "Invalid Bill!";
    exit;
}

// Fetch user balance and pin
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];

// Fetch the notice from the settings table
$settingsQuery = "SELECT bill_notice FROM settings WHERE id = 1";
$settingsResult = $conn->query($settingsQuery);
$settingsData = $settingsResult->fetch_assoc();
$notice = $settingsData['bill_notice'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accountName = $_POST['account_name'];
    $billerNumber = $_POST['biller_number'];
    $amount = $_POST['amount'];
    $reference = $_POST['reference'];
    $enteredPin = $_POST['pin'];

    // Verify the entered PIN
    if ($enteredPin !== $userPin) {
        $pinError = "Invalid PIN!";
    } elseif ($amount > $userBalance) {
        // Check if the user has enough balance
        $balanceError = "Insufficient balance!";
    } else {
        // Deduct balance
        $newBalance = $userBalance - $amount;
        $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
        $updateBalanceQuery->bind_param("di", $newBalance, $userId);
        $updateBalanceQuery->execute();

        // Insert transaction
$insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, bill_name, account_holder_name, account_number, amount, reference, status, title, type) VALUES (?, ?, ?, ?, ?, ?, 'pending', 'PAY BILL', 'other')");
$insertTransactionQuery->bind_param("isssss", $userId, $bill['name'], $accountName, $billerNumber, $amount, $reference);
$insertTransactionQuery->execute();


function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );

    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );

    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }

    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Pay Bill)";
$response = sendOneSignalNotificationToAll($title, $message);

        // Set success message and redirect
        $successMessage = "Payment Successful!";
        echo "<script>
                setTimeout(function(){
                    window.location.href = 'dashboard.php';
                }, 2000);
              </script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pay Bill</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #4CAF50;
            color: white;
            padding: 1px 7px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            height: 50px;
        }
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
        }
        .back-icon img {
            width: 18px;
            height: 18px;
            margin-right: 8px;
        }
        .header h3 {
            font-size: 20px;
            margin-left: -60px;
        }
        .balance {
            font-size: 14px;
            background-color: #2E7D32;
            padding: 5px 10px;
            border-radius: 12px;
            display: flex;
            align-items: center;
        }
        .main-container {
            max-width: 800px;
            margin: 20px auto;
            background-color: #fff;
            padding: 15px;
            margin: 10px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .notice-container {
            position: relative;
            background-color: #fff3f3;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #f44336;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .notice-container p {
            color: #f44336;
            margin: 0;
        }
        .close-icon {
            cursor: pointer;
            font-size: 18px;
            color: #f44336;
        }
        .bill-details-container {
            background-color: #f0f4c3;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        .bill-name {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .bill-type {
            font-size: 18px;
            color: #555;
        }
        .form-container {
            padding: 15px;
            background-color: #e8f5e9;
            border-radius: 8px;
        }
        .form-container input {
            width: 91.5%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }
        .submit-btn {
            background-color: #4CAF50;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            width: calc(100% - 40px);
            margin: 20px auto 0;
            display: block;
        }
        .popup {
            visibility: hidden;
            position: fixed;
            top: -200px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            width: 300px;
            z-index: 100;
            transition: top 0.5s ease;
        }
        .popup.show {
            visibility: visible;
            top: 20px;
        }
        .popup h4 {
            margin-top: 0;
            text-align: center;
            font-size: 20px;
        }
        .popup input {
            padding: 10px;
            width: 91.5%;
            margin-bottom: 15px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .verify-btn, .close-btn {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            width: 100%;
            cursor: pointer;
            font-size: 16px;
        }
        .close-btn {
            background-color: #f44336;
            margin-top: 10px;
        }
        .toast {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #4CAF50;
            color: white;
            text-align: center;
            border-radius: 5px;
            padding: 10px;
            position: fixed;
            z-index: 1;
            left: 50%;
            bottom: 30px;
            font-size: 17px;
        }

        .toast.error {
            background-color: #f44336;
        }

        .toast.show {
            visibility: visible;
            animation: fadein 0.5s, fadeout 0.5s 1.5s;
        }

        @keyframes fadein {
            from {bottom: 0; opacity: 0;}
            to {bottom: 30px; opacity: 1;}
        }

        @keyframes fadeout {
            from {bottom: 30px; opacity: 1;}
            to {bottom: 0; opacity: 0;}
        }
        .white-image {
            filter: brightness(0) invert(1);
            height: 28px !important;
            width: 28px !important;
        }
    </style>
</head>
<body>

    <!-- Header Section -->
    <div class="header">
       <div class="back-icon" onclick="history.back()">
    <img src="https://cdn-icons-png.flaticon.com/512/93/93634.png" alt="Back" class="white-image">
</div>

        <h3>Pay Bill</h3>
        <div class="balance">
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>

    <!-- Main Container -->
    <div class="main-container">
        
        <!-- Notice Container -->
        <div class="notice-container" id="noticeContainer">
            <p><?php echo htmlspecialchars($notice); ?></p>
            <span class="close-icon" onclick="closeNotice()">×</span>
        </div>

        <!-- Bill Details Container -->
        <div class="bill-details-container">
            <div class="bill-name"><?php echo htmlspecialchars($bill['name']); ?></div>
            <div class="bill-type"><?php echo htmlspecialchars($bill['description']); ?></div>
        </div>

        <!-- Form Container -->
        <div class="form-container">
            <form method="POST">
                <input type="text" name="account_name" placeholder="Account Name" required>
                <input type="text" name="biller_number" placeholder="Biller Number" required>
                <input type="number" name="amount" placeholder="Enter Amount" required>
                <input type="text" name="reference" placeholder="Reference (Optional)">
                <button type="button" class="submit-btn" onclick="showPopup()">Submit</button>
                
                <!-- Pop-up for PIN verification -->
                <div class="popup" id="pinPopup">
                    <h4>Enter PIN</h4>
                    <input type="password" name="pin" placeholder="Enter your 4-digit PIN" required>
                    <button type="submit" class="verify-btn">Verify</button>
                    <button type="button" class="close-btn" onclick="closePopup()">Close</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="toast <?php echo $pinError || $balanceError ? 'error' : ''; ?>">
        <?php echo $pinError ? $pinError : ($balanceError ? $balanceError : $successMessage); ?>
    </div>

    <script>
        function closeNotice() {
            const noticeContainer = document.getElementById('noticeContainer');
            noticeContainer.style.display = 'none';
        }

        function showPopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.add('show');
        }

        function closePopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.remove('show');
        }

        <?php if ($successMessage || $pinError || $balanceError) : ?>
        const toast = document.getElementById('toast');
        toast.className = 'toast show ' + '<?php echo $pinError || $balanceError ? "error" : ""; ?>';
        setTimeout(function() {
            toast.className = toast.className.replace('show', '');
        }, 3000);
        <?php endif; ?>
    </script>
</body>
</html>
