<?php
session_start();
include('db.php');

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Get bank ID from the URL (using GET method)
if (isset($_GET['bank_id'])) {
    $bankId = $_GET['bank_id'];
} else {
    // If no bank_id is provided, redirect or set a default bank ID
    $bankId = 1; // Default to bank id 1, or handle this case as needed
}

$userId = $_SESSION['user_id'];
$pinError = '';
$successMessage = '';
$showErrorToast = false;  // Flag to determine if error toast should be shown

// Fetch user data including balance and PIN
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];

// Fetch the notice from the settings table
$settingsQuery = "SELECT notice FROM settings WHERE id = 1";
$settingsResult = $conn->query($settingsQuery);
$settingsData = $settingsResult->fetch_assoc();
$notice = $settingsData['notice'];

// Fetch bank details for the bank with the passed id
$bankQuery = $conn->prepare("SELECT name, branch FROM banks WHERE id = ?");
$bankQuery->bind_param("i", $bankId);
$bankQuery->execute();
$bankResult = $bankQuery->get_result();
$bankData = $bankResult->fetch_assoc();
$bankName = $bankData['name'];
$branchName = $bankData['branch'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accountHolderName = $_POST['account_holder_name'];
    $accountNumber = $_POST['account_number'];
    $amount = $_POST['amount'];
    $reference = $_POST['reference'];
    $inputPin = $_POST['pin'];

    // Check if PIN is correct
    if ($inputPin === $userPin) {
        // Check if the user has enough balance
        if ($amount > $userBalance) {
            $pinError = "Insufficient balance!";
            $showErrorToast = true;
        } else {
            // Transfer is valid, deduct from sender and insert transaction
            $newBalance = $userBalance - $amount;

            // Update sender's balance
            $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $updateBalanceQuery->bind_param("di", $newBalance, $userId);
            $updateBalanceQuery->execute();

            // Insert transaction into the transaction history
            $insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, bank_name, branch_name, account_holder_name, account_number, amount, reference, title, type) VALUES (?, ?, ?, ?, ?, ?, ?, 'BANKING TRANSFER', 'mbank')");
            $insertTransactionQuery->bind_param("issssds", $userId, $bankName, $branchName, $accountHolderName, $accountNumber, $amount, $reference);
            $insertTransactionQuery->execute();
            
            function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );

    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );

    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }

    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }

    $fields = json_encode($fields);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Banking)";
$response = sendOneSignalNotificationToAll($title, $message);

            $successMessage = "Payment Successful!";
        }
    } else {
        $pinError = "Invalid PIN!";
        $showErrorToast = true;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Transfer</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8f8; /* Very light teal background */
            margin: 0;
            padding: 0;
        }
        .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #008080; /* Teal color */
        color: white;
        padding: 1px 7px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        height: 50px;
    }
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
        }
        .back-icon img {
            width: 18px;
            height: 18px;
            margin-right: 8px;
        }
        .header h3 {
        font-size: 20px;
        margin-left: -60px;
    }
        .balance {
            font-size: 14px;
            background-color: #004d40; /* Dark teal */
            padding: 5px 10px;
            border-radius: 12px;
            display: flex;
            align-items: center;
        }
        .main-container {
             max-width: 800px;
        margin: 20px auto;
        background-color: #fff;
        padding: 15px;
        margin: 10px;
        border-radius: 8px;
        box-shadow: 0 0 10px rgba(0, 128, 128, 0.1); /* Teal shadow */
    }
        /* Notice Container */
        .notice-container {
            position: relative;
            background-color: #e0fffe; /* Very light teal */
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #008080; /* Teal border */
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .notice-container p {
            color: #008080; /* Teal text */
            margin: 0;
        }
        .close-icon {
            cursor: pointer;
            font-size: 18px;
            color: #008080; /* Teal text */
        }
        /* Bank Details Container */
        .bank-details-container {
            background-color: #e0fffe; /* Very light teal */
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .bank-details div {
            margin-bottom: 8px;
            font-size: 18px;
        }
        /* Form Container */
        .form-container {
            padding: 15px;
            background-color: #e0fffe; /* Very light teal */
            border-radius: 8px;
        }
        .form-container input {
            width: 91.5%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #b2dfdb; /* Light teal border */
            border-radius: 5px;
            font-size: 16px;
        }
        .form-container input:focus {
            border-color: #008080; /* Teal focus border */
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 128, 128, 0.2); /* Teal focus shadow */
        }
        .submit-btn {
            background-color: #008080; /* Teal color */
            color: white;
            padding: 12px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            width: calc(100% - 40px);
            margin: 20px auto 0;
            display: block;
        }
        .submit-btn:hover {
            background-color: #004d40; /* Dark teal on hover */
        }
        /* Pop-up styling */
        .popup {
            visibility: hidden;
            position: fixed;
            top: -200px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 128, 128, 0.2); /* Teal shadow */
            width: 300px;
            z-index: 100;
            transition: top 0.5s ease;
        }
        .popup.show {
            visibility: visible;
            top: 20px;
        }
        .popup h4 {
            margin-top: 0;
            text-align: center;
            font-size: 20px;
            color: #008080; /* Teal text */
        }
        .popup input {
            padding: 10px;
            width: 100%;
            margin-bottom: 15px;
            font-size: 16px;
            border: 1px solid #b2dfdb; /* Light teal border */
            border-radius: 5px;
        }
        .popup input:focus {
            border-color: #008080; /* Teal focus border */
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 128, 128, 0.2); /* Teal focus shadow */
        }
        .verify-btn, .close-btn {
            background-color: #008080; /* Teal color */
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            width: 100%;
            cursor: pointer;
            font-size: 16px;
        }
        .verify-btn:hover, .close-btn:hover {
            background-color: #004d40; /* Dark teal on hover */
        }
        .close-btn {
            background-color: #f44336; /* Keep red for close button */
            margin-top: 10px;
        }
        /* Toast styles */
        .toast {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #008080; /* Teal color */
            color: white;
            text-align: center;
            border-radius: 5px;
            padding: 10px;
            position: fixed;
            z-index: 1;
            left: 50%;
            bottom: 30px;
            font-size: 17px;
        }
        .toast.show {
            visibility: visible;
            animation: fadein 0.5s, fadeout 0.5s 1.5s;
        }
        .toast.error {
            background-color: #f44336; /* Red background for errors */
        }
        @keyframes fadein {
            from {bottom: 0; opacity: 0;}
            to {bottom: 30px; opacity: 1;}
        }
        @keyframes fadeout {
            from {bottom: 30px; opacity: 1;}
            to {bottom: 0; opacity: 0;}
        }
        .white-image {
            filter: brightness(0) invert(1);
            height: 28px !important;
            width: 28px !important;
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
    <img src="https://cdn-icons-png.flaticon.com/512/93/93634.png" alt="Back" class="white-image">
</div>
        <h3>Bank Transfer</h3>
        <div class="balance">
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>
    <!-- Main Container -->
    <div class="main-container">
        
        <!-- Notice Container -->
        <div class="notice-container" id="noticeContainer">
            <p><?php echo htmlspecialchars($notice); ?></p>
            <span class="close-icon" onclick="closeNotice()">×</span>
        </div>
        <!-- Bank Details Container -->
        <div class="bank-details-container">
            <div class="bank-details">
                <div><strong>Bank Name:</strong> <?php echo htmlspecialchars($bankName); ?></div>
                <div><strong>note:</strong> <?php echo htmlspecialchars($branchName); ?></div>
            </div>
        </div>
        <!-- Form Container -->
        <div class="form-container">
            <form id="transferForm" method="POST">
                <input type="text" name="account_holder_name" placeholder="Account Holder Name" required>
                <input type="text" name="account_number" placeholder="Account Number" required>
                <input type="number" name="amount" placeholder="Enter Amount" required>
                <input type="text" name="reference" placeholder="Branch Name">
                <input type="hidden" id="pinInput" name="pin"> <!-- Hidden input for the PIN -->
                <button class="submit-btn" type="button" onclick="showPopup()">Submit</button>
            </form>
        </div>
    </div>
    <!-- Pop-up for PIN verification -->
    <div class="popup" id="pinPopup">
        <h4>Enter PIN</h4>
        <input type="password" id="pinEntry" placeholder="Enter your 4-digit PIN" required>
        <button class="verify-btn" onclick="submitForm()">Verify</button>
        <button class="close-btn" onclick="closePopup()">Close</button>
    </div>
    <!-- Toast Notification -->
    <div id="toast" class="toast"><?php echo $successMessage ? $successMessage : $pinError; ?></div>
    <script>
        // Close notice container
        function closeNotice() {
            const noticeContainer = document.getElementById('noticeContainer');
            noticeContainer.style.display = 'none';
        }
        // Show PIN popup
        function showPopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.add('show');
        }
        // Close PIN popup
        function closePopup() {
            const popup = document.getElementById('pinPopup');
            popup.classList.remove('show');
        }
        // Verify payment and show toast
        function submitForm() {
            // Set the entered PIN value into the hidden input field
            const enteredPin = document.getElementById('pinEntry').value;
            document.getElementById('pinInput').value = enteredPin;
            // Submit the form
            document.getElementById('transferForm').submit();
        }
        <?php if ($successMessage): ?>
            const toast = document.getElementById('toast');
            toast.className = 'toast show';
            setTimeout(function() {
                window.location.href = "dashboard.php"; // Redirect to dashboard after 1 second
            }, 1000);
        <?php elseif ($showErrorToast): ?>
            const toast = document.getElementById('toast');
            toast.className = 'toast show error'; // Show error toast
            setTimeout(function() {
                toast.className = toast.className.replace('show', '');
            }, 3000);
        <?php endif; ?>
    </script>
</body>
</html>