<?php
session_start();
include('db.php');
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
// Initialize variables for balance and method information
$userId = $_SESSION['user_id'];
$balance = 0;
$paymentMethod = "";
$paymentNumber = "";
$method = $_GET['method'];
// Fetch the user's balance from the database
$userQuery = $conn->prepare("SELECT balance FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
if ($userData) {
    $balance = $userData['balance'];
}
// Fetch payment method details
$paymentMethodQuery = $conn->prepare("SELECT name, payment_number FROM payment_methods WHERE name = ?");
$paymentMethodQuery->bind_param("s", $method); // Bind the $method variable as a string
$paymentMethodQuery->execute();
$paymentMethodResult = $paymentMethodQuery->get_result();
$paymentMethodData = $paymentMethodResult->fetch_assoc();
if ($paymentMethodData) {
    $paymentMethod = $paymentMethodData['name'];
    $paymentNumber = $paymentMethodData['payment_number'];
}
// Handle form submission
$showToast = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $paymentNumberInput = $_POST['payment_number'];
    $amount = $_POST['amount'];
    // Insert the transaction into the database with "pending" status
    $insertQuery = $conn->prepare("INSERT INTO transactions (user_id, payment_method, payment_number, amount, status, title, type) VALUES (?, ?, ?, ?, 'pending', 'ADD MONEY', 'add')");
    $insertQuery->bind_param("issd", $userId, $paymentMethod, $paymentNumberInput, $amount);
    if ($insertQuery->execute()) {
        // Show the toast after a successful transaction
        function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
            $content = array(
                "en" => $message
            );
            $fields = array(
                'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
                'included_segments' => array('All'), // Send to all users
                'headings' => array("en" => $title),
                'contents' => $content
            );
            // Add optional URL
            if ($url) {
                $fields['url'] = $url;
            }
            // Add optional Image URL
            if ($imageUrl) {
                $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
            }
            $fields = json_encode($fields);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            $response = curl_exec($ch);
            curl_close($ch);
            return $response;
        }
        // Example call for admin notification to all users
        $title = "Admin Notification";
        $message = "New transaction (add money)";
        $response = sendOneSignalNotificationToAll($title, $message);
        $showToast = true;
    } else {
        // Handle any errors (e.g., database errors)
        $error = "Error processing the payment. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Process</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #14b8a6;
            --primary-dark: #0d9488;
            --primary-light: #ccfbf1;
            --secondary-color: #0d9488;
            --accent-color: #FFD700;
            --light-bg: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --success-color: #28a745;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 15px 20px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
        }
        .back-icon:hover {
            transform: translateX(-5px);
        }
        .back-icon i {
            font-size: 20px;
            margin-right: 10px;
        }
        .header h3 {
            font-size: 22px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
        }
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 16px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .balance i {
            margin-right: 8px;
            color: var(--accent-color);
        }
        .main-container {
            max-width: 800px;
            margin: 25px auto;
            padding: 0 15px;
        }
        .notice-box {
            background: linear-gradient(135deg, var(--primary-light), #b2f5ea);
            border-left: 5px solid var(--primary-color);
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        .notice-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: var(--primary-color);
        }
        .notice-box p {
            font-size: 16px;
            color: #0f766e;
            margin: 0;
            position: relative;
            padding-left: 25px;
        }
        .notice-box p::before {
            content: '\f05a';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 0;
            top: 0;
            color: var(--primary-color);
        }
        .inner-container {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            transition: var(--transition);
        }
        .inner-container:hover {
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
        }
        .payment-method {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
        }
        .method-info {
            display: flex;
            align-items: center;
        }
        .method-info h4 {
            margin: 0;
            padding-right: 15px;
            font-size: 20px;
            color: var(--primary-color);
            font-weight: 600;
        }
        .method-info span {
            font-size: 18px;
            color: var(--text-secondary);
            font-weight: 500;
        }
        .copy-button {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 30px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 500;
            display: flex;
            align-items: center;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .copy-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 10px rgba(20, 184, 166, 0.2);
        }
        .copy-button i {
            margin-right: 8px;
        }
        .input-container {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        .input-group {
            position: relative;
        }
        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 18px;
        }
        .input-container input {
            padding: 15px 15px 15px 45px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            width: 100%;
            box-sizing: border-box;
            transition: var(--transition);
            background-color: #f9f9f9;
        }
        .input-container input:focus {
            border-color: var(--primary-color);
            background-color: white;
            outline: none;
            box-shadow: 0 0 0 3px rgba(20, 184, 166, 0.1);
        }
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 15px;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            margin-top: 10px;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(20, 184, 166, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(20, 184, 166, 0.3);
        }
        .submit-btn i {
            margin-right: 10px;
        }
        .toast {
            visibility: hidden;
            min-width: 300px;
            margin-left: -150px;
            background: linear-gradient(135deg, var(--success-color), var(--primary-color));
            color: white;
            text-align: center;
            border-radius: 50px;
            padding: 15px 25px;
            position: fixed;
            z-index: 1000;
            left: 50%;
            top: 30px;
            font-size: 16px;
            font-weight: 500;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .toast i {
            margin-right: 10px;
            font-size: 18px;
        }
        .toast.show {
            visibility: visible;
            animation: slideIn 0.5s, slideOut 0.5s 2.5s;
        }
        @keyframes slideIn {
            from {top: -50px; opacity: 0;}
            to {top: 30px; opacity: 1;}
        }
        @keyframes slideOut {
            from {top: 30px; opacity: 1;}
            to {top: -50px; opacity: 0;}
        }
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 10px;
            color: var(--secondary-color);
        }
        .payment-icon {
            width: 40px;
            height: 40px;
            background-color: var(--primary-light);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: var(--primary-color);
        }
        @media (max-width: 768px) {
            .header {
                padding: 12px 15px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 14px;
                padding: 6px 12px;
            }
            
            .notice-box p {
                font-size: 14px;
                padding-left: 20px;
            }
            
            .method-info h4 {
                font-size: 16px;
            }
            
            .method-info span {
                font-size: 14px;
            }
            
            .copy-button {
                padding: 8px 15px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>Payment Process</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($balance, 2); ?>
        </div>
    </div>
    <!-- Main Container -->
    <div class="main-container">
        <!-- Notice Box -->
        <div class="notice-box">
            <p>নিজ অ্যাকাউন্টে ব্যালেন্স এড করার পূর্বে অবশ্যই কোম্পানির ডিপোজিট নাম্বারগুলো চেক দিয়ে টাকা পাঠাবেন।সর্বনিম্ন এড মানি ৫০০ টাকা</p>
        </div>
        <!-- First Inner Container: Payment Method Information -->
        <div class="inner-container">
            <div class="section-title">
                <i class="fas fa-credit-card"></i>
                Payment Method
            </div>
            <div class="payment-method">
                <div class="method-info">
                    <div class="payment-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div>
                        <h4><?php echo $paymentMethod; ?></h4>
                        <span><?php echo $paymentNumber; ?></span>
                    </div>
                </div>
                <button class="copy-button" onclick="copyToClipboard('<?php echo $paymentNumber; ?>')">
                    <i class="fas fa-copy"></i>
                    Copy
                </button>
            </div>
        </div>
        <!-- Second Inner Container: Payment Input Section -->
        <div class="inner-container">
            <div class="section-title">
                <i class="fas fa-file-invoice-dollar"></i>
                Payment Details
            </div>
            <form method="POST">
                <div class="input-container">
                    <div class="input-group">
                        <i class="fas fa-phone-alt"></i>
                        <input type="text" name="payment_number" placeholder="Enter Payment Number" required>
                    </div>
                    <div class="input-group">
                        <i class="fas fa-money-bill"></i>
                        <input type="number" name="amount" placeholder="Enter Amount (Minimum ৳500)" required min="500">
                    </div>
                </div>
                <button type="submit" class="submit-btn">
                    <i class="fas fa-paper-plane"></i>
                    Submit Payment
                </button>
            </form>
        </div>
    </div>
    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <i class="fas fa-check-circle"></i>
        Payment request sent successfully!
    </div>
    <?php if ($showToast): ?>
    <script>
        // Show toast and redirect after 3 seconds
        const toast = document.getElementById('toast');
        toast.className = 'toast show';
        // Redirect to dashboard after 3 seconds
        setTimeout(function() {
            window.location.href = "dashboard.php";
        }, 1000);
    </script>
    <?php endif; ?>
    <script>
        function copyToClipboard(text) {
            const tempInput = document.createElement('input');
            tempInput.value = text;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            // Show the toast message
            const toast = document.getElementById('toast');
            toast.innerHTML = '<i class="fas fa-check-circle"></i> Copied to clipboard!';
            toast.className = 'toast show';
            // Hide the toast after 2 seconds
            setTimeout(function() {
                toast.className = toast.className.replace('show', '');
                // Reset toast message
                setTimeout(function() {
                    toast.innerHTML = '<i class="fas fa-check-circle"></i> Payment request sent successfully!';
                }, 500);
            }, 2000);
        }
    </script>
</body>
</html>