<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অ্যাপ ডাউনলোড - World BKash</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --teal-primary: #008080;
            --teal-light: #e0fffe;
            --teal-dark: #004d40;
            --teal-medium: #4dbdbd;
            --teal-text-dark: #004d40;
            --teal-text-medium: #00695c;
            --teal-text-light: #00a39a;
            --teal-gray-lightest: #f5fafa;
            --teal-gray-light: #e0f2f1;
            --teal-gray: #80cbc4;
            --teal-gray-dark: #00695c;
            --teal-border: #b2dfdb;
            --teal-success: #2ecc71;
            --teal-warning: #f39c12;
            --teal-danger: #e74c3c;
            --teal-blue: #3498db;
            --transition: all 0.3s ease;
            --shadow: 0 4px 12px rgba(0, 128, 128, 0.15);
        }
        
        body {
            background: var(--teal-gray-lightest);
            color: var(--teal-text-dark);
            font-size: 14px;
            line-height: 1.6;
            min-height: 100vh;
        }
        
        .app-container {
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        /* Header Styles */
        .app-header {
            background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
            color: white;
            padding: 15px 20px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
        }
        
        /* Hero Section - Modified for horizontal layout */
        .hero-section {
            padding: 20px;
            text-align: center;
            background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
            color: white;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .hero-section::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .app-logo {
            width: 50px;
            height: 50px;
            background: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
            flex-shrink: 0;
        }
        
        .app-logo i {
            font-size: 24px;
            color: var(--teal-primary);
        }
        
        .app-info {
            flex-grow: 1;
            text-align: left;
            position: relative;
            z-index: 1;
        }
        
        .app-name {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 2px;
            position: relative;
            z-index: 1;
        }
        
        .app-tagline {
            font-size: 12px;
            margin-bottom: 10px;
            position: relative;
            z-index: 1;
            opacity: 0.9;
        }
        
        .download-btn {
            background: white;
            color: var(--teal-primary);
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
            flex-shrink: 0;
        }
        
        .download-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
        }
        
        .download-btn i {
            margin-right: 5px;
            font-size: 12px;
        }
        
        /* Screenshots Section - Enhanced */
        .screenshots-section {
            padding: 25px 20px;
            background: linear-gradient(to bottom, var(--teal-light), white);
            position: relative;
        }
        
        .screenshots-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(to right, var(--teal-primary), var(--teal-medium));
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--teal-primary);
            margin-bottom: 20px;
            text-align: center;
            position: relative;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -6px;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: var(--teal-primary);
            border-radius: 3px;
        }
        
        .screenshot-showcase {
            position: relative;
            margin-bottom: 20px;
        }
        
        .main-screenshot {
            width: 100%;
            height: 250px;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.2);
            position: relative;
            border: 3px solid white;
        }
        
        .main-screenshot img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        
        .screenshot-info {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.8), transparent);
            color: white;
            padding: 15px;
            text-align: center;
        }
        
        .screenshot-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .screenshot-desc {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .screenshot-nav {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 15px;
        }
        
        .nav-arrow {
            width: 40px;
            height: 40px;
            background: var(--teal-primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 3px 8px rgba(0, 128, 128, 0.2);
        }
        
        .nav-arrow:hover {
            background: var(--teal-dark);
            transform: scale(1.1);
        }
        
        .nav-dots {
            display: flex;
            gap: 8px;
        }
        
        .nav-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: var(--teal-gray);
            cursor: pointer;
            transition: var(--transition);
        }
        
        .nav-dot.active {
            background: var(--teal-primary);
            transform: scale(1.2);
        }
        
        .mini-screenshots {
            display: flex;
            gap: 10px;
            overflow-x: auto;
            padding: 10px 0;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        
        .mini-screenshots::-webkit-scrollbar {
            display: none;
        }
        
        .mini-screenshot {
            min-width: 80px;
            height: 80px;
            border-radius: 10px;
            overflow: hidden;
            border: 2px solid transparent;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        
        .mini-screenshot img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .mini-screenshot.active {
            border-color: var(--teal-primary);
            transform: scale(1.05);
        }
        
        /* Features Section */
        .features-section {
            padding: 20px;
            background: var(--teal-light);
            margin: 0 20px 20px;
            border-radius: 12px;
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }
        
        .feature-item {
            background: white;
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.08);
            transition: var(--transition);
        }
        
        .feature-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 128, 128, 0.15);
        }
        
        .feature-icon {
            width: 40px;
            height: 40px;
            background: var(--teal-light);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
            color: var(--teal-primary);
            font-size: 18px;
        }
        
        .feature-title {
            font-size: 15px;
            font-weight: 600;
            color: var(--teal-text-dark);
            margin-bottom: 5px;
        }
        
        .feature-desc {
            font-size: 13px;
            color: var(--teal-text-medium);
        }
        
        /* Download Options Section */
        .download-options {
            padding: 20px;
            background: white;
            margin: 0 20px 20px;
            border-radius: 12px;
            box-shadow: var(--shadow);
        }
        
        .download-options h3 {
            font-size: 16px;
            color: var(--teal-primary);
            margin-bottom: 15px;
            text-align: center;
        }
        
        .download-buttons {
            display: flex;
            justify-content: center;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        .store-btn {
            background: var(--teal-primary);
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.1);
        }
        
        .store-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        
        .store-btn i {
            font-size: 18px;
            margin-right: 6px;
        }
        
        /* QR Code Section */
        .qr-section {
            padding: 20px;
            text-align: center;
            background: white;
            margin: 0 20px 20px;
            border-radius: 12px;
            box-shadow: var(--shadow);
        }
        
        .qr-code {
            width: 120px;
            height: 120px;
            background: white;
            border: 1px solid var(--teal-border);
            border-radius: 8px;
            margin: 0 auto 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: var(--shadow);
        }
        
        .qr-code i {
            font-size: 50px;
            color: var(--teal-primary);
        }
        
        .qr-text {
            font-size: 13px;
            color: var(--teal-text-medium);
        }
        
        /* Footer */
        .footer {
            padding: 20px;
            text-align: center;
            color: var(--teal-text-medium);
            font-size: 13px;
            border-top: 1px solid var(--teal-border);
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-top: 12px;
        }
        
        .social-link {
            width: 32px;
            height: 32px;
            background: var(--teal-light);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--teal-primary);
            transition: var(--transition);
        }
        
        .social-link:hover {
            background: var(--teal-primary);
            color: white;
            transform: translateY(-3px);
        }
        
        /* Responsive */
        @media (max-width: 480px) {
            .app-container {
                max-width: 100%;
            }
            
            .hero-section {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }
            
            .app-info {
                text-align: center;
            }
            
            .app-name {
                font-size: 18px;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
            }
            
            .download-buttons {
                flex-direction: column;
            }
            
            .store-btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">অ্যাপ ডাউনলোড</h1>
        </div>
        
        <!-- Hero Section -->
        <div class="hero-section">
            <div class="app-logo">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="app-info">
                <h2 class="app-name">World BKash</h2>
                <p class="app-tagline">আপনার ডিজিটাল ওয়ালেট সমাধান</p>
            </div>
            <a href="/App/Wbkash.apk" class="download-btn">
                <i class="fas fa-download"></i>
                ডাউনলোড
            </a>
        </div>
        
        <!-- Screenshots Section - Enhanced -->
        <div class="screenshots-section">
            <h3 class="section-title">অ্যাপের স্ক্রিনশট</h3>
            
            <div class="screenshot-showcase">
                <div class="main-screenshot">
                    <img src="https://ramitwallet.com/image/banner/1.png" alt="হোম স্ক্রিন" id="mainScreenshot">
                    <div class="screenshot-info">
                        <div class="screenshot-title" id="screenshotTitle">হোম স্ক্রিন</div>
                        <div class="screenshot-desc" id="screenshotDesc">সহজেই আপনার ব্যালেন্স দেখুন</div>
                    </div>
                </div>
                
                <div class="screenshot-nav">
                    <div class="nav-arrow" onclick="changeSlide(-1)">
                        <i class="fas fa-chevron-left"></i>
                    </div>
                    
                    <div class="nav-dots">
                        <span class="nav-dot active" onclick="currentSlide(1)"></span>
                        <span class="nav-dot" onclick="currentSlide(2)"></span>
                        <span class="nav-dot" onclick="currentSlide(3)"></span>
                        <span class="nav-dot" onclick="currentSlide(4)"></span>
                        <span class="nav-dot" onclick="currentSlide(5)"></span>
                    </div>
                    
                    <div class="nav-arrow" onclick="changeSlide(1)">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
            </div>
            
            <div class="mini-screenshots">
                <div class="mini-screenshot active" onclick="currentSlide(1)">
                    <img src="https://ramitwallet.com/image/banner/1.png" alt="হোম">
                </div>
                <div class="mini-screenshot" onclick="currentSlide(2)">
                    <img src="https://ramitwallet.com/image/banner/2.png" alt="পাঠানো">
                </div>
                <div class="mini-screenshot" onclick="currentSlide(3)">
                    <img src="https://ramitwallet.com/image/banner/3.png" alt="রিচার্জ">
                </div>
                <div class="mini-screenshot" onclick="currentSlide(4)">
                    <img src="https://ramitwallet.com/image/banner/4.png" alt="বিল">
                </div>
                <div class="mini-screenshot" onclick="currentSlide(5)">
                    <img src="https://ramitwallet.com/image/banner/5.png" alt="অফার">
                </div>
            </div>
        </div>
        
        <!-- Features Section -->
        <div class="features-section">
            <h3 class="section-title">আমাদের অ্যাপের সুবিধা</h3>
            <div class="features-grid">
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <h4 class="feature-title">দ্রুত লেনদেন</h4>
                    <p class="feature-desc">আমাদের আল্ট্রা-ফাস্ট পেমেন্ট সিস্টেমের মাধ্যমে তাৎক্ষণিক টাকা পাঠান এবং গ্রহণ করুন</p>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h4 class="feature-title">নিরাপদ ও সুরক্ষিত</h4>
                    <p class="feature-desc">আপনার লেনদেন এবং ব্যক্তিগত তথ্য রক্ষা করতে ব্যাংক-লেভেল নিরাপত্তা</p>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h4 class="feature-title">মোবাইল রিচার্জ</h4>
                    <p class="feature-desc">সব অপারেটরের জন্য এক্সক্লুসিভ অফার সহ আপনার মোবাইল রিচার্জ করুন</p>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <h4 class="feature-title">রিওয়ার্ড প্রোগ্রাম</h4>
                    <p class="feature-desc">আপনার প্রতিটি লেনদেনে রিওয়ার্ড এবং ক্যাশব্যাক উপার্জন করুন</p>
                </div>
            </div>
        </div>
        
        <!-- Download Options Section -->
        <div class="download-options">
            <h3>আপনার পছন্দের স্টোর থেকে ডাউনলোড করুন</h3>
            <div class="download-buttons">
                <a href="https://play.google.com/store/apps/details?id=com.ramitwallet" class="store-btn">
                    <i class="fab fa-google-play"></i>
                    গুগল প্লে
                </a>
                <a href="https://apps.apple.com/app/ramitwallet" class="store-btn">
                    <i class="fab fa-apple"></i>
                    অ্যাপ স্টোর
                </a>
                <a href="/App/Wbkash.apk" class="store-btn">
                    <i class="fas fa-file-archive"></i>
                    সরাসরি APK
                </a>
            </div>
        </div>
        
        <!-- QR Code Section -->
        <div class="qr-section">
            <h3 class="section-title">স্ক্যান করে ডাউনলোড করুন</h3>
            <div class="qr-code">
                <i class="fas fa-qrcode"></i>
            </div>
            <p class="qr-text">অ্যাপ ডাউনলোড করতে আপনার ফোনের ক্যামেরা দিয়ে এই QR কোড স্ক্যান করুন</p>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>© ২০২৩ World BKash। সর্বস্বত্ব সংরক্ষিত।</p>
            <div class="social-links">
                <a href="https://facebook.com/ramitwallet" class="social-link">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="https://twitter.com/ramitwallet" class="social-link">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="https://instagram.com/ramitwallet" class="social-link">
                    <i class="fab fa-instagram"></i>
                </a>
                <a href="https://wa.me/+8801796003076" class="social-link">
                    <i class="fab fa-whatsapp"></i>
                </a>
            </div>
        </div>
    </div>
    
    <script>
        // Screenshot data with actual images
        const screenshots = [
            {
                image: "https://ramitwallet.com/image/banner/1.png",
                title: "হোম স্ক্রিন",
                desc: "সহজেই আপনার ব্যালেন্স দেখুন"
            },
            {
                image: "https://ramitwallet.com/image/banner/2.png",
                title: "টাকা পাঠানো",
                desc: "মুহূর্তেই টাকা পাঠানোর সুবিধা"
            },
            {
                image: "https://ramitwallet.com/image/banner/3.png",
                title: "মোবাইল রিচার্জ",
                desc: "সকল অপারেটরে রিচার্জ করুন"
            },
            {
                image: "https://ramitwallet.com/image/banner/4.png",
                title: "বিল পেমেন্ট",
                desc: "সহজেই বিল পেমেন্ট করুন"
            },
            {
                image: "https://ramitwallet.com/image/banner/5.png",
                title: "অফার সমূহ",
                desc: "আকর্ষণীয় অফার দেখুন"
            }
        ];
        
        let currentSlideIndex = 0;
        
        function currentSlide(n) {
            showSlide(currentSlideIndex = n - 1);
        }
        
        function changeSlide(direction) {
            currentSlideIndex += direction;
            
            if (currentSlideIndex >= screenshots.length) {
                currentSlideIndex = 0;
            } else if (currentSlideIndex < 0) {
                currentSlideIndex = screenshots.length - 1;
            }
            
            showSlide(currentSlideIndex);
        }
        
        function showSlide(index) {
            // Update main screenshot
            document.getElementById('mainScreenshot').src = screenshots[index].image;
            document.getElementById('screenshotTitle').textContent = screenshots[index].title;
            document.getElementById('screenshotDesc').textContent = screenshots[index].desc;
            
            // Update navigation dots
            const dots = document.querySelectorAll('.nav-dot');
            dots.forEach((dot, i) => {
                dot.classList.toggle('active', i === index);
            });
            
            // Update mini screenshots
            const miniScreenshots = document.querySelectorAll('.mini-screenshot');
            miniScreenshots.forEach((mini, i) => {
                mini.classList.toggle('active', i === index);
            });
        }
        
        // Auto slide
        setInterval(() => {
            changeSlide(1);
        }, 5000);
    </script>
</body>
</html>