<?php
include 'db.php'; // Include the database connection

// Fetch the current content from the database
$sql = "SELECT content FROM currency_texts WHERE id = 3"; // Kuwait এর জন্য ID পরিবর্তন করা হয়েছে
$result = $conn->query($sql);
$row = $result->fetch_assoc();
$current_content = $row['content'];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuwait Rate</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
    <div class="card">
        <div class="upside">
            <div class="text">
                <h2>Kuwait</h2>
                <p id="kuwait-time"></p> <!-- Kuwait time will be displayed here -->
            </div>
            <div class="add"><i class="fa fa-plus"></i></div>
        </div>
        <div class="bottom">
            <div>
                <p>Country</p>
                <p>Kuwait</p>
            </div>
            <div>
                <p>Dinar</p>
                <p>1 Dinar =</p>
            </div>
            <div>
                <p>BANGLADESHI</p>
                <p><?php echo htmlspecialchars($current_content); ?></p> <!-- Display content for Kuwait -->
            </div>
        </div>
        <div class="inside">
            <p>Follow us for updates</p>
            <a href="https://www.facebook.com" target="_blank"><i class="fa fa-facebook fa-2x fa-fw"></i></a>
            <a href="https://wa.me/1234567890" target="_blank"><i class="fa fa-whatsapp fa-2x fa-fw"></i></a>
            <a href="https://telegram.me/yourusername" target="_blank"><i class="fa fa-telegram fa-2x fa-fw"></i></a>
            <p id="follow-date"></p>
            <p>Check the current rates and visit our special offers.</p>
        </div>
    </div>

    <script>
        $(function() {
            $(".add").click(function() {
                $(".card").toggleClass("pCard_on");
                $(".add i").toggleClass("fa-minus");
            });

            const today = new Date();
            const day = String(today.getDate()).padStart(2, '0');
            const month = String(today.getMonth() + 1).padStart(2, '0');
            const year = today.getFullYear();
            document.getElementById('follow-date').textContent = `আজকের তারিখ: ${day}-${month}-${year}`; // Date for Kuwait

            function updateKuwaitTime() {
                const kuwaitTime = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Kuwait" }));
                let kuwaitHour = kuwaitTime.getHours();
                const kuwaitMinute = String(kuwaitTime.getMinutes()).padStart(2, '0');
                const kuwaitSecond = String(kuwaitTime.getSeconds()).padStart(2, '0');
                
                const ampm = kuwaitHour >= 12 ? 'PM' : 'AM';
                kuwaitHour = kuwaitHour % 12;
                kuwaitHour = kuwaitHour ? String(kuwaitHour).padStart(2, '0') : '12';

                document.getElementById('kuwait-time').textContent = `বর্তমান সময়: ${kuwaitHour}:${kuwaitMinute}:${kuwaitSecond} ${ampm}`; // Update Kuwait time
            }

            updateKuwaitTime();
            setInterval(updateKuwaitTime, 1000);
        });
    </script>

</body>
</html>
