<?php
// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    // If the user is not logged in, redirect to the login page
    header("Location: login.php");
    exit;
}


if (isset($_SESSION['tt']) && $_SESSION['tt'] === 'rayhan') {
    
} else {
    
}


// Include the database connection
include('db.php');

// Fetch notice from the database
$sql = "SELECT home FROM settings WHERE id = 1";
$result = $conn->query($sql);
$settings = $result->fetch_assoc();
$notice = $settings['home'] ?? '';
// Fetch notices from the database
$sql = "SELECT message FROM notices ORDER BY created_at DESC";
$result = $conn->query($sql);
$notices = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $notices[] = $row['message'];
    }
}

// Convert notices array to a single string for display
$scrollingText = implode(' | ', $notices);


// Check if the popup should be shown (based on session)
$showPopup = !isset($_SESSION['notice']);

// If the popup is dismissed, set the session 'notice' to true
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['dismiss_popup'])) {
    $_SESSION['notice'] = true;
    echo json_encode(['status' => 'Popup dismissed']);
    exit;
}

// Fetch the logged-in user information including the PIN
$sql = "SELECT name, balance, reward_points, profile_image, pin FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// If no user is found, redirect to the login page
if (!$user) {
    $_SESSION['message'] = "User not found!";
    $_SESSION['message_type'] = "error";
    header("Location: login.php");
    exit;
}

// Check if the user has no PIN
if (empty($user['pin'])) {
    // Store a session variable to indicate PIN setup
    $_SESSION['setup_pin'] = true;
    header("Location: pin.php");
    exit;
}

// Fetch banners from the database
$sql_banners = "SELECT image_url FROM banners";
$stmt_banners = $conn->prepare($sql_banners);
$stmt_banners->execute();
$result_banners = $stmt_banners->get_result();
$banners = $result_banners->fetch_all(MYSQLI_ASSOC);

// Array of recipient users (this data could also come from the database if needed)
$recipients = [
    ['name' => 'Dubai', 'image' => 'https://flagcdn.com/w320/ae.png'],
    ['name' => 'Qatar', 'image' => 'https://www.countryflags.com/wp-content/uploads/qatar-flag-png-large.png'],
    ['name' => 'Saudi Arab', 'image' => 'https://flagcdn.com/w320/sa.png'], 
    ['name' => 'Malaysia', 'image' => 'https://flagcdn.com/w320/my.png'],
    ['name' => 'Oman', 'image' => 'https://www.countryflags.com/wp-content/uploads/oman-flag-png-large.png'],
    ['name' => 'Bahrain', 'image' => 'https://flagpedia.net/data/flags/w580/bh.webp'],
    ['name' => 'Kuwait', 'image' => 'https://flagpedia.net/data/flags/w580/kw.webp'],
];

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title>home</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="fonts/icons-alipay.css">
    <link rel="stylesheet" href="styles/bootstrap.css">
    <link rel="stylesheet" href="styles/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <link rel="manifest" href="_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="app/icons/icon-192x192.png">
</head>

<style>
    body {
  font: 12px/20px "Plus Jakarta Sans", sans-serif;
  font-weight: 500;
  background-color: #ffffff;
  color: #717171;
  overflow: hidden;
  padding-right: 0 !important;
  max-width: 800px;
  width: 100%;
  margin: 0 auto;
}
.tf-navigation-bar li a:focus, .tf-navigation-bar li a:active, .tf-navigation-bar li a:hover {
  color: #4CB050;
}
.tf-navigation-bar li.active a {
  color: #4CB050;
}
.app-header {
  background: url(../images/banner/banner-home2.png);
  padding: 16px 0px 84px;
  margin: 0px -16px;
  background-repeat: no-repeat;
  background-size: cover;
  background-position: center center;
  position: relative;
  border-bottom-right-radius: 80px;
  border-bottom-left-radius: 80px;
}
.icon-notification span {
            position: absolute;
            top: -5px;
            right: -5px;
            background: red;
            color: white;
            border-radius: 50%;
            padding: 2px 5px;
            font-size: 12px;
        }
        .popup-notice {
            visibility: hidden;
            position: fixed;
            top: -200px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            width: 90%;
            max-width: 500px;
            z-index: 100;
            transition: top 0.5s ease;
        }
        .popup-notice.show {
            visibility: visible;
            top: 20px;
        }
        .popup-notice h4 {
            font-size: 18px;
        }
        .popup-notice .close-btn {
            margin-top: 10px;
            background-color: #f44336;
            color: white;
            padding: 10px;
            text-align: center;
            cursor: pointer;
            border-radius: 5px;
        }
</style>
<style>
    /* অন্যান্য CSS কোড */
    .scrolling-notice {
        background-color: #f0f8ff; /* হালকা নীল পটভূমি */
        padding: 10px;
        text-align: center;
        font-size: 16px;
        color: #1e88e5; /* নীল রঙের লেখা */
        font-weight: bold;
        margin-bottom: 20px; /* নোটিসের নিচে ফাঁকা জায়গা */
    }
</style>

<body>


    <div class="app-header">
        <div class="tf-container">
            <div class="tf-topbar d-flex justify-content-between align-items-center">
                <a class="user-info d-flex justify-content-between align-items-center" href="69_profile.html">
                    <img src="<?php echo $user['profile_image']; ?>" alt="image">

                    <div class="content">
                        <h4 class="white_color"><?php echo $user['name']; ?></h4>
                        <p class="white_color fw_4">Let’s save your money!</p>
                    </div>
                </a>
                <div class="d-flex align-items-center gap-4">
                    <a href="javascript:void(0);" id="btn-popup-left">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                         
                        </svg>
                    </a>
                    <a href="#" id="btn-notification" class="icon-notification1"><span>2</span></a>
                </div>
            </div>
        </div>
    </div>

    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                                <h3> ৳<?php echo $user['balance']; ?></h3>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="inner-right">
                                <p>Reward</p>
                                <h3>
                                    <ul class="icon-gift-box">
                                        <li class="path1"></li>
                                        <!-- Rest of the paths -->
                                    </ul>
                                    <?php echo $user['reward_points']; ?>
                                    <span>Point</span>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wallet-footer">
                    <ul class="d-flex justify-content-between align-items-center">
                        <li class="wallet-card-item">
                            <a href="addmoney.php" class="fw_6 text-center" id="btn-popup-down">
                                <img src="icon/add.png" alt="icon" style="width: 50px; height: 50px;">
                                Add Money
                            </a>
                        </li>
                        <li class="wallet-card-item"><a class="fw_6" href="sendmoney.php">
                                <img src="icon/send-money.png" alt="icon" style="width: 50px; height: 50px;">
                                Send Money
                            </a></li>
                        <li class="wallet-card-item"><a class="fw_6 btn-card-popup" href="reward_convert.php">
                                <img src="icon/reward.png" alt="icon" style="width: 50px; height: 50px;">
                                Reward
                            </a></li>
                        <li class="wallet-card-item"><a class="fw_6" href="bank.php">
                                <img src="icon/mobile-banking.png" alt="icon" style="width: 50px; height: 50px;">
                                Banking
                            </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="scrolling-notice">
    <marquee behavior="scroll" direction="left">
        <?php echo htmlspecialchars($scrollingText); ?>
    </marquee>
</div>

    <div class="mt-5">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Your service</h3>
                <a href="#" class="primary_color fw_6">All Service</a>
            </div>
            <ul class="box-service mt-3">
                <li>
                    <a href="recharge.php">
                        <div class="icon-box bg_color_1">
                            <img src="icon/recharge.png" alt="icon" style="width: 50px; height: 50px;">    
                        </div>
                        Recharge
                    </a> 
                </li>
                <li>
                    <a href="drive.php">
                        <div class="icon-box bg_color_2">
                            <img src="icon/offer.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Drive Offer (Internet)  
                    </a> 
                </li>
                <li>
                    <a href="paybill.php">
                        <div class="icon-box bg_color_3">
                            <img src="icon/paybill.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                       Pay Bill 
                    </a> 
                </li>
                <li>
                    <a href="coin.php?id=1">
                        <div class="icon-box bg_color_4">
                            <img src="img/20240915_220918.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Special Offer
                    </a> 
                </li>
                <li>
                    <a href="m-bank.php?id=2">
                        <div class="icon-box bg_color_5">
                            <img src="icon/bkash.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Bkash 
                    </a> 
                </li>
                <li>
                    <a href="m-bank.php?id=3">
                        <div class="icon-box bg_color_6">
                           <img src="icon/nagad.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Nagad
                    </a> 
                </li>
                <li>
                    <a href="m-bank.php?id=4">
                        <div class="icon-box bg_color_7">
                            <img src="icon/rocket.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Rocket
                    </a> 
                </li>
                <li>
                    <a href="m-bank.php?id=5">
                        <div class="icon-box bg_color_8">
                            <img src="icon/upay.png" alt="icon" style="width: 50px; height: 50px;">
                        </div>
                        Upay
                    </a> 
                </li>   
            </ul>
        </div>
    </div>

    <div class="mt-5 mb-9">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Latest Recipient</h3>
                <a href="#" class="primary_color fw_6 btn-repicient">All Country's</a>
            </div>
            <div class="mt-3">
                <div class="swiper-container recipient-tes">
                    <div class="swiper-wrapper">
                    <?php foreach ($recipients as $recipient): ?>
                        <div class="swiper-slide">
                            <a class="recipient-box btn-repicient" href="/country/<?php echo strtolower(str_replace(' ', '', $recipient['name'])); ?>.php">
                                <img src="<?php echo $recipient['image']; ?>" alt="Flag of <?php echo $recipient['name']; ?>">
                                <?php echo $recipient['name']; ?>
                            </a>
                        </div>
                    <?php endforeach; ?>

                    </div>
                </div>
            </div>
            <div class="mt-5">
                <div class="swiper-container banner-tes">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="https://admin.ramitwallet.com/slider/slider-1.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://admin.ramitwallet.com/slider/slider-2.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://admin.ramitwallet.com/slider/slider-3.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://admin.ramitwallet.com/slider/slider-4.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://admin.ramitwallet.com/slider/slider-5.png" alt="images">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li class="active"><a class="fw_6 d-flex justify-content-center align-items-center flex-column" href="/"><i class="icon-home2"></i> Home</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="history.php"><i class="icon-history"></i> History</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="coin.php"><i class="icon-scan-qr-code"></i> </a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="coin.php">
                    <img src="img/tt.png" alt="Add Money" style="width: 31px; height: 28px;">
                    Rewards
                </a></li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="profile.php"><i class="icon-user-outline"></i> Profile</a></li>
            </ul>
        </div>
    </div>
    

<div class="popup-notice" id="popupNotice">
    <h2>আজকের নোটিশ</h2>
    <p><h3><?php echo nl2br(htmlspecialchars($notice)); ?></h3></p>
    <div class="close-btn" id="closePopup">Close</div>
</div>

<script>

    let showPopup = <?php echo $showPopup ? 'true' : 'false'; ?>;

    if (showPopup) {
        document.getElementById('popupNotice').classList.add('show');
    }


    document.getElementById('closePopup').addEventListener('click', function() {
        document.getElementById('popupNotice').classList.remove('show');
        fetch('', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: 'dismiss_popup=true'
        }).then(response => response.json())
          .then(data => console.log('Popup dismissed'));
    });


    document.getElementById('btn-notification').addEventListener('click', function(e) {
        e.preventDefault(); 
        document.getElementById('popupNotice').classList.add('show');
    });
</script>

<style>
    .popup-notice {
        display: none;
        position: fixed;
        background: #fff;
        border-radius: 10px;
        box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);
        padding: 20px;
        width: 90%;
        max-width: 400px;
        z-index: 1000;
        text-align: center;
    }

    .popup-notice.show {
        display: block;
    }

    .popup-notice h2 {
        font-size: 18px;
        margin-bottom: 10px;
        color: #333;
    }

    .popup-notice p h3 {
        font-size: 16px;
        margin: 10px 0;
        color: #555;
    }

    .close-btn {
        background-color: #007bff;
        color: white;
        padding: 10px 15px;
        border-radius: 5px;
        margin-top: 15px;
        cursor: pointer;
        display: inline-block;
    }

    .close-btn:hover {
        background-color: #0056b3;
    }


    @media (max-width: 480px) {
        .popup-notice {
            width: 95%;
            padding: 15px;
        }

        .popup-notice h2 {
            font-size: 16px;
        }

        .popup-notice p h3 {
            font-size: 14px;
        }

        .close-btn {
            padding: 8px 12px;
        }
    }
</style>


    <script type="text/javascript" src="javascript/jquery.min.js"></script>
    <script type="text/javascript" src="javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="javascript/swiper.js"></script>
    <script type="text/javascript" src="javascript/main.js"></script>
</body>
</html>
