let pinInput = [];

document.querySelectorAll('.key').forEach(key => {
    key.addEventListener('click', function () {
        if (!this.classList.contains('clear') && !this.classList.contains('ok')) {
            // Add number to PIN input if less than 4 digits are entered
            if (pinInput.length < 4) {
                pinInput.push(this.innerText.trim());
                updateDots();
            }
        } else if (this.classList.contains('clear')) {
            // Remove the last digit entered
            pinInput.pop();
            updateDots();
        } else if (this.classList.contains('ok')) {
            // Submit or validate the PIN (Placeholder action)
            alert("PIN Entered: " + pinInput.join(''));
        }
    });
});

function updateDots() {
    let dots = document.querySelectorAll('.dot');
    dots.forEach((dot, index) => {
        dot.style.backgroundColor = index < pinInput.length ? '#4a4a4a' : '#e0e0e0';
    });
}
