<?php
session_start();
include('db.php');
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT pin FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$message = "";
// Check if a new PIN should be set or verified
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $inputPin = $_POST['pin'];
    
    // If there is no PIN, set the new PIN and redirect
    if (empty($user['pin'])) {
        $updateStmt = $conn->prepare("UPDATE users SET pin = ? WHERE id = ?");
        $updateStmt->bind_param("si", $inputPin, $userId);
        $updateStmt->execute();
        $_SESSION['tt'] = "rayhan";
        $_SESSION['login_status'] = true;
        unset($_SESSION['notice']);
        header("Location: dashboard.php");
        exit;
    } else {
        // If there is a PIN, check it
        if ($user['pin'] === $inputPin) {
            $_SESSION['tt'] = "rayhan";
            $_SESSION['login_status'] = true;
            unset($_SESSION['notice']);
            header("Location: dashboard.php");
            exit;
        } else {
            $message = "ভুল পিন। আবার চেষ্টা করুন।";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পিন যাচাই করুন</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --teal: #008080;
            --light-teal: #e0f2f1;
            --teal-dark: #006666;
            --teal-light: #e0fffe;
            --teal-medium: #4dbdbd;
            --bkash-dark: #333333;
            --bkash-gray: #666666;
            --bkash-light-gray: #f5f5f5;
            --bkash-border: #e0e0e0;
            --bkash-success: #2ecc71;
            --bkash-warning: #f39c12;
            --bkash-danger: #e74c3c;
            --bkash-blue: #3498db;
            --transition: all 0.3s ease;
            --border-radius: 16px;
        }
        
        body {
            background: linear-gradient(135deg, var(--teal-light), var(--light-teal));
            color: var(--bkash-dark);
            font-size: 14px;
            line-height: 1.4;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .app-container {
            width: 100%;
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            border-radius: var(--border-radius);
        }
        
        /* Header Styles */
        .app-header {
            background: linear-gradient(135deg, var(--teal), var(--teal-dark));
            color: white;
            padding: 20px;
            position: relative;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 20px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
        }
        
        .balance-badge {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            padding: 8px 15px;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            backdrop-filter: blur(5px);
        }
        
        /* PIN Container */
        .pin-container {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 30px 20px;
        }
        
        .pin-logo {
            width: 80px;
            height: 80px;
            margin: 0 auto 30px;
            background: linear-gradient(135deg, var(--teal), var(--teal-dark));
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            font-size: 32px;
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.3);
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(0, 128, 128, 0.4);
            }
            70% {
                box-shadow: 0 0 0 15px rgba(0, 128, 128, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(0, 128, 128, 0);
            }
        }
        
        .pin-header {
            margin-bottom: 30px;
            text-align: center;
        }
        
        .pin-header h2 {
            font-size: 22px;
            font-weight: 700;
            color: var(--teal);
            margin-bottom: 8px;
        }
        
        .pin-header p {
            font-size: 14px;
            color: var(--bkash-gray);
            max-width: 280px;
            margin: 0 auto;
        }
        
        .pin-dots {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
            gap: 20px;
        }
        
        .dot {
            width: 20px;
            height: 20px;
            background-color: var(--bkash-light-gray);
            border-radius: 50%;
            transition: var(--transition);
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .dot.filled {
            background-color: var(--teal);
            transform: scale(1.2);
            box-shadow: 0 0 10px rgba(0, 128, 128, 0.3);
        }
        
        .pin-keypad {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-bottom: 20px;
            max-width: 300px;
        }
        
        .key {
            width: 80px;
            height: 70px;
            border: none;
            background-color: white;
            border: 1px solid var(--bkash-border);
            border-radius: var(--border-radius);
            font-size: 22px;
            font-weight: 600;
            color: var(--bkash-dark);
            cursor: pointer;
            display: flex;
            justify-content: center;
            align-items: center;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        }
        
        .key:hover {
            background-color: var(--teal-light);
            border-color: var(--teal);
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 128, 128, 0.15);
        }
        
        .key:active {
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 128, 128, 0.2);
        }
        
        .key.clear {
            background-color: var(--bkash-light-gray);
            color: var(--bkash-gray);
            border-color: var(--bkash-border);
        }
        
        .key.clear:hover {
            background-color: #e0e0e0;
            border-color: #ccc;
        }
        
        .key.ok {
            background: linear-gradient(135deg, var(--teal), var(--teal-dark));
            color: white;
            grid-column: span 3;
            max-width: 240px;
            justify-self: center;
            font-size: 16px;
            font-weight: 600;
            height: 55px;
            border-radius: 28px;
            box-shadow: 0 4px 10px rgba(0, 128, 128, 0.3);
            border: none;
        }
        
        .key.ok:hover {
            background: linear-gradient(135deg, var(--teal-dark), #004d40);
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0, 128, 128, 0.4);
        }
        
        .key.ok i {
            margin-right: 8px;
        }
        
        .error-message {
            color: var(--bkash-danger);
            margin-top: 20px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            opacity: 0;
            transform: translateY(-10px);
            transition: var(--transition);
            padding: 12px 15px;
            background-color: rgba(231, 76, 60, 0.1);
            border-radius: var(--border-radius);
            border-left: 4px solid var(--bkash-danger);
        }
        
        .error-message.show {
            opacity: 1;
            transform: translateY(0);
        }
        
        .error-message i {
            font-size: 16px;
        }
        
        /* Background Pattern */
        .bg-pattern {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 10% 20%, rgba(0, 128, 128, 0.05) 0%, rgba(0, 128, 128, 0) 90%),
                radial-gradient(circle at 90% 80%, rgba(0, 128, 128, 0.05) 0%, rgba(0, 128, 128, 0) 90%);
            z-index: -1;
        }
        
        /* Finger Print Animation */
        .fingerprint {
            position: absolute;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            color: var(--teal);
            opacity: 0.3;
            font-size: 40px;
            animation: fingerprint 3s infinite;
        }
        
        @keyframes fingerprint {
            0% {
                opacity: 0.3;
                transform: translateX(-50%) scale(1);
            }
            50% {
                opacity: 0.6;
                transform: translateX(-50%) scale(1.1);
            }
            100% {
                opacity: 0.3;
                transform: translateX(-50%) scale(1);
            }
        }
        
        /* Responsive Design */
        @media (max-width: 480px) {
            .app-container {
                border-radius: 0;
                max-width: 100%;
            }
            
            .pin-container {
                padding: 30px 15px;
            }
            
            .pin-header h2 {
                font-size: 20px;
            }
            
            .key {
                width: 70px;
                height: 60px;
                font-size: 20px;
            }
            
            .key.ok {
                max-width: 220px;
                height: 50px;
                font-size: 15px;
            }
            
            .pin-dots {
                gap: 15px;
            }
            
            .dot {
                width: 18px;
                height: 18px;
            }
        }
        
        @media (max-height: 700px) {
            .pin-logo {
                width: 70px;
                height: 70px;
                font-size: 28px;
                margin-bottom: 20px;
            }
            
            .pin-header {
                margin-bottom: 20px;
            }
            
            .pin-header h2 {
                font-size: 20px;
            }
            
            .pin-dots {
                margin-bottom: 20px;
            }
            
            .key {
                width: 70px;
                height: 60px;
                font-size: 20px;
            }
            
            .key.ok {
                height: 50px;
                font-size: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Background Pattern -->
        <div class="bg-pattern"></div>
        
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">পিন যাচাই করুন</h1>
            <div class="balance-badge">
                <i class="fas fa-wallet"></i>
                World BKash
            </div>
        </div>
        
        <!-- PIN Container -->
        <div class="pin-container">
            <div class="pin-logo">
                <i class="fas fa-lock"></i>
            </div>
            
            <div class="pin-header">
                <h2>আপনার পিন লিখুন</h2>
                <p>আপনার নিরাপত্তার জন্য, অনুগ্রহ করে ৪-ডিজিট পিন লিখুন</p>
            </div>
            
            <form method="POST" id="pinForm">
                <div class="pin-dots">
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                </div>
                <input type="hidden" name="pin" id="pin-input" value="">
                
                <div class="pin-keypad">
                    <button type="button" class="key">1</button>
                    <button type="button" class="key">2</button>
                    <button type="button" class="key">3</button>
                    <button type="button" class="key">4</button>
                    <button type="button" class="key">5</button>
                    <button type="button" class="key">6</button>
                    <button type="button" class="key">7</button>
                    <button type="button" class="key">8</button>
                    <button type="button" class="key">9</button>
                    <button type="button" class="key clear">
                        <i class="fas fa-backspace"></i>
                    </button>
                    <button type="button" class="key">0</button>
                    <button type="button" class="key ok" onclick="submitPin()">
                        <i class="fas fa-check-circle"></i> নিশ্চিত করুন
                    </button>
                </div>
            </form>
            
            <?php if (!empty($message)): ?>
                <div class="error-message show">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo $message; ?>
                </div>
            <?php else: ?>
                <div class="error-message" id="error-message">
                    <i class="fas fa-exclamation-circle"></i>
                    ভুল পিন। আবার চেষ্টা করুন।
                </div>
            <?php endif; ?>
            
            <!-- Fingerprint Icon -->
            <div class="fingerprint">
                <i class="fas fa-fingerprint"></i>
            </div>
        </div>
    </div>
    
    <script>
        let pinInput = [];
        const maxPinLength = 4;
        
        document.querySelectorAll('.key').forEach(key => {
            key.addEventListener('click', function () {
                if (!this.classList.contains('clear') && !this.classList.contains('ok')) {
                    if (pinInput.length < maxPinLength) {
                        pinInput.push(this.innerText.trim());
                        updateDots();
                        // Auto-submit when PIN is complete
                        if (pinInput.length === maxPinLength) {
                            setTimeout(submitPin, 300);
                        }
                    }
                } else if (this.classList.contains('clear')) {
                    if (pinInput.length > 0) {
                        pinInput.pop();
                        updateDots();
                        hideErrorMessage();
                    }
                }
            });
        });
        
        function updateDots() {
            let dots = document.querySelectorAll('.dot');
            dots.forEach((dot, index) => {
                if (index < pinInput.length) {
                    dot.classList.add('filled');
                } else {
                    dot.classList.remove('filled');
                }
            });
            document.getElementById('pin-input').value = pinInput.join('');
        }
        
        function submitPin() {
            if (pinInput.length === maxPinLength) {
                document.getElementById('pinForm').submit();
            } else {
                showErrorMessage();
            }
        }
        
        function showErrorMessage() {
            const errorMessage = document.getElementById('error-message');
            errorMessage.classList.add('show');
            setTimeout(hideErrorMessage, 3000);
        }
        
        function hideErrorMessage() {
            const errorMessage = document.getElementById('error-message');
            errorMessage.classList.remove('show');
        }
        
        // Add keyboard support
        document.addEventListener('keydown', function(event) {
            const key = event.key;
            
            if (key >= '0' && key <= '9') {
                if (pinInput.length < maxPinLength) {
                    pinInput.push(key);
                    updateDots();
                    // Auto-submit when PIN is complete
                    if (pinInput.length === maxPinLength) {
                        setTimeout(submitPin, 300);
                    }
                }
            } else if (key === 'Backspace') {
                if (pinInput.length > 0) {
                    pinInput.pop();
                    updateDots();
                    hideErrorMessage();
                }
            } else if (key === 'Enter') {
                submitPin();
            }
        });
    </script>
</body>
</html>