<?php
session_start();
include('db.php'); // Your database connection
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id']; // Current logged-in user
// Fetch user balance
$userQuery = $conn->prepare("SELECT balance FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
// Fetch all paybills from the database
$paybillsQuery = $conn->prepare("SELECT id, name, description, logo_url FROM paybills");
$paybillsQuery->execute();
$paybillsResult = $paybillsQuery->get_result();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>বিল পেমেন্ট সার্ভিস</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #00897b;
            --primary-light: #b2dfdb;
            --secondary-color: #4db6ac;
            --accent-color: #4db6ac;
            --light-bg: #f5f9f8;
            --card-bg: #ffffff;
            --text-primary: #00695c;
            --text-secondary: #00897b;
            --text-light: #ffffff;
            --shadow: 0 4px 15px rgba(0, 137, 123, 0.08);
            --shadow-hover: 0 8px 25px rgba(0, 137, 123, 0.12);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --radius: 20px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Noto Sans Bengali', 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
            padding-bottom: 80px;
            font-weight: 400;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: var(--text-light);
            padding: 18px 22px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
            background: rgba(255, 255, 255, 0.15);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            justify-content: center;
        }
        
        .back-icon:hover {
            transform: translateX(-3px);
            background: rgba(255, 255, 255, 0.25);
        }
        
        .back-icon i {
            font-size: 18px;
        }
        
        .header h3 {
            font-size: 20px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 15px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        
        .balance i {
            margin-right: 6px;
            color: var(--accent-color);
            font-size: 16px;
        }
        
        .main-container {
            max-width: 900px;
            margin: 25px auto;
            padding: 0 15px;
        }
        
        .page-title {
            text-align: center;
            margin: 30px 0 25px;
            color: var(--primary-color);
            position: relative;
            font-size: 24px;
            font-weight: 600;
        }
        
        .page-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            border-radius: 3px;
        }
        
        .search-container {
            background: var(--card-bg);
            border-radius: var(--radius);
            padding: 5px;
            margin-bottom: 30px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        
        .search-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary-color), var(--secondary-color));
            border-radius: 4px 0 0 4px;
        }
        
        .search-container i {
            position: absolute;
            left: 22px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 16px;
            z-index: 1;
        }
        
        .search-container input {
            width: 100%;
            padding: 16px 18px 16px 50px;
            font-size: 15px;
            border: none;
            border-radius: var(--radius);
            box-sizing: border-box;
            transition: var(--transition);
            background-color: var(--light-bg);
            font-weight: 500;
        }
        
        .search-container input:focus {
            outline: none;
            background-color: var(--card-bg);
            box-shadow: 0 0 0 3px rgba(0, 137, 123, 0.08);
        }
        
        .paybill-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        
        .paybill-card {
            background: var(--card-bg);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
            cursor: pointer;
            position: relative;
            display: flex;
            flex-direction: column;
        }
        
        .paybill-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-hover);
        }
        
        .paybill-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.3s ease;
        }
        
        .paybill-card:hover::before {
            transform: scaleX(1);
        }
        
        .paybill-header {
            padding: 22px 22px 15px;
            display: flex;
            align-items: center;
            gap: 18px;
        }
        
        .paybill-logo-container {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            background: linear-gradient(135deg, #f0f8f8, #e0f2f1);
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 6px 12px rgba(0, 137, 123, 0.08);
            flex-shrink: 0;
            position: relative;
            overflow: hidden;
        }
        
        .paybill-logo-container::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at center, rgba(255,255,255,0.8) 0%, rgba(255,255,255,0) 70%);
        }
        
        .paybill-logo {
            width: 65%;
            height: 65%;
            object-fit: contain;
            z-index: 1;
        }
        
        .paybill-info {
            flex-grow: 1;
        }
        
        .paybill-name {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 6px;
            line-height: 1.3;
        }
        
        .paybill-description {
            font-size: 13px;
            color: var(--text-secondary);
            line-height: 1.5;
            display: flex;
            align-items: flex-start;
        }
        
        .paybill-description i {
            margin-right: 6px;
            color: var(--accent-color);
            margin-top: 2px;
            flex-shrink: 0;
            font-size: 14px;
        }
        
        .paybill-footer {
            padding: 14px 22px;
            background: var(--light-bg);
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid rgba(0, 137, 123, 0.08);
        }
        
        .paybill-action {
            color: var(--primary-color);
            font-weight: 600;
            font-size: 14px;
            display: flex;
            align-items: center;
        }
        
        .paybill-action i {
            margin-left: 6px;
            transition: var(--transition);
        }
        
        .paybill-card:hover .paybill-action i {
            transform: translateX(3px);
        }
        
        .paybill-badge {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            font-size: 11px;
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 20px;
            box-shadow: 0 3px 6px rgba(0, 137, 123, 0.15);
        }
        
        .empty-state {
            text-align: center;
            padding: 50px 20px;
            color: var(--text-secondary);
            grid-column: 1 / -1;
            background: var(--card-bg);
            border-radius: var(--radius);
            box-shadow: var(--shadow);
        }
        
        .empty-state i {
            font-size: 56px;
            margin-bottom: 18px;
            color: var(--primary-color);
            opacity: 0.7;
        }
        
        .empty-state h3 {
            font-size: 22px;
            margin-bottom: 10px;
            color: var(--text-primary);
        }
        
        .empty-state p {
            max-width: 400px;
            margin: 0 auto;
            font-size: 15px;
            line-height: 1.6;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -3px 12px rgba(0, 0, 0, 0.06);
            z-index: 100;
            border-top: 1px solid rgba(0, 137, 123, 0.08);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--text-secondary);
            transition: var(--transition);
            padding: 5px 8px;
            border-radius: 12px;
            min-width: 60px;
            position: relative;
        }
        
        .nav-item.active {
            color: var(--primary-color);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 24px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 3px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .header {
                padding: 14px 18px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 13px;
                padding: 6px 12px;
            }
            
            .page-title {
                font-size: 22px;
                margin: 25px 0 20px;
            }
            
            .search-container {
                margin-bottom: 20px;
            }
            
            .search-container input {
                padding: 14px 14px 14px 45px;
            }
            
            .paybill-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .paybill-header {
                padding: 18px 18px 12px;
            }
            
            .paybill-logo-container {
                width: 60px;
                height: 60px;
            }
            
            .paybill-name {
                font-size: 16px;
            }
            
            .paybill-footer {
                padding: 12px 18px;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(15px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .paybill-card {
            animation: fadeIn 0.5s ease forwards;
        }
        
        .paybill-card:nth-child(1) { animation-delay: 0.1s; }
        .paybill-card:nth-child(2) { animation-delay: 0.2s; }
        .paybill-card:nth-child(3) { animation-delay: 0.3s; }
        .paybill-card:nth-child(4) { animation-delay: 0.4s; }
        .paybill-card:nth-child(5) { animation-delay: 0.5s; }
        .paybill-card:nth-child(6) { animation-delay: 0.6s; }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>বিল পেমেন্ট সার্ভিস</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>
    
    <!-- Main Container -->
    <div class="main-container">
        <h2 class="page-title">বিল পেমেন্ট সার্ভিস সমূহ</h2>
        
        <!-- Search Container -->
        <div class="search-container">
            <i class="fas fa-search"></i>
            <input type="text" id="searchInput" onkeyup="searchPaybills()" placeholder="বিল সার্ভিস অনুসন্ধান করুন...">
        </div>
        
        <!-- Paybill Grid -->
        <div class="paybill-grid" id="paybillGrid">
            <?php if ($paybillsResult->num_rows > 0): ?>
                <?php while ($paybill = $paybillsResult->fetch_assoc()): ?>
                    <div class="paybill-card" onclick="window.location.href = 'bill-process.php?id=<?php echo $paybill['id']; ?>'">
                        <div class="paybill-header">
                            <div class="paybill-logo-container">
                                <img src="<?php echo htmlspecialchars($paybill['logo_url']); ?>" alt="<?php echo htmlspecialchars($paybill['name']); ?>" class="paybill-logo">
                            </div>
                            <div class="paybill-info">
                                <div class="paybill-name"><?php echo htmlspecialchars($paybill['name']); ?></div>
                                <div class="paybill-description">
                                    <i class="fas fa-info-circle"></i>
                                    <?php echo htmlspecialchars($paybill['description']); ?>
                                </div>
                            </div>
                        </div>
                        <div class="paybill-footer">
                            <div class="paybill-action">
                                পেমেন্ট করুন <i class="fas fa-arrow-right"></i>
                            </div>
                            <div class="paybill-badge">উপলব্ধ</div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-file-invoice-dollar"></i>
                    <h3>কোন বিল সার্ভিস পাওয়া যায়নি</h3>
                    <p>বর্তমানে কোন বিল পেমেন্ট সার্ভিস উপলব্ধ নেই। পরে আবার চেক করুন।</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <div class="nav-list">
            <a href="/" class="nav-item">
                <i class="fas fa-home nav-icon"></i>
                <div class="nav-label">হোম</div>
            </a>
            <a href="history.php" class="nav-item">
                <i class="fas fa-history nav-icon"></i>
                <div class="nav-label">ইতিহাস</div>
            </a>
            <a href="coin.php" class="nav-item">
                <i class="fas fa-qrcode nav-icon"></i>
                <div class="nav-label">স্ক্যান</div>
            </a>
            <a href="coin.php" class="nav-item">
                <img src="img/tt.png" alt="রিওয়ার্ড" style="width: 16px; height: 14px; margin-bottom: 1px;">
                <div class="nav-label">রিওয়ার্ড</div>
            </a>
            <a href="profile.php" class="nav-item">
                <i class="fas fa-user nav-icon"></i>
                <div class="nav-label">প্রোফাইল</div>
            </a>
        </div>
    </div>
    
    <script>
        function searchPaybills() {
            // Get the search input and filter value
            let input = document.getElementById('searchInput');
            let filter = input.value.toUpperCase();
            let paybillGrid = document.getElementById('paybillGrid');
            let paybillCards = paybillGrid.getElementsByClassName('paybill-card');
            let emptyState = paybillGrid.getElementsByClassName('empty-state')[0];
            let visibleCount = 0;
            
            // Loop through all paybill cards and hide those that don't match the search query
            for (let i = 0; i < paybillCards.length; i++) {
                let paybillName = paybillCards[i].getElementsByClassName('paybill-name')[0];
                let paybillDescription = paybillCards[i].getElementsByClassName('paybill-description')[0];
                let nameText = paybillName.textContent || paybillName.innerText;
                let descText = paybillDescription.textContent || paybillDescription.innerText;
                
                if (nameText.toUpperCase().indexOf(filter) > -1 || descText.toUpperCase().indexOf(filter) > -1) {
                    paybillCards[i].style.display = 'flex';
                    visibleCount++;
                } else {
                    paybillCards[i].style.display = 'none';
                }
            }
            
            // Show or hide empty state based on search results
            if (visibleCount === 0 && filter !== '') {
                if (!document.getElementById('searchEmptyState')) {
                    let searchEmptyState = document.createElement('div');
                    searchEmptyState.id = 'searchEmptyState';
                    searchEmptyState.className = 'empty-state';
                    searchEmptyState.innerHTML = `
                        <i class="fas fa-search"></i>
                        <h3>কোন মিল পাওয়া যায়নি</h3>
                        <p>আপনার অনুসন্ধানের সাথে মেলে এমন কোন বিল সার্ভিস পাওয়া যায়নি।</p>
                    `;
                    paybillGrid.appendChild(searchEmptyState);
                }
            } else {
                let searchEmptyState = document.getElementById('searchEmptyState');
                if (searchEmptyState) {
                    searchEmptyState.remove();
                }
            }
        }
    </script>
</body>
</html>