<?php
// Start the session
session_start();
// Unset all session variables
session_unset();
// Destroy the session
session_destroy();
// Loop through all cookies and unset them
if (isset($_SERVER['HTTP_COOKIE'])) {
    $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
    foreach($cookies as $cookie) {
        $parts = explode('=', $cookie);
        $name = trim($parts[0]);
        // Expire the cookie by setting it to a past time
        setcookie($name, '', time() - 3600, '/', '', true, true);
        setcookie($name, '', time() - 3600, '/', '', false, false);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logged Out - Ramit Wallet</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #006A4E;
            --secondary-color: #F42A41;
            --accent-color: #FFD700;
            --light-bg: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            line-height: 1.6;
        }

        .logout-container {
            width: 100%;
            max-width: 500px;
            background: var(--card-bg);
            border-radius: 20px;
            padding: 50px 40px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .logout-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }

        .logout-icon {
            width: 100px;
            height: 100px;
            margin: 0 auto 30px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            font-size: 40px;
            position: relative;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(0, 106, 78, 0.4);
            }
            70% {
                transform: scale(1.05);
                box-shadow: 0 0 0 15px rgba(0, 106, 78, 0);
            }
            100% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(0, 106, 78, 0);
            }
        }

        .logout-header {
            margin-bottom: 30px;
        }

        .logout-header h1 {
            font-size: 28px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 10px;
        }

        .logout-header p {
            font-size: 16px;
            color: var(--text-secondary);
        }

        .logout-message {
            background-color: rgba(0, 106, 78, 0.1);
            border-left: 4px solid var(--primary-color);
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: left;
        }

        .logout-message p {
            font-size: 16px;
            color: var(--text-primary);
            display: flex;
            align-items: center;
        }

        .logout-message i {
            color: var(--primary-color);
            margin-right: 10px;
            font-size: 18px;
        }

        .redirect-info {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 30px;
        }

        .countdown {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            font-weight: 600;
            margin: 0 10px;
            font-size: 18px;
        }

        .redirect-text {
            font-size: 16px;
            color: var(--text-secondary);
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
        }

        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 30px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), #2e7d32);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .btn-secondary {
            background: linear-gradient(135deg, var(--secondary-color), #c62828);
            color: white;
        }

        .btn-secondary:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .btn i {
            margin-right: 8px;
        }

        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
        }

        .footer p {
            font-size: 14px;
            color: var(--text-secondary);
        }

        .footer a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }

        .footer a:hover {
            text-decoration: underline;
        }

        @media (max-width: 576px) {
            .logout-container {
                padding: 40px 25px;
            }
            
            .logout-header h1 {
                font-size: 24px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="logout-container">
        <div class="logout-icon">
            <i class="fas fa-sign-out-alt"></i>
        </div>
        
        <div class="logout-header">
            <h1>You've Been Logged Out</h1>
            <p>Thank you for using Ramit Wallet</p>
        </div>
        
        <div class="logout-message">
            <p><i class="fas fa-check-circle"></i> You have been successfully logged out of your account. All session data has been cleared for your security.</p>
        </div>
        
        <div class="redirect-info">
            <span class="redirect-text">Redirecting to login in</span>
            <span class="countdown" id="countdown">5</span>
            <span class="redirect-text">seconds</span>
        </div>
        
        <div class="action-buttons">
            <a href="login.php" class="btn btn-primary">
                <i class="fas fa-sign-in-alt"></i> Login Again
            </a>
            <a href="https://ramitwallet.com" class="btn btn-secondary">
                <i class="fas fa-home"></i> Visit Website
            </a>
        </div>
        
        <div class="footer">
            <p>© <?php echo date('Y'); ?> Ramit Wallet. All rights reserved. | <a href="https://ramitwallet.com/privacy">Privacy Policy</a> | <a href="https://ramitwallet.com/terms">Terms of Service</a></p>
        </div>
    </div>

    <script>
        // Countdown timer
        let seconds = 5;
        const countdownElement = document.getElementById('countdown');
        
        const countdownInterval = setInterval(() => {
            seconds--;
            countdownElement.textContent = seconds;
            
            if (seconds <= 0) {
                clearInterval(countdownInterval);
                window.location.href = 'login.php';
            }
        }, 1000);
    </script>
</body>
</html>