<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WhatsApp Helpline - 24/7 Support</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --whatsapp-green: #25D366;
            --whatsapp-dark-green: #128C7E;
            --light-bg: #f8f9fa;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --white: #ffffff;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            line-height: 1.6;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        header {
            text-align: center;
            margin-bottom: 40px;
            padding: 30px 0;
        }

        .logo {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
        }

        .logo i {
            font-size: 48px;
            color: var(--whatsapp-green);
        }

        .logo h1 {
            font-size: 2.5rem;
            color: var(--whatsapp-dark-green);
            font-weight: 700;
        }

        .tagline {
            font-size: 1.2rem;
            color: var(--text-secondary);
            max-width: 600px;
            margin: 0 auto;
        }

        .helpline-card {
            background: var(--white);
            border-radius: 20px;
            padding: 40px;
            box-shadow: var(--shadow);
            text-align: center;
            margin-bottom: 40px;
            transition: var(--transition);
        }

        .helpline-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        }

        .card-title {
            font-size: 1.8rem;
            color: var(--whatsapp-dark-green);
            margin-bottom: 15px;
        }

        .card-description {
            font-size: 1.1rem;
            color: var(--text-secondary);
            margin-bottom: 30px;
        }

        .whatsapp-btn {
            display: inline-flex;
            align-items: center;
            gap: 12px;
            background: var(--whatsapp-green);
            color: var(--white);
            font-size: 1.2rem;
            font-weight: 600;
            padding: 16px 30px;
            border-radius: 50px;
            text-decoration: none;
            box-shadow: 0 4px 12px rgba(37, 211, 102, 0.3);
            transition: var(--transition);
            margin-bottom: 20px;
        }

        .whatsapp-btn:hover {
            background: var(--whatsapp-dark-green);
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(37, 211, 102, 0.4);
        }

        .whatsapp-btn i {
            font-size: 1.5rem;
        }

        .helpline-number {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-top: 15px;
            padding: 15px;
            background: var(--light-bg);
            border-radius: 10px;
            display: inline-block;
        }

        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }

        .feature {
            background: var(--white);
            border-radius: 15px;
            padding: 25px;
            box-shadow: var(--shadow);
            text-align: center;
            transition: var(--transition);
        }

        .feature:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .feature i {
            font-size: 2.5rem;
            color: var(--whatsapp-green);
            margin-bottom: 15px;
        }

        .feature h3 {
            font-size: 1.3rem;
            margin-bottom: 10px;
            color: var(--whatsapp-dark-green);
        }

        .feature p {
            color: var(--text-secondary);
        }

        .faq {
            background: var(--white);
            border-radius: 15px;
            padding: 30px;
            box-shadow: var(--shadow);
            margin-bottom: 40px;
        }

        .faq h2 {
            color: var(--whatsapp-dark-green);
            margin-bottom: 20px;
            text-align: center;
        }

        .faq-item {
            margin-bottom: 20px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }

        .faq-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }

        .faq-question {
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 10px;
            font-size: 1.1rem;
        }

        .faq-answer {
            color: var(--text-secondary);
        }

        footer {
            background: var(--whatsapp-dark-green);
            color: var(--white);
            text-align: center;
            padding: 30px 20px;
            margin-top: auto;
        }

        .footer-content {
            max-width: 800px;
            margin: 0 auto;
        }

        .footer-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-bottom: 15px;
        }

        .footer-logo i {
            font-size: 24px;
        }

        .footer-logo h3 {
            font-size: 1.5rem;
        }

        .footer-text {
            margin-bottom: 15px;
            opacity: 0.9;
        }

        .social-links {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 20px;
        }

        .social-links a {
            color: var(--white);
            font-size: 1.2rem;
            transition: var(--transition);
        }

        .social-links a:hover {
            color: var(--whatsapp-green);
            transform: translateY(-3px);
        }

        @media (max-width: 768px) {
            .logo h1 {
                font-size: 2rem;
            }
            
            .helpline-card {
                padding: 30px 20px;
            }
            
            .whatsapp-btn {
                font-size: 1.1rem;
                padding: 14px 25px;
            }
            
            .helpline-number {
                font-size: 1.3rem;
            }
            
            .features {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="logo">
                <i class="fab fa-whatsapp"></i>
                <h1>WhatsApp Helpline</h1>
            </div>
            <p class="tagline">Instant support at your fingertips. Connect with us anytime, anywhere.</p>
        </header>

        <div class="helpline-card">
            <h2 class="card-title">Need Assistance? We're Here to Help!</h2>
            <p class="card-description">Our dedicated support team is available 24/7 to assist you with any questions or concerns.</p>
            
            <a href="https://wa.me/8801796003076" target="_blank" class="whatsapp-btn">
                <i class="fab fa-whatsapp"></i>
                Chat on WhatsApp
            </a>
            
            <div class="helpline-number">
                <i class="fas fa-phone-alt"></i> +8801796003076
            </div>
        </div>

        <div class="features">
            <div class="feature">
                <i class="fas fa-clock"></i>
                <h3>24/7 Availability</h3>
                <p>Our helpline is available round the clock to assist you whenever you need help.</p>
            </div>
            
            <div class="feature">
                <i class="fas fa-comments"></i>
                <h3>Instant Response</h3>
                <p>Get quick responses to your queries without long waiting times.</p>
            </div>
            
            <div class="feature">
                <i class="fas fa-user-shield"></i>
                <h3>Secure & Private</h3>
                <p>Your conversations are encrypted and your privacy is our top priority.</p>
            </div>
        </div>

        <div class="faq">
            <h2>Frequently Asked Questions</h2>
            
            <div class="faq-item">
                <div class="faq-question">How quickly will I get a response?</div>
                <div class="faq-answer">We typically respond within minutes during business hours and within a few hours during off-peak times.</div>
            </div>
            
            <div class="faq-item">
                <div class="faq-question">Is there a charge for using this helpline?</div>
                <div class="faq-answer">No, our WhatsApp helpline is completely free to use. Standard data rates may apply as per your mobile plan.</div>
            </div>
            
            <div class="faq-item">
                <div class="faq-question">What kind of issues can I get help with?</div>
                <div class="faq-answer">Our helpline assists with product inquiries, technical support, account issues, and general questions about our services.</div>
            </div>
        </div>
    </div>

    <footer>
        <div class="footer-content">
            <div class="footer-logo">
                <i class="fab fa-whatsapp"></i>
                <h3>WhatsApp Helpline</h3>
            </div>
            <p class="footer-text">Connecting you to solutions, one message at a time.</p>
            <p>&copy; 2023 WhatsApp Helpline. All rights reserved.</p>
            
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-linkedin-in"></i></a>
            </div>
        </div>
    </footer>
</body>
</html>