<?php
session_start();
include('db.php'); // Your database connection
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id']; // Current logged-in user
// Fetch all operators for the top operator logos
$operatorsQuery = $conn->prepare("SELECT id, name, logo_url FROM operators");
$operatorsQuery->execute();
$operatorsResult = $operatorsQuery->get_result();
// Fetch all offers (or filter by operator if operator_id is provided via GET)
$operatorId = isset($_GET['operator_id']) ? $_GET['operator_id'] : null;
if ($operatorId) {
    // Fetch offers for the selected operator
    $offersQuery = $conn->prepare("SELECT * FROM offers WHERE operator_id = ?");
    $offersQuery->bind_param("i", $operatorId);
} else {
    // Fetch offers from all operators (mix)
    $offersQuery = $conn->prepare("SELECT * FROM offers");
}
$offersQuery->execute();
$offersResult = $offersQuery->get_result();
// Fetch user data (balance and PIN) from the database
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অপারেটর অফার</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --teal-primary: #008080; /* Main teal color */
            --teal-light: #e0fffe; /* Very light teal */
            --teal-medium: #4dbdbd; /* Medium teal */
            --teal-dark: #004d40; /* Dark teal */
            --teal-bg-light: #f0f8f8; /* Very light teal background */
            --teal-text-dark: #004d40; /* Dark teal text */
            --teal-text-medium: #00695c; /* Medium teal text */
            --teal-text-light: #00a39a; /* Light teal text */
            --teal-gray-lightest: #f5fafa; /* Very light teal gray */
            --teal-gray-light: #e0f2f1; /* Light teal gray */
            --teal-gray: #80cbc4; /* Medium teal gray */
            --teal-gray-dark: #00695c; /* Dark teal gray */
            --teal-border: #b2dfdb; /* Light teal border */
            --teal-success: #2ecc71; /* Success color (unchanged) */
            --teal-warning: #f39c12; /* Warning color (unchanged) */
            --teal-danger: #e74c3c; /* Danger color (unchanged) */
            --teal-blue: #3498db; /* Blue accent (unchanged) */
            --transition: all 0.3s ease;
        }
        
        body {
            background: var(--teal-bg-light);
            color: var(--teal-text-dark);
            font-size: 14px;
            line-height: 1.4;
        }
        
        .app-container {
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
            padding-bottom: 70px;
        }
        
        /* Header Styles */
        .app-header {
            background: white;
            padding: 15px;
            color: var(--teal-text-dark);
            position: relative;
            border-bottom: 1px solid var(--teal-border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: var(--teal-light);
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--teal-primary);
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: var(--teal-primary);
            color: white;
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
        }
        
        .balance-badge {
            background: var(--teal-light);
            border-radius: 20px;
            padding: 6px 12px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 5px;
            color: var(--teal-primary);
        }
        
        /* Page Title */
        .page-title {
            text-align: center;
            margin: 15px 0;
            color: var(--teal-primary);
            font-size: 18px;
            font-weight: 600;
            position: relative;
        }
        
        .page-title::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 2px;
            background: var(--teal-primary);
            border-radius: 2px;
        }
        
        /* Operator Container */
        .operator-container {
            display: flex;
            overflow-x: auto;
            padding: 5px 15px 15px;
            margin-bottom: 15px;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        
        .operator-container::-webkit-scrollbar {
            display: none;
        }
        
        .operator-box {
            flex: 0 0 auto;
            width: 80px;
            text-align: center;
            background: white;
            padding: 10px 5px;
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            margin: 0 5px;
            cursor: pointer;
            transition: var(--transition);
            border: 1px solid var(--teal-border);
        }
        
        .operator-box:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 10px rgba(0, 128, 128, 0.15);
            border-color: var(--teal-primary);
        }
        
        .operator-box.active {
            border-color: var(--teal-primary);
            background: var(--teal-light);
        }
        
        .operator-box img {
            width: 40px;
            height: 40px;
            object-fit: contain;
            margin-bottom: 5px;
        }
        
        .operator-name {
            font-size: 12px;
            font-weight: 500;
            color: var(--teal-text-dark);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        /* Offers Container */
        .offers-container {
            padding: 0 15px;
        }
        
        .section-title {
            font-size: 16px;
            font-weight: 600;
            color: var(--teal-text-dark);
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .section-title i {
            color: var(--teal-primary);
        }
        
        /* Offer Item */
        .offer-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px;
            margin-bottom: 10px;
            border-radius: 10px;
            background: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: var(--transition);
            cursor: pointer;
            border-left: 3px solid transparent;
        }
        
        .offer-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 128, 128, 0.15);
            border-left-color: var(--teal-primary);
        }
        
        .offer-info {
            display: flex;
            align-items: center;
        }
        
        .offer-icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: var(--teal-light);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .offer-icon img {
            width: 25px;
            height: 25px;
            object-fit: contain;
        }
        
        .offer-details {
            display: flex;
            flex-direction: column;
        }
        
        .offer-name {
            font-size: 14px;
            font-weight: 600;
            color: var(--teal-text-dark);
            margin-bottom: 3px;
        }
        
        .validity {
            font-size: 12px;
            color: var(--teal-gray);
            display: flex;
            align-items: center;
        }
        
        .validity i {
            margin-right: 4px;
            color: var(--teal-primary);
            font-size: 10px;
        }
        
        .price-container {
            display: flex;
            flex-direction: column;
            align-items: flex-end;
        }
        
        .price {
            font-size: 16px;
            font-weight: 700;
            color: var(--teal-primary);
            display: flex;
            align-items: center;
        }
        
        .price i {
            margin-right: 4px;
            font-size: 12px;
        }
        
        .buy-btn {
            background: var(--teal-primary);
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 5px;
            transition: var(--transition);
            display: flex;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0, 128, 128, 0.3);
        }
        
        .buy-btn:hover {
            background: var(--teal-dark);
            transform: translateY(-1px);
        }
        
        .buy-btn i {
            margin-right: 3px;
            font-size: 9px;
        }
        
        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: var(--teal-gray);
        }
        
        .empty-state i {
            font-size: 36px;
            margin-bottom: 10px;
            color: var(--teal-primary);
        }
        
        .empty-state h3 {
            font-size: 16px;
            margin-bottom: 5px;
            color: var(--teal-text-dark);
        }
        
        .empty-state p {
            font-size: 13px;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.1);
            z-index: 100;
            border-top: 1px solid var(--teal-border);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 8px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--teal-gray);
            transition: var(--transition);
            padding: 5px;
            border-radius: 8px;
            min-width: 60px;
            position: relative;
        }
        
        .nav-item.active {
            color: var(--teal-primary);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 3px;
            background: var(--teal-primary);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 2px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">অপারেটর অফার</h1>
            <div class="balance-badge">
                <i class="fas fa-wallet"></i>
                ৳<?php echo number_format($userBalance, 2); ?>
            </div>
        </div>
        
        <!-- Main Container -->
        <div class="main-container">
            <h2 class="page-title">মোবাইল অপারেটর অফার</h2>
            
            <!-- Operator Logos Container -->
            <div class="operator-container">
                <?php 
                // Reset the result pointer to fetch operators again
                $operatorsResult->data_seek(0);
                while ($operator = $operatorsResult->fetch_assoc()) : 
                    $isActive = ($operatorId && $operator['id'] == $operatorId) ? 'active' : '';
                ?>
                    <div class="operator-box <?php echo $isActive; ?>" onclick="filterOffers(<?php echo $operator['id']; ?>)">
                        <img src="<?php echo $operator['logo_url']; ?>" alt="<?php echo htmlspecialchars($operator['name']); ?>">
                        <div class="operator-name"><?php echo htmlspecialchars($operator['name']); ?></div>
                    </div>
                <?php endwhile; ?>
                
                <!-- All Operators Option -->
                <div class="operator-box <?php echo !$operatorId ? 'active' : ''; ?>" onclick="filterOffers('all')">
                    <i class="fas fa-th" style="font-size: 24px; color: var(--teal-primary);"></i>
                    <div class="operator-name">সব অফার</div>
                </div>
            </div>
            
            <!-- Offers List Container -->
            <div class="offers-container">
                <div class="section-title">
                    <i class="fas fa-tags"></i>
                    উপলব্ধ অফার
                </div>
                
                <?php if ($offersResult->num_rows > 0): ?>
                    <?php while ($offer = $offersResult->fetch_assoc()) : ?>
                        <div class="offer-item" onclick="window.location.href = 'drive-buy.php?id=<?php echo $offer['id']; ?>'">
                            <div class="offer-info">
                                <div class="offer-icon">
                                    <img src="img/<?php echo strtolower($offer['operator_id']); ?>.png" alt="<?php echo htmlspecialchars($offer['offer_name']); ?>">
                                </div>
                                <div class="offer-details">
                                    <div class="offer-name"><?php echo htmlspecialchars($offer['offer_name']); ?></div>
                                    <div class="validity">
                                        <i class="far fa-clock"></i>
                                        <?php echo htmlspecialchars($offer['validity']); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="price-container">
                                <div class="price">
                                    <i class="fas fa-money-bill-wave"></i>
                                    ৳<?php echo number_format($offer['price'], 2); ?>
                                </div>
                                <button class="buy-btn">
                                    <i class="fas fa-shopping-cart"></i>
                                    কিনুন
                                </button>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-tags"></i>
                        <h3>কোন অফার নেই</h3>
                        <p>এই অপারেটরের জন্য বর্তমানে কোন অফার উপলব্ধ নেই।</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Bottom Navigation -->
        <div class="bottom-nav">
            <div class="nav-list">
                <a href="/" class="nav-item">
                    <i class="fas fa-home nav-icon"></i>
                    <div class="nav-label">হোম</div>
                </a>
                <a href="history.php" class="nav-item">
                    <i class="fas fa-history nav-icon"></i>
                    <div class="nav-label">ইতিহাস</div>
                </a>
                <a href="coin.php" class="nav-item">
                    <i class="fas fa-qrcode nav-icon"></i>
                    <div class="nav-label">স্ক্যান</div>
                </a>
                <a href="coin.php" class="nav-item">
                    <img src="img/tt.png" alt="Rewards" style="width: 16px; height: 14px; margin-bottom: 1px;">
                    <div class="nav-label">রিওয়ার্ড</div>
                </a>
                <a href="profile.php" class="nav-item">
                    <i class="fas fa-user nav-icon"></i>
                    <div class="nav-label">প্রোফাইল</div>
                </a>
            </div>
        </div>
    </div>
    
    <script>
        function filterOffers(operatorId) {
            if (operatorId === 'all') {
                window.location.href = '?operator_id=';
            } else {
                window.location.href = '?operator_id=' + operatorId;
            }
        }
    </script>
</body>
</html>