<?php
// Start the session
session_start();
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    // If the user is not logged in, redirect to the login page
    header("Location: login.php");
    exit;
}
if (isset($_SESSION['tt']) && $_SESSION['tt'] === 'rayhan') {
    // Admin user
    $is_admin = true;
} else {
    $is_admin = false;
}
// Include the database connection
include('db.php');
// Handle image deletion (only for admin)
if (isset($_GET['delete_id']) && $is_admin) {
    $id = $_GET['delete_id'];
    
    // Get image path before deletion
    $sql = "SELECT image_url FROM banners WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    if ($row) {
        $imagePath = $row['image_url'];
        
        // Delete from database
        $sql = "DELETE FROM banners WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            // Delete file from server
            if (file_exists($imagePath)) {
                unlink($imagePath);
            }
            $delete_success = "Image deleted successfully!";
        } else {
            $delete_error = "Error deleting image: " . $conn->error;
        }
    }
}
// Fetch notice from the database
$sql = "SELECT home FROM settings WHERE id = 1";
$result = $conn->query($sql);
$settings = $result->fetch_assoc();
$notice = $settings['home'] ?? '';
// Fetch notices from the database
$sql = "SELECT message FROM notices ORDER BY created_at DESC";
$result = $conn->query($sql);
$notices = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $notices[] = $row['message'];
    }
}
// Convert notices array to a single string for display
$scrollingText = implode(' | ', $notices);
// Check if the popup should be shown (based on session)
$showPopup = !isset($_SESSION['notice']);
// If the popup is dismissed, set the session 'notice' to true
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['dismiss_popup'])) {
    $_SESSION['notice'] = true;
    echo json_encode(['status' => 'Popup dismissed']);
    exit;
}
// Fetch the logged-in user information including the PIN
$sql = "SELECT name, balance, reward_points, profile_image, pin FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
// If no user is found, redirect to the login page
if (!$user) {
    $_SESSION['message'] = "User not found!";
    $_SESSION['message_type'] = "error";
    header("Location: login.php");
    exit;
}
// Check if the user has no PIN
if (empty($user['pin'])) {
    // Store a session variable to indicate PIN setup
    $_SESSION['setup_pin'] = true;
    header("Location: pin.php");
    exit;
}
// Fetch banners from the database
$sql_banners = "SELECT id, image_url FROM banners ORDER BY id DESC";
$stmt_banners = $conn->prepare($sql_banners);
$stmt_banners->execute();
$result_banners = $stmt_banners->get_result();
$banners = $result_banners->fetch_all(MYSQLI_ASSOC);
// Add the hardcoded images to the banners array
$hardcoded_images = [
    ['id' => -1, 'image_url' => 'https://ibb.co.com/vxwJxQzY'],
    ['id' => -2, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-2.png'],
    ['id' => -3, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-3.png'],
    ['id' => -4, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-4.png'],
    ['id' => -5, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-5.png'],
    ['id' => -6, 'image_url' => 'https://admin.ramitwallet.com/slider/slider-5.png'],
];
// Merge database banners with hardcoded images
$all_banners = array_merge($banners, $hardcoded_images);
// Array of recipient users (this data could also come from the database if needed)
$recipients = [
    ['name' => 'Dubai', 'image' => 'https://flagcdn.com/w320/ae.png'],
    ['name' => 'Qatar', 'image' => 'https://www.countryflags.com/wp-content/uploads/qatar-flag-png-large.png'],
    ['name' => 'Saudi Arab', 'image' => 'https://flagcdn.com/w320/sa.png'], 
    ['name' => 'Malaysia', 'image' => 'https://flagcdn.com/w320/my.png'],
    ['name' => 'Oman', 'image' => 'https://www.countryflags.com/wp-content/uploads/oman-flag-png-large.png'],
    ['name' => 'Bahrain', 'image' => 'https://flagpedia.net/data/flags/w580/bh.webp'],
    ['name' => 'Kuwait', 'image' => 'https://flagpedia.net/data/flags/w580/kw.webp'],
];

// Promotion offers data
$promotions = [
    [
        'title' => '🎉 বিশেষ অফার!',
        'desc' => 'এই সপ্তাহে মোবাইল রিচার্জে পাচ্ছেন 10% ক্যাশব্যাক।',
        'gradient' => 'linear-gradient(135deg, #f39c12, #e67e22)'
    ],
    [
        'title' => '💰 রেফার বোনাস!',
        'desc' => 'বন্ধুকে রেফার করুন এবং পান ৳100 বোনাস।',
        'gradient' => 'linear-gradient(135deg, #3498db, #2980b9)'
    ],
    [
        'title' => '🎁 জন্মদিন অফার!',
        'desc' => 'জন্মদিনে ৳500 ক্যাশব্যাক এবং বিশেষ উপহার।',
        'gradient' => 'linear-gradient(135deg, #9b59b6, #8e44ad)'
    ],
    [
        'title' => '📱 বিল পেমেন্ট!',
        'desc' => 'বিল পেমেন্টে পাচ্ছেন 5% ইনস্ট্যান্ট ক্যাশব্যাক।',
        'gradient' => 'linear-gradient(135deg, #1abc9c, #16a085)'
    ],
    [
        'title' => '🚗 ড্রাইভ অফার!',
        'desc' => 'ড্রাইভ অফারে পাচ্ছেন ৳200 ক্যাশব্যাক।',
        'gradient' => 'linear-gradient(135deg, #e74c3c, #c0392b)'
    ]
];
?>
<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>WorldBkash — Home</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Hind Siliguri', sans-serif;
      -webkit-tap-highlight-color: transparent;
    }
    
    :root {
      --teal-primary: #008080;
      --teal-light: #e0fffe;
      --teal-dark: #004d40;
      --teal-medium: #4dbdbd;
      --teal-text-dark: #004d40;
      --teal-text-medium: #00695c;
      --teal-text-light: #00a39a;
      --teal-gray-lightest: #f5fafa;
      --teal-gray-light: #e0f2f1;
      --teal-gray: #80cbc4;
      --teal-gray-dark: #00695c;
      --teal-border: #b2dfdb;
      --teal-success: #2ecc71;
      --teal-warning: #f39c12;
      --teal-danger: #e74c3c;
      --teal-blue: #3498db;
      --transition: all 0.3s ease;
      --shadow: 0 4px 12px rgba(0, 128, 128, 0.15);
    }
    
    body {
      background: var(--teal-gray-lightest);
      color: var(--teal-text-dark);
      font-size: 14px;
      line-height: 1.6;
      min-height: 100vh;
      padding-bottom: 70px;
    }
    
    .app-container {
      max-width: 480px;
      margin: 0 auto;
      min-height: 100vh;
      background: #ffffff;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      position: relative;
      overflow: hidden;
    }
    
    /* Header Styles */
    .app-header {
      background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
      color: white;
      padding: 15px 20px;
      box-shadow: var(--shadow);
      position: sticky;
      top: 0;
      z-index: 100;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .menu-btn,
    .notification-btn {
      background: rgba(255, 255, 255, 0.2);
      border: none;
      width: 36px;
      height: 36px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      cursor: pointer;
      transition: var(--transition);
      position: relative;
    }
    
    .menu-btn:hover,
    .notification-btn:hover {
      background: rgba(255, 255, 255, 0.3);
      transform: scale(1.05);
    }
    
    .header-title {
      font-size: 18px;
      font-weight: 600;
      text-align: center;
      flex-grow: 1;
    }
    
    .notification-badge {
      position: absolute;
      top: 0;
      right: 0;
      width: 18px;
      height: 18px;
      background: var(--teal-danger);
      color: white;
      border-radius: 50%;
      font-size: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 600;
    }
    
    /* Balance Card */
    .balance-card {
      margin: 20px;
      background: linear-gradient(135deg, var(--teal-primary), var(--teal-dark));
      border-radius: 15px;
      padding: 20px;
      color: white;
      box-shadow: var(--shadow);
      position: relative;
      overflow: hidden;
    }
    
    .balance-greeting {
      font-size: 16px;
      opacity: 0.9;
      margin-bottom: 5px;
      display: flex;
      align-items: center;
    }
    
    .balance-greeting i {
      margin-right: 8px;
      font-size: 18px;
    }
    
    .balance-label { 
      font-size: 14px; 
      opacity: 0.9; 
      margin-bottom: 5px; 
    }
    
    .balance-amount { 
      font-size: 28px; 
      font-weight: 700; 
      margin-bottom: 15px; 
    }
    
    .balance-actions { 
      display: flex; 
      gap: 10px; 
    }
    
    .balance-action {
      flex: 1;
      background: rgba(255, 255, 255, 0.2);
      border: none;
      border-radius: 8px;
      padding: 8px;
      color: white;
      font-size: 12px;
      font-weight: 600;
      cursor: pointer;
      transition: var(--transition);
    }
    
    .balance-action:hover { 
      background: rgba(255, 255, 255, 0.3); 
    }
    
    /* Quick Actions */
    .quick-actions { 
      padding: 0 20px 20px; 
    }
    
    .section-title {
      font-size: 18px; 
      font-weight: 600; 
      color: var(--teal-primary);
      margin-bottom: 15px; 
      text-align: center; 
      position: relative;
    }
    
    .section-title::after {
      content: ''; 
      position: absolute; 
      bottom: -6px; 
      left: 50%;
      transform: translateX(-50%); 
      width: 50px; 
      height: 3px;
      background: var(--teal-primary); 
      border-radius: 3px;
    }
    
    .actions-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 15px;
    }
    
    .action-item {
      background: white; 
      border-radius: 12px; 
      padding: 15px 5px;
      text-align: center; 
      box-shadow: 0 3px 8px rgba(0, 0, 0, 0.08);
      transition: var(--transition); 
      cursor: pointer;
    }
    
    .action-item:hover { 
      transform: translateY(-3px); 
      box-shadow: 0 6px 12px rgba(0, 128, 128, 0.15); 
    }
    
    .action-icon { 
      font-size: 24px; 
      color: var(--teal-primary); 
      margin-bottom: 8px; 
    }
    
    .action-name { 
      font-size: 12px; 
      font-weight: 500; 
      color: var(--teal-text-dark); 
    }
    
    /* Services */
    .services-section { 
      padding: 0 20px 20px; 
    }
    
    .services-grid { 
      display: grid; 
      grid-template-columns: repeat(2, 1fr); 
      gap: 15px; 
    }
    
    .service-card {
      background: white; 
      border-radius: 12px; 
      padding: 15px;
      box-shadow: 0 3px 8px rgba(0, 0, 0, 0.08);
      transition: var(--transition); 
      cursor: pointer; 
      display: flex; 
      align-items: center;
    }
    
    .service-card:hover { 
      transform: translateY(-3px); 
      box-shadow: 0 6px 12px rgba(0, 128, 128, 0.15); 
    }
    
    .service-icon {
      width: 50px; 
      height: 50px; 
      background: var(--teal-light);
      border-radius: 10px; 
      display: flex; 
      align-items: center; 
      justify-content: center;
      margin-right: 15px; 
      color: var(--teal-primary); 
      font-size: 20px;
    }
    
    .service-name { 
      font-size: 15px; 
      font-weight: 600; 
      margin-bottom: 3px; 
    }
    
    .service-desc { 
      font-size: 12px; 
      color: var(--teal-text-medium); 
    }
    
    /* Currency Rates */
    .rates-section {
      padding: 0 20px 20px;
    }
    
    .rates {
      display: flex;
      gap: 12px;
      overflow: auto;
      padding: 8px 0;
      margin-top: 8px;
    }
    
    .rate {
      min-width: 68px;
      text-align: center;
    }
    
    .flag {
      width: 64px;
      height: 38px;
      border-radius: 8px;
      background: #fff;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 18px;
      margin: 0 auto 6px;
      border: 1px solid rgba(0,0,0,0.03);
    }
    
    .flag img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      border-radius: 8px;
    }
    
    .rate span {
      font-size: 12px;
      color: #111;
    }
    
    /* Promotions - Updated */
    .promotions-section { 
      padding: 0 20px 20px; 
    }
    
    .promotions-container {
      display: flex;
      overflow-x: auto;
      gap: 15px;
      padding: 5px 0 15px;
      scroll-behavior: smooth;
      -webkit-overflow-scrolling: touch;
      scrollbar-width: none; /* Firefox */
      -ms-overflow-style: none; /* IE and Edge */
    }
    
    .promotions-container::-webkit-scrollbar {
      display: none; /* Chrome, Safari, Opera */
    }
    
    .promotion-card {
      min-width: 280px;
      border-radius: 12px; 
      padding: 20px; 
      color: white; 
      box-shadow: var(--shadow);
      flex-shrink: 0;
      transition: transform 0.3s ease;
    }
    
    .promotion-card:hover {
      transform: translateY(-5px);
    }
    
    .promotion-title { 
      font-size: 18px; 
      font-weight: 700; 
      margin-bottom: 10px; 
    }
    
    .promotion-desc {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.4;
    }
    
    .promotion-btn {
      background: white; 
      color: var(--teal-warning);
      border: none; 
      border-radius: 20px; 
      padding: 8px 15px; 
      font-weight: 600;
      cursor: pointer; 
      transition: var(--transition);
      font-size: 14px;
    }
    
    .promotion-btn:hover { 
      transform: translateY(-2px); 
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); 
    }
    
    /* Footer */
    .footer { 
      padding: 20px; 
      text-align: center; 
      font-size: 13px; 
      color: var(--teal-text-medium); 
    }
    
    .footer-links { 
      display: flex; 
      justify-content: center; 
      gap: 15px; 
      margin-top: 10px; 
    }
    
    .footer-link { 
      color: var(--teal-primary); 
      text-decoration: none; 
      font-weight: 500; 
    }
    
    /* Popup Notice - Updated */
    .popup-overlay {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.7);
      z-index: 1000;
      animation: fadeIn 0.3s ease;
    }
    
    .popup-overlay.show {
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }
    
    .popup-notice {
      background: linear-gradient(135deg, #008080, #004d40);
      border-radius: 20px;
      padding: 30px;
      max-width: 90%;
      width: 350px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
      animation: popIn 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      position: relative;
      overflow: hidden;
    }
    
    .popup-notice::before {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
      z-index: 0;
    }
    
    @keyframes popIn {
      0% { 
        opacity: 0;
        transform: scale(0.8) translateY(50px);
      }
      80% {
        transform: scale(1.05) translateY(-10px);
      }
      100% { 
        opacity: 1;
        transform: scale(1) translateY(0);
      }
    }
    
    .popup-header {
      text-align: center;
      margin-bottom: 20px;
      position: relative;
      z-index: 1;
    }
    
    .popup-icon {
      width: 60px;
      height: 60px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 15px;
      font-size: 28px;
      color: white;
    }
    
    .popup-title {
      font-size: 22px;
      font-weight: 700;
      color: white;
      margin-bottom: 5px;
    }
    
    .popup-content {
      font-size: 15px;
      color: rgba(255, 255, 255, 0.9);
      line-height: 1.6;
      margin-bottom: 25px;
      position: relative;
      z-index: 1;
    }
    
    .popup-close {
      background: white;
      color: var(--teal-primary);
      border: none;
      border-radius: 30px;
      padding: 12px 30px;
      font-weight: 600;
      cursor: pointer;
      transition: all .3s ease;
      display: block;
      margin: 0 auto;
      font-size: 15px;
      position: relative;
      z-index: 1;
    }
    
    .popup-close:hover {
      background: var(--teal-light);
      transform: translateY(-3px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
    
    /* Drawer Menu */
    .drawer-overlay {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.5);
      z-index: 999;
      opacity: 0;
      visibility: hidden;
      transition: all 0.3s ease;
    }
    
    .drawer-overlay.active {
      opacity: 1;
      visibility: visible;
    }
    
    .drawer {
      position: fixed;
      top: 0;
      left: -280px;
      width: 280px;
      height: 100%;
      background: white;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
      z-index: 1000;
      transition: all 0.3s ease;
      overflow-y: auto;
    }
    
    .drawer.active {
      left: 0;
    }
    
    .drawer-header {
      background: linear-gradient(135deg, var(--teal-primary), var(--teal-medium));
      color: white;
      padding: 20px;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
    
    .drawer-title {
      font-size: 18px;
      font-weight: 600;
    }
    
    .drawer-close {
      background: rgba(255, 255, 255, 0.2);
      border: none;
      width: 32px;
      height: 32px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      cursor: pointer;
      transition: var(--transition);
    }
    
    .drawer-close:hover {
      background: rgba(255, 255, 255, 0.3);
      transform: scale(1.05);
    }
    
    .drawer-user {
      padding: 20px;
      display: flex;
      align-items: center;
      border-bottom: 1px solid var(--teal-border);
    }
    
    .drawer-avatar {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background: var(--teal-light);
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 15px;
      color: var(--teal-primary);
      font-size: 20px;
      overflow: hidden;
    }
    
    .drawer-avatar img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }
    
    .drawer-user-info h3 {
      font-size: 16px;
      font-weight: 600;
      color: var(--teal-text-dark);
      margin-bottom: 4px;
    }
    
    .drawer-user-info p {
      font-size: 12px;
      color: var(--teal-text-medium);
    }
    
    .drawer-menu {
      padding: 10px 0;
    }
    
    .drawer-item {
      display: flex;
      align-items: center;
      padding: 15px 20px;
      color: var(--teal-text-dark);
      text-decoration: none;
      transition: var(--transition);
    }
    
    .drawer-item:hover {
      background: var(--teal-gray-lightest);
    }
    
    .drawer-item i {
      font-size: 18px;
      margin-right: 15px;
      color: var(--teal-primary);
      width: 24px;
      text-align: center;
    }
    
    .drawer-item span {
      font-size: 14px;
      font-weight: 500;
    }
    
    .drawer-divider {
      height: 1px;
      background: var(--teal-border);
      margin: 10px 20px;
    }
    
    .drawer-footer {
      padding: 20px;
      text-align: center;
      border-top: 1px solid var(--teal-border);
      font-size: 12px;
      color: var(--teal-text-medium);
    }
    
    /* Bottom Navigation - Updated from recharge.php */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.1);
      z-index: 100;
      border-top: 1px solid var(--teal-border);
    }
    
    .nav-list {
      display: flex;
      justify-content: space-around;
      padding: 8px 0;
    }
    
    .nav-item {
      text-align: center;
      text-decoration: none;
      color: var(--teal-gray);
      transition: var(--transition);
      padding: 5px;
      border-radius: 8px;
      min-width: 60px;
      position: relative;
    }
    
    .nav-item.active {
      color: var(--teal-primary);
    }
    
    .nav-item.active::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 50%;
      transform: translateX(-50%);
      width: 30px;
      height: 3px;
      background: var(--teal-primary);
      border-radius: 3px;
    }
    
    .nav-icon {
      font-size: 18px;
      margin-bottom: 2px;
    }
    
    .nav-label {
      font-size: 10px;
      font-weight: 500;
    }
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
  <div class="app-container">
    <!-- Header -->
    <header class="app-header">
      <button class="menu-btn" id="menuBtn"><i class="fas fa-bars"></i></button>
      <h1 class="header-title">WorldBkash</h1>
      <button class="notification-btn">
        <i class="fas fa-bell"></i>
        <span class="notification-badge">2</span>
      </button>
    </header>
    
    <!-- Balance Card -->
    <section class="balance-card">
      <div class="balance-greeting">
        <i class="fas fa-user-circle"></i>
        <span>হ্যালো, <?php echo $user['name']; ?>!</span>
      </div>
      <div class="balance-label">অ্যাকাউন্ট ব্যালেন্স</div>
      <div class="balance-amount">৳ <?php echo number_format($user['balance'], 2); ?></div>
      <div class="balance-actions">
        <button class="balance-action">টাকা পাঠান</button>
        <button class="balance-action">ক্যাশ আউট</button>
      </div>
    </section>
    
    <!-- Quick Actions -->
    <section class="quick-actions">
      <h2 class="section-title">দ্রুত সেবা</h2>
      <div class="actions-grid">
        <div class="action-item">
          <a href="addmoney.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-plus-circle action-icon"></i>
            <div class="action-name">অ্যাড মানি</div>
          </a>
        </div>
        <div class="action-item">
          <a href="sendmoney.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-paper-plane action-icon"></i>
            <div class="action-name">সেন্ড মানি</div>
          </a>
        </div>
        <div class="action-item">
          <a href="drive.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-gift action-icon"></i>
            <div class="action-name">ড্রাইভ অফার</div>
          </a>
        </div>
        <div class="action-item">
          <a href="recharge.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-mobile-alt action-icon"></i>
            <div class="action-name">মোবাইল রিচার্জ</div>
          </a>
        </div>
        <div class="action-item">
          <a href="coin.php?id=1" style="text-decoration:none;color:inherit">
            <i class="fas fa-coins action-icon"></i>
            <div class="action-name">স্পেশাল অফার</div>
          </a>
        </div>
        <div class="action-item">
          <a href="reward_convert.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-award action-icon"></i>
            <div class="action-name">কমিশন</div>
          </a>
        </div>
        <div class="action-item">
          <a href="loan.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-hand-holding-usd action-icon"></i>
            <div class="action-name">লোন</div>
          </a>
        </div>
        <div class="action-item">
          <a href="paybill.php" style="text-decoration:none;color:inherit">
            <i class="fas fa-file-invoice-dollar action-icon"></i>
            <div class="action-name">পে বিল</div>
          </a>
        </div>
      </div>
    </section>
    
    <!-- Services -->
    <section class="services-section">
      <h2 class="section-title">সেবা সমূহ</h2>
      <div class="services-grid">
        <div class="service-card">
          <div class="service-icon"><i class="fas fa-university"></i></div>
          <div>
            <div class="service-name">Bank Transfer</div>
            <div class="service-desc">টাকা ব্যাংকে পাঠান</div>
          </div>
        </div>
        <div class="service-card">
          <div class="service-icon"><i class="fas fa-bolt"></i></div>
          <div>
            <div class="service-name">Electricity Bill</div>
            <div class="service-desc">বিদ্যুৎ বিল পরিশোধ করুন</div>
          </div>
        </div>
      </div>
    </section>
    
    <!-- Currency Rates -->
    <section class="rates-section">
      <h2 class="section-title">আজকে আমাদের কোম্পানির চলমান রেট সমূহ</h2>
      <div class="rates">
        <?php foreach ($recipients as $recipient): ?>
        <div class="rate">
          <a href="/worlbkash/country/<?php echo strtolower(str_replace(' ', '', $recipient['name'])); ?>.php" style="text-decoration:none;color:inherit">
            <div class="flag">
              <img src="<?php echo $recipient['image']; ?>" alt="<?php echo $recipient['name']; ?>">
            </div>
            <span><?php echo $recipient['name']; ?></span>
          </a>
        </div>
        <?php endforeach; ?>
      </div>
    </section>
    
    <!-- Promotions - Updated -->
    <section class="promotions-section">
      <h2 class="section-title">বিশেষ অফার সমূহ</h2>
      <div class="promotions-container">
        <?php foreach ($promotions as $index => $promo): ?>
        <div class="promotion-card" style="background: <?php echo $promo['gradient']; ?>">
          <div class="promotion-title"><?php echo $promo['title']; ?></div>
          <div class="promotion-desc"><?php echo $promo['desc']; ?></div>
          <button class="promotion-btn">অফার দেখুন</button>
        </div>
        <?php endforeach; ?>
      </div>
    </section>
    
    <!-- Footer -->
    <footer class="footer">
      <p>&copy; 2025 WorldBkash. সর্বস্বত্ব সংরক্ষিত।</p>
      <div class="footer-links">
        <a href="#" class="footer-link">গোপনীয়তা</a>
        <a href="#" class="footer-link">শর্তাবলী</a>
      </div>
    </footer>
  </div>
  
  <!-- Drawer Menu -->
  <div class="drawer-overlay" id="drawerOverlay"></div>
  <div class="drawer" id="drawer">
    <div class="drawer-header">
      <div class="drawer-title">মেনু</div>
      <button class="drawer-close" id="drawerClose"><i class="fas fa-times"></i></button>
    </div>
    
    <div class="drawer-user">
      <div class="drawer-avatar">
        <?php if (!empty($user['profile_image'])): ?>
          <img src="<?php echo htmlspecialchars($user['profile_image']); ?>" alt="Profile">
        <?php else: ?>
          <i class="fas fa-user"></i>
        <?php endif; ?>
      </div>
      <div class="drawer-user-info">
        <h3><?php echo $user['name']; ?></h3>
        <p>Balance: ৳<?php echo number_format($user['balance'], 2); ?></p>
      </div>
    </div>
    
    <div class="drawer-menu">
      <a href="profile.php" class="drawer-item">
        <i class="fas fa-user"></i>
        <span>প্রোফাইল</span>
      </a>
      <a href="history.php" class="drawer-item">
        <i class="fas fa-history"></i>
        <span>হিস্ট্রি</span>
      </a>
      <a href="helpline.php" class="drawer-item">
        <i class="fas fa-phone"></i>
        <span>হেল্পলাইন</span>
      </a>
      <div class="drawer-divider"></div>
      <a href="settings.php" class="drawer-item">
        <i class="fas fa-cog"></i>
        <span>সেটিংস</span>
      </a>
      <a href="about.php" class="drawer-item">
        <i class="fas fa-info-circle"></i>
        <span>আমাদের সম্পর্কে</span>
      </a>
      <div class="drawer-divider"></div>
      <a href="logout.php" class="drawer-item">
        <i class="fas fa-sign-out-alt"></i>
        <span>লগ আউট</span>
      </a>
    </div>
    
    <div class="drawer-footer">
      <p>Version 1.0.0</p>
    </div>
  </div>
  
  <!-- Bottom Navigation - Updated from recharge.php -->
  <div class="bottom-nav">
    <div class="nav-list">
      <a href="/" class="nav-item active">
        <i class="fas fa-home nav-icon"></i>
        <div class="nav-label">হোম</div>
      </a>
      <a href="history.php" class="nav-item">
        <i class="fas fa-history nav-icon"></i>
        <div class="nav-label">ইতিহাস</div>
      </a>
      <a href="coin.php" class="nav-item">
        <i class="fas fa-qrcode nav-icon"></i>
        <div class="nav-label">স্ক্যান</div>
      </a>
      <a href="coin.php" class="nav-item">
        <img src="img/tt.png" alt="Rewards" style="width: 16px; height: 14px; margin-bottom: 1px;">
        <div class="nav-label">রিওয়ার্ড</div>
      </a>
      <a href="profile.php" class="nav-item">
        <i class="fas fa-user nav-icon"></i>
        <div class="nav-label">প্রোফাইল</div>
      </a>
    </div>
  </div>
  
  <!-- Popup Notice - Updated -->
  <div class="popup-overlay" id="popupOverlay">
    <div class="popup-notice">
      <div class="popup-header">
        <div class="popup-icon"><i class="fas fa-bullhorn"></i></div>
        <h2 class="popup-title">আজকের নোটিশ</h2>
      </div>
      <div class="popup-content">
        <?php echo nl2br(htmlspecialchars($notice)); ?>
      </div>
      <button class="popup-close" id="closePopup">বন্ধ করুন</button>
    </div>
  </div>
  
  <script>
    // Drawer functionality
    const menuBtn = document.getElementById('menuBtn');
    const drawer = document.getElementById('drawer');
    const drawerOverlay = document.getElementById('drawerOverlay');
    const drawerClose = document.getElementById('drawerClose');
    
    function openDrawer() {
      drawer.classList.add('active');
      drawerOverlay.classList.add('active');
      document.body.style.overflow = 'hidden';
    }
    
    function closeDrawer() {
      drawer.classList.remove('active');
      drawerOverlay.classList.remove('active');
      document.body.style.overflow = '';
    }
    
    menuBtn.addEventListener('click', openDrawer);
    drawerClose.addEventListener('click', closeDrawer);
    drawerOverlay.addEventListener('click', closeDrawer);
    
    // Popup functionality
    const popupOverlay = document.getElementById('popupOverlay');
    const closePopup = document.getElementById('closePopup');
    const notificationBtn = document.querySelector('.notification-btn');
    
    let showPopup = <?php echo $showPopup ? 'true' : 'false'; ?>;
    
    if (showPopup) {
      setTimeout(() => {
        popupOverlay.classList.add('show');
      }, 1000);
    }
    
    closePopup.addEventListener('click', () => {
      popupOverlay.classList.remove('show');
      fetch('', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'dismiss_popup=true'
      }).then(response => response.json())
        .then(data => console.log('Popup dismissed'));
    });
    
    notificationBtn.addEventListener('click', () => {
      popupOverlay.classList.add('show');
    });
    
    // Close popup when clicking outside
    popupOverlay.addEventListener('click', (e) => {
      if (e.target === popupOverlay) {
        popupOverlay.classList.remove('show');
      }
    });
    
    // Promotions auto-scroll
    const promotionsContainer = document.querySelector('.promotions-container');
    let scrollPosition = 0;
    const scrollAmount = 300;
    
    setInterval(() => {
      scrollPosition += scrollAmount;
      if (scrollPosition >= promotionsContainer.scrollWidth - promotionsContainer.clientWidth) {
        scrollPosition = 0;
      }
      promotionsContainer.scrollTo({
        left: scrollPosition,
        behavior: 'smooth'
      });
    }, 5000);
  </script>
</body>
</html>ipt>
</body>
</html>