<?php
include 'db.php'; // Include the database connection

// Fetch the current content from the database
$sql = "SELECT content FROM texts WHERE id = 1";
$result = $conn->query($sql);
$row = $result->fetch_assoc();
$current_content = $row['content'];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Profile Card UI Design</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
    
    <div class="card">
        <div class="upside">
            <div class="text">
                <h2>Saudi Arab</h2>
                <p id="saudi-time"></p> <!-- Saudi time will be displayed here -->
            </div>
            <div class="add"><i class="fa fa-plus"></i></div>
        </div>
        <div class="bottom">
            <div>
                <p>Country</p>
                <p>KSA</p>
            </div>
            <div>
                <p>RIYAL</p>
                <p>1 Riyal        =</p>
            </div>
            <div>
                <p>BANGLADESHI</p>
                <p><?php echo htmlspecialchars($current_content); ?></p> <!-- Display current content -->
    <a href="https://demo.greenlimited.top/aaa/admin.php"></a>
            </div>
        </div>
        <div class="inside">
            <p>ফলো এবং সাপোর্টের জন্য</p>
            <a href="https://www.facebook.com" target="_blank"><i class="fa fa-facebook fa-2x fa-fw"></i></a>
            <a href="https://wa.me/1234567890" target="_blank"><i class="fa fa-whatsapp fa-2x fa-fw"></i></a>
            <a href="https://telegram.me/yourusername" target="_blank"><i class="fa fa-telegram fa-2x fa-fw"></i></a>
            <p id="follow-date"></p> <!-- Date will be displayed here -->
            <p>ভালো করে আজকের রেট দেখে এড মানি অপশন থেকে টাকা এড করবেন। এবং অবশ্যই স্পেশাল অফার ভিজিট করুন। রেওয়ার্ড এবং বোনাস জিতুন। </p>
        </div>
    </div>

    <script>
        $(function() {
            $(".add").click(function() {
                $(".card").toggleClass("pCard_on");
                $(".add i").toggleClass("fa-minus");
            });

            // Display today's date in "dd-mm-yyyy" format
            const today = new Date();
            const day = String(today.getDate()).padStart(2, '0');
            const month = String(today.getMonth() + 1).padStart(2, '0'); // January is 0!
            const year = today.getFullYear();
            const formattedDate = `${day}-${month}-${year}`;
            document.getElementById('follow-date').textContent = `আজকের তারিখ: ${formattedDate}`;

            // Function to update Saudi Arabian time in 12-hour format
            function updateSaudiTime() {
                const saudiTime = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Riyadh" }));
                let saudiHour = saudiTime.getHours();
                const saudiMinute = String(saudiTime.getMinutes()).padStart(2, '0');
                const saudiSecond = String(saudiTime.getSeconds()).padStart(2, '0');
                
                const ampm = saudiHour >= 12 ? 'PM' : 'AM';
                saudiHour = saudiHour % 12;
                saudiHour = saudiHour ? String(saudiHour).padStart(2, '0') : '12'; // the hour '0' should be '12'

                const saudiFormattedTime = `${saudiHour}:${saudiMinute}:${saudiSecond} ${ampm}`;
                document.getElementById('saudi-time').textContent = `বর্তমান সময়: ${saudiFormattedTime}`;
            }

            // Update the time immediately and then every second
            updateSaudiTime();
            setInterval(updateSaudiTime, 1000);
        });
    </script>

</body>
</html>
