<?php
include 'db.php'; // Database connection file

// Check if the form has been submitted to update the content
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $content = $_POST['content'];

    $stmt = $conn->prepare("UPDATE currency_texts SET content = ? WHERE id = ?");
    $stmt->bind_param("si", $content, $id);

    if ($stmt->execute()) {
        $message = "Content updated successfully!";
    } else {
        $message = "Error updating content: " . $stmt->error;
    }
    $stmt->close();
}

// Fetch all records from the currency_texts table
$sql = "SELECT id, content FROM currency_texts";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

    <h1>Admin Panel</h1>
    <?php if (isset($message)) { echo "<p>$message</p>"; } ?>

    <table border="1">
        <tr>
            <th>ID</th>
            <th>Content</th>
            <th>Action</th>
        </tr>
        
        <?php while ($row = $result->fetch_assoc()) { ?>
        <tr>
            <td><?php echo $row['id']; ?></td>
            <td><?php echo htmlspecialchars($row['content']); ?></td>
            <td>
                <form action="admin.php" method="post">
                    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                    <textarea name="content" rows="3" cols="50"><?php echo htmlspecialchars($row['content']); ?></textarea>
                    <button type="submit" name="update">Update</button>
                </form>
            </td>
        </tr>
        <?php } ?>

    </table>

</body>
</html>

<?php
$conn->close();
?>
