<?php
include 'db.php'; // Include the database connection
// Fetch the current content from the database
$sql = "SELECT content FROM currency_texts WHERE id = 3"; // Kuwait এর জন্য ID পরিবর্তন করা হয়েছে
$result = $conn->query($sql);
$row = $result->fetch_assoc();
$current_content = $row['content'];
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuwait Rate</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .rate-card {
            width: 100%;
            max-width: 400px;
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        
        .rate-card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            position: relative;
            height: 180px;
            background-image: url('https://upload.wikimedia.org/wikipedia/commons/thumb/a/aa/Flag_of_Kuwait.svg/1280px-Flag_of_Kuwait.svg.png');
            background-size: cover;
            background-position: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            text-align: center;
            padding: 20px;
        }
        
        .card-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1;
        }
        
        .card-header > * {
            position: relative;
            z-index: 2;
        }
        
        .country-name {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 10px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }
        
        .current-time {
            font-size: 16px;
            font-weight: 500;
            background: rgba(255, 255, 255, 0.2);
            padding: 5px 15px;
            border-radius: 20px;
            backdrop-filter: blur(5px);
        }
        
        .card-body {
            padding: 30px 20px;
            text-align: center;
        }
        
        .currency-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .currency-left, .currency-right {
            text-align: left;
        }
        
        .currency-label {
            font-size: 14px;
            color: #6c757d;
            margin-bottom: 5px;
        }
        
        .currency-value {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }
        
        .exchange-rate {
            margin: 30px 0;
            position: relative;
        }
        
        .rate-title {
            font-size: 16px;
            color: #6c757d;
            margin-bottom: 15px;
        }
        
        .rate-value {
            font-size: 36px;
            font-weight: 700;
            color: #008080;
            margin-bottom: 10px;
        }
        
        .rate-update {
            font-size: 14px;
            color: #6c757d;
        }
        
        .divider {
            height: 1px;
            background: #e9ecef;
            margin: 25px 0;
        }
        
        .action-buttons {
            display: flex;
            justify-content: space-between;
            gap: 15px;
        }
        
        .btn {
            flex: 1;
            padding: 12px;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: #008080;
            color: white;
        }
        
        .btn-primary:hover {
            background: #006666;
        }
        
        .btn-outline {
            background: white;
            color: #008080;
            border: 1px solid #008080;
        }
        
        .btn-outline:hover {
            background: #f0f9ff;
        }
        
        .card-footer {
            background: #f8f9fa;
            padding: 15px 20px;
            text-align: center;
            font-size: 14px;
            color: #6c757d;
        }
        
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            gap: 10px;
            transform: translateX(120%);
            transition: transform 0.3s ease;
            z-index: 1000;
        }
        
        .notification.show {
            transform: translateX(0);
        }
        
        .notification.success {
            border-left: 4px solid #28a745;
        }
        
        .notification.error {
            border-left: 4px solid #dc3545;
        }
        
        .notification i {
            font-size: 18px;
        }
        
        .notification.success i {
            color: #28a745;
        }
        
        .notification.error i {
            color: #dc3545;
        }
        
        @media (max-width: 480px) {
            .rate-card {
                max-width: 100%;
            }
            
            .country-name {
                font-size: 28px;
            }
            
            .rate-value {
                font-size: 32px;
            }
        }
    </style>
</head>
<body>
    <div class="rate-card">
        <div class="card-header">
            <h1 class="country-name">Kuwait</h1>
            <div class="current-time" id="kuwait-time">Loading...</div>
        </div>
        
        <div class="card-body">
            <div class="currency-info">
                <div class="currency-left">
                    <div class="currency-label">From</div>
                    <div class="currency-value">1 KWD</div>
                </div>
                <div class="currency-right">
                    <div class="currency-label">To</div>
                    <div class="currency-value">Bangladeshi Taka</div>
                </div>
            </div>
            
            <div class="exchange-rate">
                <div class="rate-title">Current Exchange Rate</div>
                <div class="rate-value"><?php echo htmlspecialchars($current_content); ?></div>
                <div class="rate-update">Last updated: <span id="update-time">Just now</span></div>
            </div>
            
            <div class="divider"></div>
            
            <div class="action-buttons">
                <button class="btn btn-primary" id="refresh-btn">
                    <i class="fas fa-sync-alt"></i> Refresh
                </button>
                <button class="btn btn-outline" id="share-btn">
                    <i class="fas fa-share-alt"></i> Share
                </button>
            </div>
        </div>
        
        <div class="card-footer">
            Rates are for informational purposes only and may change without notice.
        </div>
    </div>
    
    <div class="notification" id="notification">
        <i class="fas fa-check-circle"></i>
        <span id="notification-text">Rate updated successfully!</span>
    </div>
    
    <script>
        // Function to update Kuwait time
        function updateKuwaitTime() {
            const kuwaitTime = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Kuwait" }));
            let kuwaitHour = kuwaitTime.getHours();
            const kuwaitMinute = String(kuwaitTime.getMinutes()).padStart(2, '0');
            const kuwaitSecond = String(kuwaitTime.getSeconds()).padStart(2, '0');
            
            const ampm = kuwaitHour >= 12 ? 'PM' : 'AM';
            kuwaitHour = kuwaitHour % 12;
            kuwaitHour = kuwaitHour ? String(kuwaitHour).padStart(2, '0') : '12';
            
            document.getElementById('kuwait-time').textContent = `${kuwaitHour}:${kuwaitMinute}:${kuwaitSecond} ${ampm}`;
        }
        
        // Update time immediately and then every second
        updateKuwaitTime();
        setInterval(updateKuwaitTime, 1000);
        
        // Function to show notification
        function showNotification(message, type = 'success') {
            const notification = document.getElementById('notification');
            const notificationText = document.getElementById('notification-text');
            const icon = notification.querySelector('i');
            
            notificationText.textContent = message;
            notification.className = 'notification show ' + type;
            
            if (type === 'success') {
                icon.className = 'fas fa-check-circle';
            } else if (type === 'error') {
                icon.className = 'fas fa-exclamation-circle';
            }
            
            setTimeout(() => {
                notification.classList.remove('show');
            }, 3000);
        }
        
        // Refresh button functionality
        document.getElementById('refresh-btn').addEventListener('click', function() {
            const icon = this.querySelector('i');
            icon.classList.add('fa-spin');
            
            // Simulate API call
            setTimeout(() => {
                icon.classList.remove('fa-spin');
                document.getElementById('update-time').textContent = 'Just now';
                showNotification('Rate updated successfully!');
            }, 1500);
        });
        
        // Share button functionality
        document.getElementById('share-btn').addEventListener('click', function() {
            if (navigator.share) {
                navigator.share({
                    title: 'Kuwait Exchange Rate',
                    text: `1 KWD = <?php echo htmlspecialchars($current_content); ?> BDT`,
                    url: window.location.href
                })
                .then(() => showNotification('Shared successfully!'))
                .catch(() => showNotification('Sharing cancelled', 'error'));
            } else {
                // Fallback for browsers that don't support Web Share API
                const url = window.location.href;
                navigator.clipboard.writeText(url)
                    .then(() => showNotification('Link copied to clipboard!'))
                    .catch(() => showNotification('Failed to copy link', 'error'));
            }
        });
    </script>
</body>
</html>