<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ডিপোজিট প্যাকেজ - World Bkash</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --primary: #008080; /* Changed from pink to teal */
            --primary-light: #e0fffe; /* Light teal background */
            --primary-dark: #004d40; /* Dark teal for hover states */
            --dark: #333333;
            --gray: #666666;
            --light-gray: #f5fafa; /* Very light teal gray */
            --border: #b2dfdb; /* Light teal border */
            --success: #2ecc71;
            --warning: #f39c12;
            --danger: #e74c3c;
            --blue: #3498db;
            --transition: all 0.3s ease;
            --shadow: 0 5px 15px rgba(0,0,0,0.08);
        }
        
        body {
            background: var(--light-gray);
            color: var(--dark);
            font-size: 14px;
            line-height: 1.6;
            min-height: 100vh;
        }
        
        .app-container {
            max-width: 480px;
            margin: 0 auto;
            min-height: 100vh;
            background: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
            padding-bottom: 30px;
        }
        
        /* Header Styles */
        .app-header {
            background: white;
            padding: 15px;
            color: var(--dark);
            position: relative;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .back-btn {
            background: var(--primary-light);
            border: none;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            cursor: pointer;
            transition: var(--transition);
        }
        
        .back-btn:hover {
            background: var(--primary);
            color: white;
            transform: scale(1.05);
        }
        
        .header-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
        }
        
        .balance-badge {
            background: var(--primary-light);
            border-radius: 20px;
            padding: 6px 12px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 5px;
            color: var(--primary);
        }
        
        /* Content Section */
        .content {
            padding: 20px;
        }
        
        .intro-section {
            background: linear-gradient(135deg, var(--primary), #006666); /* Darker teal gradient */
            border-radius: 15px;
            padding: 25px;
            color: white;
            text-align: center;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        
        .intro-section::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .intro-section::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .intro-section h2 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            position: relative;
            z-index: 1;
        }
        
        .intro-section p {
            font-size: 15px;
            margin-bottom: 10px;
            position: relative;
            z-index: 1;
        }
        
        .bonus-highlight {
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            padding: 5px 15px;
            border-radius: 30px;
            font-weight: 600;
            margin-top: 10px;
            font-size: 16px;
        }
        
        /* Package Cards */
        .packages-container {
            margin-bottom: 30px;
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .section-title i {
            color: var(--primary);
        }
        
        .package-card {
            background: white;
            border-radius: 12px;
            padding: 18px;
            margin-bottom: 15px;
            box-shadow: var(--shadow);
            border-left: 4px solid var(--primary);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }
        
        .package-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.15); /* Teal shadow */
        }
        
        .package-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 80px;
            height: 80px;
            background: var(--primary-light);
            border-radius: 0 0 0 80px;
            opacity: 0.5;
        }
        
        .package-amount {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 5px;
        }
        
        .package-bonus {
            font-size: 16px;
            font-weight: 600;
            color: var(--success);
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .package-bonus i {
            font-size: 14px;
        }
        
        .package-details {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .bonus-tag {
            background: var(--success);
            color: white;
            font-size: 12px;
            padding: 3px 8px;
            border-radius: 4px;
            font-weight: 500;
        }
        
        /* Info Section */
        .info-section {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: var(--shadow);
        }
        
        .info-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 10px;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .info-title i {
            color: var(--primary);
        }
        
        .info-content {
            font-size: 14px;
            color: var(--gray);
            line-height: 1.6;
        }
        
        /* Contact Section */
        .contact-section {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: var(--shadow);
        }
        
        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px dashed var(--border);
        }
        
        .contact-item:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }
        
        .contact-icon {
            width: 40px;
            height: 40px;
            background: var(--primary-light);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: var(--primary);
        }
        
        .contact-info {
            flex-grow: 1;
        }
        
        .contact-label {
            font-size: 13px;
            color: var(--gray);
            margin-bottom: 2px;
        }
        
        .contact-value {
            font-size: 15px;
            font-weight: 600;
            color: var(--dark);
        }
        
        .contact-action {
            color: var(--primary);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .contact-action:hover {
            text-decoration: underline;
        }
        
        /* Responsive */
        @media (max-width: 480px) {
            .content {
                padding: 15px;
            }
            
            .intro-section {
                padding: 20px;
            }
            
            .intro-section h2 {
                font-size: 20px;
            }
            
            .package-card {
                padding: 15px;
            }
            
            .package-amount {
                font-size: 16px;
            }
            
            .package-bonus {
                font-size: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="app-container">
        <!-- Header Section -->
        <div class="app-header">
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i>
            </button>
            <h1 class="header-title">ডিপোজিট প্যাকেজ</h1>
            <div class="balance-badge">
                <i class="fas fa-wallet"></i>
                World Bkash
            </div>
        </div>
        
        <!-- Content Section -->
        <div class="content">
            <!-- Intro Section -->
            <div class="intro-section">
                <h2>বিশেষ ডিপোজিট অফার</h2>
                <p>প্যাকেজ আকারে ডিপোজিট করলে আলাদা রেমিট্যান্স বোনাস পাবেন</p>
                <div class="bonus-highlight">
                    <i class="fas fa-percentage"></i> ৫% সরকারি প্রনোদনা সহ
                </div>
            </div>
            
            <!-- Packages Section -->
            <div class="packages-container">
                <h3 class="section-title">
                    <i class="fas fa-gift"></i>
                    চলমান প্যাকেজ সমূহ
                </h3>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">৩০,০০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ৩,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১৩.৩%</div>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">৫০,০০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ৫,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১২%</div>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">৬২,৯০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ৭,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১২.৭%</div>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">৮৬,৯০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ৮,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১০.৩%</div>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">১,০০,০০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ১০,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১১%</div>
                    </div>
                </div>
                
                <div class="package-card">
                    <div class="package-details">
                        <div>
                            <div class="package-amount">১,১০,৯০০ টাকা ডিপোজিট</div>
                            <div class="package-bonus">
                                <i class="fas fa-coins"></i> বোনাস: ১৭,৯৯০ টাকা
                            </div>
                        </div>
                        <div class="bonus-tag">১৬.২%</div>
                    </div>
                </div>
            </div>
            
            <!-- Info Section -->
            <div class="info-section">
                <h3 class="info-title">
                    <i class="fas fa-info-circle"></i>
                    ব্যালেন্স যোগ করার নিয়ম
                </h3>
                <p class="info-content">
                    কোম্পানি থেকে নিজ অ্যাকাউন্টে ব্যালেন্স/ টাকা অ্যাড করতে হলে আপনাকে অবশ্যই এজেন্টের সাথে যোগাযোগ করতে হবে। এজেন্ট আপনাকে পুরো প্রক্রিয়াটি বিস্তারিত জানাবেন।
                </p>
            </div>
            
            <!-- Contact Section -->
            <div class="contact-section">
                <h3 class="info-title">
                    <i class="fas fa-headset"></i>
                    যোগাযোগ তথ্য
                </h3>
                
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-phone-alt"></i>
                    </div>
                    <div class="contact-info">
                        <div class="contact-label">হেল্পলাইন</div>
                        <div class="contact-value">+৮৮০১৭৯৬০০৩০৭৬</div>
                    </div>
                    <div class="contact-action">কল করুন</div>
                </div>
                
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <div class="contact-info">
                        <div class="contact-label">ওয়েবসাইট</div>
                        <div class="contact-value">World Bkash</div>
                    </div>
                    <div class="contact-action">ভিজিট করুন</div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Add interactive functionality
        document.querySelectorAll('.package-card').forEach(card => {
            card.addEventListener('click', function() {
                // Simple animation on click
                this.style.transform = 'scale(0.98)';
                setTimeout(() => {
                    this.style.transform = '';
                }, 200);
            });
        });
        
        document.querySelectorAll('.contact-action').forEach(action => {
            action.addEventListener('click', function(e) {
                e.stopPropagation();
                const actionText = this.textContent;
                
                if(actionText.includes('কল')) {
                    // In a real app, this would initiate a call
                    alert('কল করা হচ্ছে: +৮৮০১৭৯৬০০৩০৭৬');
                } else if(actionText.includes('ভিজিট')) {
                    // In a real app, this would open the website
                    alert('ওয়েবসাইটে যাচ্ছেন: World Bkash');
                }
            });
        });
    </script>
</body>
</html>