<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('db.php'); // Your database connection
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id']; // Current logged-in user
$billId = isset($_GET['id']) ? $_GET['id'] : null;
$balanceError = '';
$pinError = '';
$successMessage = '';
// Fetch bill details
if ($billId) {
    $billQuery = $conn->prepare("SELECT name, description FROM paybills WHERE id = ?");
    $billQuery->bind_param("i", $billId);
    $billQuery->execute();
    $billResult = $billQuery->get_result();
    $bill = $billResult->fetch_assoc();
    
    if (!$bill) {
        echo "Bill not found!";
        exit;
    }
} else {
    echo "Invalid Bill!";
    exit;
}
// Fetch user balance and pin
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];
// Fetch the notice from the settings table
$settingsQuery = "SELECT bill_notice FROM settings WHERE id = 1";
$settingsResult = $conn->query($settingsQuery);
$settingsData = $settingsResult->fetch_assoc();
$notice = $settingsData['bill_notice'];
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accountName = $_POST['account_name'];
    $billerNumber = $_POST['biller_number'];
    $amount = $_POST['amount'];
    $reference = $_POST['reference'];
    $enteredPin = $_POST['pin'];
    // Verify the entered PIN
    if ($enteredPin !== $userPin) {
        $pinError = "Invalid PIN!";
    } elseif ($amount > $userBalance) {
        // Check if the user has enough balance
        $balanceError = "Insufficient balance!";
    } else {
        // Deduct balance
        $newBalance = $userBalance - $amount;
        $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
        $updateBalanceQuery->bind_param("di", $newBalance, $userId);
        $updateBalanceQuery->execute();
        // Insert transaction
$insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, bill_name, account_holder_name, account_number, amount, reference, status, title, type) VALUES (?, ?, ?, ?, ?, ?, 'pending', 'PAY BILL', 'other')");
$insertTransactionQuery->bind_param("isssss", $userId, $bill['name'], $accountName, $billerNumber, $amount, $reference);
$insertTransactionQuery->execute();

function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );
    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );
    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }
    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }
    $fields = json_encode($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Pay Bill)";
$response = sendOneSignalNotificationToAll($title, $message);
        // Set success message and redirect
        $successMessage = "Payment Successful!";
        echo "<script>
                setTimeout(function(){
                    window.location.href = 'dashboard.php';
                }, 2000);
              </script>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pay Bill</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #008080;
            --secondary-color: #4dbdbd;
            --accent-color: #FFD700;
            --light-bg: #f5fafa;
            --card-bg: #ffffff;
            --text-primary: #004d40;
            --text-secondary: #00695c;
            --text-light: #ffffff;
            --shadow: 0 10px 25px rgba(0, 128, 128, 0.15);
            --shadow-hover: 0 15px 35px rgba(0, 128, 128, 0.25);
            --transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            --radius: 16px;
            --success: #2ecc71;
            --danger: #e74c3c;
            --warning: #f39c12;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            padding-bottom: 80px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: var(--text-light);
            padding: 20px 25px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
            background: rgba(255, 255, 255, 0.15);
            width: 45px;
            height: 45px;
            border-radius: 50%;
            justify-content: center;
        }
        
        .back-icon:hover {
            transform: translateX(-5px);
            background: rgba(255, 255, 255, 0.25);
        }
        
        .back-icon i {
            font-size: 20px;
        }
        
        .header h3 {
            font-size: 22px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
        }
        
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 10px 18px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 16px;
            backdrop-filter: blur(5px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .balance i {
            margin-right: 8px;
            color: var(--accent-color);
            font-size: 18px;
        }
        
        .main-container {
            max-width: 600px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        /* Notice Container */
        .notice-container {
            position: relative;
            background: linear-gradient(135deg, #fff8e1, #ffecb3);
            padding: 20px;
            border-radius: var(--radius);
            margin-bottom: 25px;
            box-shadow: 0 5px 15px rgba(243, 156, 18, 0.2);
            border-left: 5px solid var(--warning);
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: slideIn 0.5s ease forwards;
        }
        
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .notice-container p {
            color: #5d4037;
            margin: 0;
            font-weight: 500;
            font-size: 15px;
            display: flex;
            align-items: flex-start;
        }
        
        .notice-container p i {
            margin-right: 10px;
            color: var(--warning);
            font-size: 18px;
            flex-shrink: 0;
        }
        
        .close-icon {
            cursor: pointer;
            font-size: 20px;
            color: #5d4037;
            transition: var(--transition);
            flex-shrink: 0;
        }
        
        .close-icon:hover {
            color: var(--danger);
            transform: rotate(90deg);
        }
        
        /* Bill Details Container */
        .bill-details-container {
            background: var(--card-bg);
            padding: 25px;
            border-radius: var(--radius);
            margin-bottom: 25px;
            text-align: center;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        
        .bill-details-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .bill-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--light-bg), #e0f2f1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.2);
        }
        
        .bill-icon i {
            font-size: 32px;
            color: var(--primary-color);
        }
        
        .bill-name {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--primary-color);
        }
        
        .bill-type {
            font-size: 16px;
            color: var(--text-secondary);
            padding: 8px 20px;
            background: var(--light-bg);
            border-radius: 30px;
            display: inline-block;
        }
        
        /* Form Container */
        .form-container {
            background: var(--card-bg);
            padding: 30px;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            margin-bottom: 25px;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--text-primary);
            font-size: 15px;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e0f2f1;
            border-radius: var(--radius);
            font-size: 16px;
            transition: var(--transition);
            background-color: var(--light-bg);
            font-weight: 500;
        }
        
        .form-group input:focus {
            border-color: var(--primary-color);
            background-color: var(--card-bg);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 128, 128, 0.1);
        }
        
        .form-group input::placeholder {
            color: #b2dfdb;
        }
        
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 15px;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            margin-top: 10px;
            transition: var(--transition);
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .submit-btn i {
            margin-left: 10px;
        }
        
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.4);
        }
        
        .submit-btn:active {
            transform: translateY(1px);
        }
        
        /* Popup for PIN verification */
        .popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .popup-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        
        .popup {
            background: var(--card-bg);
            padding: 30px;
            border-radius: var(--radius);
            width: 90%;
            max-width: 400px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            transform: scale(0.8);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .popup-overlay.active .popup {
            transform: scale(1);
        }
        
        .popup::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .popup h4 {
            margin: 0 0 20px;
            text-align: center;
            font-size: 22px;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .popup .form-group {
            margin-bottom: 25px;
        }
        
        .popup .form-group input {
            text-align: center;
            font-size: 20px;
            letter-spacing: 5px;
            padding: 15px 20px;
        }
        
        .popup-buttons {
            display: flex;
            gap: 15px;
        }
        
        .verify-btn, .close-btn {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .verify-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.3);
        }
        
        .verify-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.4);
        }
        
        .close-btn {
            background: #f5f5f5;
            color: var(--text-secondary);
        }
        
        .close-btn:hover {
            background: #e0e0e0;
        }
        
        /* Toast Notification */
        .toast {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%) translateY(-100px);
            background: white;
            color: var(--text-primary);
            padding: 15px 25px;
            border-radius: var(--radius);
            box-shadow: var(--shadow-hover);
            z-index: 2000;
            display: flex;
            align-items: center;
            opacity: 0;
            transition: all 0.4s ease;
            min-width: 300px;
            max-width: 90%;
        }
        
        .toast.show {
            transform: translateX(-50%) translateY(0);
            opacity: 1;
        }
        
        .toast i {
            font-size: 24px;
            margin-right: 15px;
        }
        
        .toast.success {
            border-left: 5px solid var(--success);
        }
        
        .toast.success i {
            color: var(--success);
        }
        
        .toast.error {
            border-left: 5px solid var(--danger);
        }
        
        .toast.error i {
            color: var(--danger);
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -5px 15px rgba(0, 0, 0, 0.1);
            z-index: 100;
            border-top: 1px solid rgba(0, 128, 128, 0.1);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 12px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--text-secondary);
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 12px;
            min-width: 60px;
        }
        
        .nav-item.active {
            color: var(--primary-color);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 20px;
            margin-bottom: 4px;
        }
        
        .nav-label {
            font-size: 11px;
            font-weight: 500;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .header {
                padding: 15px 20px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 14px;
                padding: 8px 15px;
            }
            
            .main-container {
                margin: 20px auto;
                padding: 0 15px;
            }
            
            .form-container {
                padding: 20px;
            }
            
            .bill-details-container {
                padding: 20px;
            }
            
            .bill-name {
                font-size: 20px;
            }
            
            .popup {
                padding: 25px 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>Pay Bill</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>
    
    <!-- Main Container -->
    <div class="main-container">
        <!-- Notice Container -->
        <div class="notice-container" id="noticeContainer">
            <p><i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($notice); ?></p>
            <span class="close-icon" onclick="closeNotice()">×</span>
        </div>
        
        <!-- Bill Details Container -->
        <div class="bill-details-container">
            <div class="bill-icon">
                <i class="fas fa-file-invoice-dollar"></i>
            </div>
            <div class="bill-name"><?php echo htmlspecialchars($bill['name']); ?></div>
            <div class="bill-type"><?php echo htmlspecialchars($bill['description']); ?></div>
        </div>
        
        <!-- Form Container -->
        <div class="form-container">
            <form method="POST" id="paymentForm">
                <div class="form-group">
                    <label for="account_name">Account Name</label>
                    <input type="text" name="account_name" id="account_name" placeholder="Enter account name" required>
                </div>
                
                <div class="form-group">
                    <label for="biller_number">Biller Number</label>
                    <input type="text" name="biller_number" id="biller_number" placeholder="Enter biller number" required>
                </div>
                
                <div class="form-group">
                    <label for="amount">Amount (৳)</label>
                    <input type="number" name="amount" id="amount" placeholder="Enter amount" required>
                </div>
                
                <div class="form-group">
                    <label for="reference">Reference (Optional)</label>
                    <input type="text" name="reference" id="reference" placeholder="Enter reference number">
                </div>
                
                <button type="button" class="submit-btn" onclick="showPopup()">
                    Continue to Payment <i class="fas fa-arrow-right"></i>
                </button>
                
                <!-- Pop-up for PIN verification -->
                <div class="popup-overlay" id="popupOverlay">
                    <div class="popup">
                        <h4>Enter PIN</h4>
                        <div class="form-group">
                            <input type="password" name="pin" id="pin" placeholder="••••" maxlength="4" required>
                        </div>
                        <div class="popup-buttons">
                            <button type="submit" class="verify-btn">Verify & Pay</button>
                            <button type="button" class="close-btn" onclick="closePopup()">Cancel</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Toast Notification -->
    <div id="toast" class="toast <?php echo $pinError || $balanceError ? 'error' : 'success'; ?>">
        <i class="fas <?php echo $pinError || $balanceError ? 'fa-exclamation-circle' : 'fa-check-circle'; ?>"></i>
        <span><?php echo $pinError ? $pinError : ($balanceError ? $balanceError : $successMessage); ?></span>
    </div>
    
    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <div class="nav-list">
            <a href="/" class="nav-item">
                <i class="fas fa-home nav-icon"></i>
                <div class="nav-label">Home</div>
            </a>
            <a href="history.php" class="nav-item">
                <i class="fas fa-history nav-icon"></i>
                <div class="nav-label">History</div>
            </a>
            <a href="coin.php" class="nav-item">
                <i class="fas fa-qrcode nav-icon"></i>
                <div class="nav-label">Scan</div>
            </a>
            <a href="coin.php" class="nav-item">
                <img src="img/tt.png" alt="Rewards" style="width: 16px; height: 14px; margin-bottom: 1px;">
                <div class="nav-label">Rewards</div>
            </a>
            <a href="profile.php" class="nav-item">
                <i class="fas fa-user nav-icon"></i>
                <div class="nav-label">Profile</div>
            </a>
        </div>
    </div>
    
    <script>
        function closeNotice() {
            const noticeContainer = document.getElementById('noticeContainer');
            noticeContainer.style.transform = 'translateX(120%)';
            noticeContainer.style.opacity = '0';
            setTimeout(() => {
                noticeContainer.style.display = 'none';
            }, 300);
        }
        
        function showPopup() {
            const accountName = document.getElementById('account_name').value;
            const billerNumber = document.getElementById('biller_number').value;
            const amount = document.getElementById('amount').value;
            
            if (!accountName || !billerNumber || !amount) {
                showToast('Please fill in all required fields', 'error');
                return;
            }
            
            const popupOverlay = document.getElementById('popupOverlay');
            popupOverlay.classList.add('active');
            document.getElementById('pin').focus();
        }
        
        function closePopup() {
            const popupOverlay = document.getElementById('popupOverlay');
            popupOverlay.classList.remove('active');
        }
        
        function showToast(message, type = 'success') {
            const toast = document.getElementById('toast');
            toast.className = 'toast ' + type;
            toast.querySelector('span').textContent = message;
            toast.querySelector('i').className = 'fas ' + (type === 'error' ? 'fa-exclamation-circle' : 'fa-check-circle');
            
            setTimeout(() => {
                toast.classList.add('show');
            }, 100);
            
            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }
        
        <?php if ($successMessage || $pinError || $balanceError) : ?>
            showToast('<?php echo $pinError ? $pinError : ($balanceError ? $balanceError : $successMessage); ?>', '<?php echo $pinError || $balanceError ? "error" : "success"; ?>');
        <?php endif; ?>
        
        // Close popup when clicking outside
        document.getElementById('popupOverlay').addEventListener('click', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });
        
        // Format amount input
        document.getElementById('amount').addEventListener('input', function(e) {
            let value = e.target.value;
            if (value < 0) {
                e.target.value = 0;
            }
        });
    </script>
</body>
</html>