<?php
session_start();
include('db.php');
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
// Get bank ID from the URL (using GET method)
if (isset($_GET['bank_id'])) {
    $bankId = $_GET['bank_id'];
} else {
    // If no bank_id is provided, redirect or set a default bank ID
    $bankId = 1; // Default to bank id 1, or handle this case as needed
}
$userId = $_SESSION['user_id'];
$pinError = '';
$successMessage = '';
$showErrorToast = false;  // Flag to determine if error toast should be shown
// Fetch user data including balance and PIN
$userQuery = $conn->prepare("SELECT balance, pin FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userBalance = $userData['balance'];
$userPin = $userData['pin'];
// Fetch the notice from the settings table
$settingsQuery = "SELECT notice FROM settings WHERE id = 1";
$settingsResult = $conn->query($settingsQuery);
$settingsData = $settingsResult->fetch_assoc();
$notice = $settingsData['notice'];
// Fetch bank details for the bank with the passed id
$bankQuery = $conn->prepare("SELECT name, branch FROM banks WHERE id = ?");
$bankQuery->bind_param("i", $bankId);
$bankQuery->execute();
$bankResult = $bankQuery->get_result();
$bankData = $bankResult->fetch_assoc();
$bankName = $bankData['name'];
$branchName = $bankData['branch'];
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accountHolderName = $_POST['account_holder_name'];
    $accountNumber = $_POST['account_number'];
    $amount = $_POST['amount'];
    $reference = $_POST['reference'];
    $inputPin = $_POST['pin'];
    // Check if PIN is correct
    if ($inputPin === $userPin) {
        // Check if the user has enough balance
        if ($amount > $userBalance) {
            $pinError = "পর্যাপ্ত ব্যালেন্স নেই!";
            $showErrorToast = true;
        } else {
            // Transfer is valid, deduct from sender and insert transaction
            $newBalance = $userBalance - $amount;
            // Update sender's balance
            $updateBalanceQuery = $conn->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $updateBalanceQuery->bind_param("di", $newBalance, $userId);
            $updateBalanceQuery->execute();
            // Insert transaction into the transaction history
            $insertTransactionQuery = $conn->prepare("INSERT INTO transactions (user_id, bank_name, branch_name, account_holder_name, account_number, amount, reference, title, type) VALUES (?, ?, ?, ?, ?, ?, ?, 'BANKING TRANSFER', 'mbank')");
            $insertTransactionQuery->bind_param("issssds", $userId, $bankName, $branchName, $accountHolderName, $accountNumber, $amount, $reference);
            $insertTransactionQuery->execute();
            
            function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
    $content = array(
        "en" => $message
    );
    $fields = array(
        'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
        'included_segments' => array('All'), // Send to all users
        'headings' => array("en" => $title),
        'contents' => $content
    );
    // Add optional URL
    if ($url) {
        $fields['url'] = $url;
    }
    // Add optional Image URL
    if ($imageUrl) {
        $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
    }
    $fields = json_encode($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
// Example call for admin notification to all users
$title = "Admin Notification";
$message = "New transaction (Banking)";
$response = sendOneSignalNotificationToAll($title, $message);
            $successMessage = "পেমেন্ট সফল হয়েছে!";
        }
    } else {
        $pinError = "ভুল PIN!";
        $showErrorToast = true;
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ব্যাংক ট্রান্সফার</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #00897b;
            --primary-light: #b2dfdb;
            --secondary-color: #4db6ac;
            --accent-color: #4db6ac;
            --light-bg: #f5f9f8;
            --card-bg: #ffffff;
            --text-primary: #00695c;
            --text-secondary: #00897b;
            --text-light: #ffffff;
            --shadow: 0 4px 15px rgba(0, 137, 123, 0.08);
            --shadow-hover: 0 8px 25px rgba(0, 137, 123, 0.12);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --radius: 20px;
            --success: #2ecc71;
            --danger: #e74c3c;
            --warning: #f39c12;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Noto Sans Bengali', 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            padding-bottom: 80px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: var(--text-light);
            padding: 18px 22px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
            background: rgba(255, 255, 255, 0.15);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            justify-content: center;
        }
        
        .back-icon:hover {
            transform: translateX(-3px);
            background: rgba(255, 255, 255, 0.25);
        }
        
        .back-icon i {
            font-size: 18px;
        }
        
        .header h3 {
            font-size: 20px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 15px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        
        .balance i {
            margin-right: 6px;
            color: var(--accent-color);
            font-size: 16px;
        }
        
        .main-container {
            max-width: 600px;
            margin: 25px auto;
            padding: 0 15px;
        }
        
        /* Notice Container */
        .notice-container {
            position: relative;
            background: linear-gradient(135deg, #fff8e1, #ffecb3);
            padding: 20px;
            border-radius: var(--radius);
            margin-bottom: 25px;
            box-shadow: 0 5px 15px rgba(243, 156, 18, 0.2);
            border-left: 5px solid var(--warning);
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: slideIn 0.5s ease forwards;
        }
        
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .notice-container p {
            color: #5d4037;
            margin: 0;
            font-weight: 500;
            font-size: 15px;
            display: flex;
            align-items: flex-start;
        }
        
        .notice-container p i {
            margin-right: 10px;
            color: var(--warning);
            font-size: 18px;
            flex-shrink: 0;
        }
        
        .close-icon {
            cursor: pointer;
            font-size: 20px;
            color: #5d4037;
            transition: var(--transition);
            flex-shrink: 0;
        }
        
        .close-icon:hover {
            color: var(--danger);
            transform: rotate(90deg);
        }
        
        /* Bank Details Container */
        .bank-details-container {
            background: var(--card-bg);
            padding: 25px;
            border-radius: var(--radius);
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }
        
        .bank-details-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .bank-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--light-bg), #e0f2f1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.2);
        }
        
        .bank-icon i {
            font-size: 32px;
            color: var(--primary-color);
        }
        
        .bank-details {
            text-align: center;
        }
        
        .bank-name {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--primary-color);
        }
        
        .branch-name {
            font-size: 16px;
            color: var(--text-secondary);
            padding: 8px 20px;
            background: var(--light-bg);
            border-radius: 30px;
            display: inline-block;
        }
        
        /* Form Container */
        .form-container {
            background: var(--card-bg);
            padding: 30px;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            margin-bottom: 25px;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--text-primary);
            font-size: 15px;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e0f2f1;
            border-radius: var(--radius);
            font-size: 16px;
            transition: var(--transition);
            background-color: var(--light-bg);
            font-weight: 500;
        }
        
        .form-group input:focus {
            border-color: var(--primary-color);
            background-color: var(--card-bg);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 128, 128, 0.1);
        }
        
        .form-group input::placeholder {
            color: #b2dfdb;
        }
        
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 15px;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            margin-top: 10px;
            transition: var(--transition);
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .submit-btn i {
            margin-left: 10px;
        }
        
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.4);
        }
        
        .submit-btn:active {
            transform: translateY(1px);
        }
        
        /* Popup for PIN verification */
        .popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .popup-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        
        .popup {
            background: var(--card-bg);
            padding: 30px;
            border-radius: var(--radius);
            width: 90%;
            max-width: 400px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            transform: scale(0.8);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .popup-overlay.active .popup {
            transform: scale(1);
        }
        
        .popup::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .popup h4 {
            margin: 0 0 20px;
            text-align: center;
            font-size: 22px;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .popup .form-group {
            margin-bottom: 25px;
        }
        
        .popup .form-group input {
            text-align: center;
            font-size: 20px;
            letter-spacing: 5px;
            padding: 15px 20px;
        }
        
        .popup-buttons {
            display: flex;
            gap: 15px;
        }
        
        .verify-btn, .close-btn {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .verify-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            box-shadow: 0 5px 15px rgba(0, 128, 128, 0.3);
        }
        
        .verify-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 128, 128, 0.4);
        }
        
        .close-btn {
            background: #f5f5f5;
            color: var(--text-secondary);
        }
        
        .close-btn:hover {
            background: #e0e0e0;
        }
        
        /* Toast Notification */
        .toast {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%) translateY(-100px);
            background: white;
            color: var(--text-primary);
            padding: 15px 25px;
            border-radius: var(--radius);
            box-shadow: var(--shadow-hover);
            z-index: 2000;
            display: flex;
            align-items: center;
            opacity: 0;
            transition: all 0.4s ease;
            min-width: 300px;
            max-width: 90%;
        }
        
        .toast.show {
            transform: translateX(-50%) translateY(0);
            opacity: 1;
        }
        
        .toast i {
            font-size: 24px;
            margin-right: 15px;
        }
        
        .toast.success {
            border-left: 5px solid var(--success);
        }
        
        .toast.success i {
            color: var(--success);
        }
        
        .toast.error {
            border-left: 5px solid var(--danger);
        }
        
        .toast.error i {
            color: var(--danger);
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -3px 12px rgba(0, 0, 0, 0.06);
            z-index: 100;
            border-top: 1px solid rgba(0, 137, 123, 0.08);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--text-secondary);
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 12px;
            min-width: 60px;
        }
        
        .nav-item.active {
            color: var(--primary-color);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 24px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 3px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .header {
                padding: 14px 18px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 13px;
                padding: 6px 12px;
            }
            
            .main-container {
                margin: 20px auto;
                padding: 0 15px;
            }
            
            .form-container {
                padding: 20px;
            }
            
            .bank-details-container {
                padding: 20px;
            }
            
            .popup {
                padding: 25px 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>ব্যাংক ট্রান্সফার</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($userBalance, 2); ?>
        </div>
    </div>
    
    <!-- Main Container -->
    <div class="main-container">
        <!-- Notice Container -->
        <div class="notice-container" id="noticeContainer">
            <p><i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($notice); ?></p>
            <span class="close-icon" onclick="closeNotice()">×</span>
        </div>
        
        <!-- Bank Details Container -->
        <div class="bank-details-container">
            <div class="bank-icon">
                <i class="fas fa-university"></i>
            </div>
            <div class="bank-details">
                <div class="bank-name"><?php echo htmlspecialchars($bankName); ?></div>
                <div class="branch-name"><?php echo htmlspecialchars($branchName); ?></div>
            </div>
        </div>
        
        <!-- Form Container -->
        <div class="form-container">
            <form id="transferForm" method="POST">
                <div class="form-group">
                    <label for="account_holder_name">অ্যাকাউন্ট হোল্ডারের নাম</label>
                    <input type="text" name="account_holder_name" id="account_holder_name" placeholder="অ্যাকাউন্ট হোল্ডারের নাম লিখুন" required>
                </div>
                
                <div class="form-group">
                    <label for="account_number">অ্যাকাউন্ট নাম্বার</label>
                    <input type="text" name="account_number" id="account_number" placeholder="অ্যাকাউন্ট নাম্বার লিখুন" required>
                </div>
                
                <div class="form-group">
                    <label for="amount">পরিমাণ (৳)</label>
                    <input type="number" name="amount" id="amount" placeholder="পরিমাণ লিখুন" required>
                </div>
                
                <div class="form-group">
                    <label for="reference">শাখার নাম</label>
                    <input type="text" name="reference" id="reference" placeholder="শাখার নাম লিখুন">
                </div>
                
                <input type="hidden" id="pinInput" name="pin">
                <button type="button" class="submit-btn" onclick="showPopup()">
                    সাবমিট করুন <i class="fas fa-arrow-right"></i>
                </button>
                
                <!-- Pop-up for PIN verification -->
                <div class="popup-overlay" id="popupOverlay">
                    <div class="popup">
                        <h4>PIN লিখুন</h4>
                        <div class="form-group">
                            <input type="password" id="pinEntry" placeholder="••••" maxlength="4" required>
                        </div>
                        <div class="popup-buttons">
                            <button type="button" class="verify-btn" onclick="submitForm()">যাচাই করুন</button>
                            <button type="button" class="close-btn" onclick="closePopup()">বন্ধ করুন</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Toast Notification -->
    <div id="toast" class="toast <?php echo $pinError ? 'error' : 'success'; ?>">
        <i class="fas <?php echo $pinError ? 'fa-exclamation-circle' : 'fa-check-circle'; ?>"></i>
        <span><?php echo $pinError ? $pinError : $successMessage; ?></span>
    </div>
    
    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <div class="nav-list">
            <a href="/" class="nav-item">
                <i class="fas fa-home nav-icon"></i>
                <div class="nav-label">হোম</div>
            </a>
            <a href="history.php" class="nav-item">
                <i class="fas fa-history nav-icon"></i>
                <div class="nav-label">ইতিহাস</div>
            </a>
            <a href="coin.php" class="nav-item">
                <i class="fas fa-qrcode nav-icon"></i>
                <div class="nav-label">স্ক্যান</div>
            </a>
            <a href="coin.php" class="nav-item">
                <img src="img/tt.png" alt="রিওয়ার্ড" style="width: 16px; height: 14px; margin-bottom: 1px;">
                <div class="nav-label">রিওয়ার্ড</div>
            </a>
            <a href="profile.php" class="nav-item">
                <i class="fas fa-user nav-icon"></i>
                <div class="nav-label">প্রোফাইল</div>
            </a>
        </div>
    </div>
    
    <script>
        function closeNotice() {
            const noticeContainer = document.getElementById('noticeContainer');
            noticeContainer.style.transform = 'translateX(120%)';
            noticeContainer.style.opacity = '0';
            setTimeout(() => {
                noticeContainer.style.display = 'none';
            }, 300);
        }
        
        function showPopup() {
            const accountHolderName = document.getElementById('account_holder_name').value;
            const accountNumber = document.getElementById('account_number').value;
            const amount = document.getElementById('amount').value;
            
            if (!accountHolderName || !accountNumber || !amount) {
                showToast('সব ফিল্ড পূরণ করুন', 'error');
                return;
            }
            
            const popupOverlay = document.getElementById('popupOverlay');
            popupOverlay.classList.add('active');
            document.getElementById('pinEntry').focus();
        }
        
        function closePopup() {
            const popupOverlay = document.getElementById('popupOverlay');
            popupOverlay.classList.remove('active');
        }
        
        function submitForm() {
            // Set the entered PIN value into the hidden input field
            const enteredPin = document.getElementById('pinEntry').value;
            document.getElementById('pinInput').value = enteredPin;
            // Submit the form
            document.getElementById('transferForm').submit();
        }
        
        function showToast(message, type = 'success') {
            const toast = document.getElementById('toast');
            toast.className = 'toast ' + type;
            toast.querySelector('span').textContent = message;
            toast.querySelector('i').className = 'fas ' + (type === 'error' ? 'fa-exclamation-circle' : 'fa-check-circle');
            
            setTimeout(() => {
                toast.classList.add('show');
            }, 100);
            
            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }
        
        <?php if ($successMessage || $pinError): ?>
            showToast('<?php echo $pinError ? $pinError : $successMessage; ?>', '<?php echo $pinError ? "error" : "success"; ?>');
            
            <?php if ($successMessage): ?>
                setTimeout(function() {
                    window.location.href = "dashboard.php";
                }, 2000);
            <?php endif; ?>
        <?php endif; ?>
        
        // Close popup when clicking outside
        document.getElementById('popupOverlay').addEventListener('click', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });
        
        // Format amount input
        document.getElementById('amount').addEventListener('input', function(e) {
            let value = e.target.value;
            if (value < 0) {
                e.target.value = 0;
            }
        });
    </script>
</body>
</html>