<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ডাটাবেস কানেকশন
if (!include('db.php')) {
    die("ডাটাবেস কানেকশন ফাইল পাওয়া যায়নি");
}

// সেশন চেক
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id'];

// ইউজার ডাটা ফেচ করা
try {
    $userQuery = $conn->prepare("SELECT balance FROM users WHERE id = ?");
    if (!$userQuery) {
        throw new Exception("ইউজার কোয়েরি প্রস্তুত করতে সমস্যা: " . $conn->error);
    }
    
    $userQuery->bind_param("i", $userId);
    if (!$userQuery->execute()) {
        throw new Exception("ইউজার কোয়েরি এক্সিকিউট করতে সমস্যা: " . $userQuery->error);
    }
    
    $userResult = $userQuery->get_result();
    $userData = $userResult->fetch_assoc();
    
    if (!$userData) {
        throw new Exception("ইউজার ডাটা পাওয়া যায়নি");
    }
} catch (Exception $e) {
    die("ইউজার ডাটা লোড করতে সমস্যা: " . $e->getMessage());
}

// পেমেন্ট মেথড ফেচ করা
try {
    $methodQuery = "SELECT * FROM payment_methods";
    $methodResult = $conn->query($methodQuery);
    
    if (!$methodResult) {
        throw new Exception("পেমেন্ট মেথড কোয়েরি এক্সিকিউট করতে সমস্যা: " . $conn->error);
    }
    
    if ($methodResult->num_rows == 0) {
        $noMethods = true;
    } else {
        $noMethods = false;
    }
} catch (Exception $e) {
    die("পেমেন্ট মেথড লোড করতে সমস্যা: " . $e->getMessage());
}

// ইমেজ পাথ সঠিক করার ফাংশন
function getImageUrl($path) {
    // যদি পূর্ণ URL হয় তাহলে সেটাই রিটার্ন করুন
    if (filter_var($path, FILTER_VALIDATE_URL)) {
        return $path;
    }
    
    // যদি পাথ শুরু হয় '/' দিয়ে, তাহলে রুট ডিরেক্টরি থেকে শুরু
    if (strpos($path, '/') === 0) {
        return $path;
    }
    
    // অন্যথায় বর্তমান ডিরেক্টরি থেকে শুরু
    return 'img/' . $path;
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট মেথড - World BKash</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #14b8a6;
            --primary-light: #ccfbf1;
            --primary-dark: #0d9488;
            --secondary-color: #0d9488;
            --accent-color: #FFD700;
            --light-bg: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212529;
            --text-secondary: #6c757d;
            --shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Hind Siliguri', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        body {
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiPjxkZWZzPjxwYXR0ZXJuIGlkPSJwYXR0ZXJuIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHBhdHRlcm5Vbml0cz0idXNlclNwYWNlT25Vc2UiIHBhdHRlcm5UcmFuc2Zvcm09InJvdGF0ZSg0NSkiPjxyZWN0IHg9IjAiIHk9IjAiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgZmlsbD0icmdiYSgyMCwgMTg0LCAxNjYsIDAuMDMpIi8+PC9wYXR0ZXJuPjwvZGVmcz48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSJ1cmwoI3BhdHRlcm4pIi8+PC9zdmc+');
            opacity: 0.5;
            z-index: -1;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 18px 20px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
            overflow: hidden;
        }
        
        .header::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 120px;
            height: 120px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .header::after {
            content: '';
            position: absolute;
            bottom: -30px;
            left: -30px;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            z-index: 1;
        }
        
        .back-icon:hover {
            transform: translateX(-5px);
        }
        
        .back-icon i {
            font-size: 20px;
            margin-right: 10px;
        }
        
        .header h3 {
            font-size: 22px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1;
        }
        
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 16px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            position: relative;
            z-index: 1;
        }
        
        .balance i {
            margin-right: 8px;
            color: var(--accent-color);
        }
        
        .container {
            max-width: 800px;
            margin: 25px auto;
            padding: 0 15px;
        }
        
        .page-title {
            text-align: center;
            margin: 30px 0 25px;
            color: var(--primary-color);
            position: relative;
            font-size: 24px;
            font-weight: 700;
        }
        
        .page-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            border-radius: 3px;
        }
        
        .payment-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }
        
        .payment-method {
            background: var(--card-bg);
            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
            text-decoration: none;
            color: inherit;
            display: flex;
            align-items: center;
            padding: 20px;
            border-left: 4px solid transparent;
            position: relative;
        }
        
        .payment-method::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 60px;
            height: 60px;
            background: var(--primary-light);
            border-radius: 0 0 0 60px;
            opacity: 0.5;
        }
        
        .payment-method:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 20px rgba(20, 184, 166, 0.15);
            border-left-color: var(--primary-color);
        }
        
        .payment-method img {
            width: 70px;
            height: 70px;
            object-fit: contain;
            border-radius: 12px;
            background-color: white;
            padding: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.08);
            transition: var(--transition);
        }
        
        .payment-method:hover img {
            transform: scale(1.05);
        }
        
        .payment-info {
            flex-grow: 1;
            padding-left: 20px;
        }
        
        .payment-name {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 5px;
            color: var(--primary-color);
        }
        
        .limit {
            color: var(--text-secondary);
            font-size: 14px;
            display: flex;
            align-items: center;
            margin-top: 5px;
        }
        
        .limit i {
            margin-right: 5px;
            color: var(--accent-color);
        }
        
        .arrow-icon {
            color: var(--text-secondary);
            transition: var(--transition);
            font-size: 18px;
        }
        
        .payment-method:hover .arrow-icon {
            color: var(--primary-color);
            transform: translateX(5px);
        }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-secondary);
            background: white;
            border-radius: 16px;
            box-shadow: var(--shadow);
            margin-top: 30px;
        }
        
        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            color: var(--primary-color);
        }
        
        .empty-state h3 {
            font-size: 22px;
            margin-bottom: 10px;
            color: var(--text-primary);
        }
        
        .error-message {
            background-color: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border: 1px solid #f5c6cb;
        }
        
        .debug-info {
            background-color: #e2e3e5;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            font-family: monospace;
            font-size: 14px;
        }
        
        /* ইমেজ কন্টেইনার স্টাইল */
        .img-container {
            position: relative;
            width: 70px;
            height: 70px;
            border-radius: 12px;
            background-color: white;
            padding: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.08);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        
        .img-container img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }
        
        .img-placeholder {
            font-size: 30px;
            color: var(--text-secondary);
        }
        
        /* Floating shapes */
        .shape {
            position: absolute;
            border-radius: 50%;
            background: var(--primary-light);
            opacity: 0.2;
            z-index: -1;
        }
        
        .shape-1 {
            width: 200px;
            height: 200px;
            top: -100px;
            right: -50px;
        }
        
        .shape-2 {
            width: 150px;
            height: 150px;
            bottom: 100px;
            left: -50px;
        }
        
        .shape-3 {
            width: 100px;
            height: 100px;
            top: 40%;
            right: 10%;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.1);
            z-index: 100;
            border-top: 1px solid #e0e0e0;
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 8px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--text-secondary);
            transition: var(--transition);
            padding: 5px;
            border-radius: 8px;
            min-width: 60px;
        }
        
        .nav-item.active {
            color: var(--primary-color);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 2px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .header {
                padding: 15px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 14px;
                padding: 6px 12px;
            }
            
            .payment-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .page-title {
                font-size: 20px;
            }
            
            .payment-method {
                padding: 15px;
            }
            
            .img-container {
                width: 60px;
                height: 60px;
            }
            
            .payment-name {
                font-size: 16px;
            }
            
            .shape-1 {
                width: 150px;
                height: 150px;
            }
            
            .shape-2 {
                width: 100px;
                height: 100px;
            }
            
            .shape-3 {
                width: 70px;
                height: 70px;
            }
        }
    </style>
</head>
<body>
    <!-- Floating shapes -->
    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>
    <div class="shape shape-3"></div>
    
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>পেমেন্ট মেথড</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo htmlspecialchars($userData['balance']); ?>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="container">
        <h2 class="page-title">পেমেন্ট মেথড নির্বাচন করুন</h2>
        
        <?php if (isset($noMethods) && $noMethods): ?>
            <div class="empty-state">
                <i class="fas fa-credit-card"></i>
                <h3>কোনো পেমেন্ট মেথড পাওয়া যায়নি</h3>
                <p>অনুগ্রহ করে পরে আবার চেক করুন অথবা সাপোর্টে যোগাযোগ করুন।</p>
            </div>
        <?php else: ?>
            <div class="payment-grid">
                <?php 
                // ডাটাবেস থেকে ডাটা আবার ফেচ করা হচ্ছে (পূর্ববর্তী ফেচ রিসেট হয়ে গেছে)
                $methodResult->data_seek(0);
                while ($row = $methodResult->fetch_assoc()): 
                    // ইমেজ URL প্রস্তুত করা
                    $imageUrl = getImageUrl($row['image_url']);
                    
                    // ডিবাগিং এর জন্য (শুধু ডেভেলপমেন্টে)
                    $debugMode = false;
                    if ($debugMode) {
                        echo "<!-- Debug: Image URL for {$row['name']}: $imageUrl -->";
                    }
                ?>
                    <a class="payment-method" href="add-process.php?method=<?php echo urlencode($row['name']); ?>">
                        <div class="img-container">
                            <?php if (!empty($row['image_url'])): ?>
                                <img src="<?php echo htmlspecialchars($imageUrl); ?>" 
                                     alt="<?php echo htmlspecialchars($row['name']); ?>"
                                     onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                <div class="img-placeholder" style="display: none;">
                                    <i class="fas fa-credit-card"></i>
                                </div>
                            <?php else: ?>
                                <div class="img-placeholder">
                                    <i class="fas fa-credit-card"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="payment-info">
                            <div class="payment-name"><?php echo htmlspecialchars($row['name']); ?></div>
                            <div class="limit">
                                <i class="fas fa-clock"></i>
                                দৈনিক লিমিট: <?php echo htmlspecialchars($row['daily_limit']); ?>
                            </div>
                        </div>
                        <i class="fas fa-chevron-right arrow-icon"></i>
                    </a>
                <?php endwhile; ?>
            </div>
        <?php endif; ?>
        
        <!-- ডিবাগ তথ্য (শুধু ডেভেলপমেন্টের জন্য) -->
        <?php if (defined('DEBUG_MODE') && DEBUG_MODE): ?>
            <div class="debug-info">
                <strong>ডিবাগ তথ্য:</strong><br>
                ইউজার ID: <?php echo $userId; ?><br>
                ব্যালেন্স: <?php echo $userData['balance']; ?><br>
                পেমেন্ট মেথড সংখ্যা: <?php echo $methodResult->num_rows; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <div class="nav-list">
            <a href="/" class="nav-item">
                <i class="fas fa-home nav-icon"></i>
                <div class="nav-label">হোম</div>
            </a>
            <a href="history.php" class="nav-item">
                <i class="fas fa-history nav-icon"></i>
                <div class="nav-label">ইতিহাস</div>
            </a>
            <a href="coin.php" class="nav-item">
                <i class="fas fa-qrcode nav-icon"></i>
                <div class="nav-label">স্ক্যান</div>
            </a>
            <a href="coin.php" class="nav-item">
                <div class="img-container" style="width: 24px; height: 24px; padding: 0; box-shadow: none; background: transparent;">
                    <img src="img/tt.png" alt="Rewards" 
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    <div class="img-placeholder" style="display: none; font-size: 16px;">
                        <i class="fas fa-gift"></i>
                    </div>
                </div>
                <div class="nav-label">রিওয়ার্ড</div>
            </a>
            <a href="profile.php" class="nav-item">
                <i class="fas fa-user nav-icon"></i>
                <div class="nav-label">প্রোফাইল</div>
            </a>
        </div>
    </div>
    
    <script>
        // ইমেজ লোডিং সমস্যা ডিবাগ করার জন্য
        document.addEventListener('DOMContentLoaded', function() {
            const images = document.querySelectorAll('.payment-method img');
            images.forEach(img => {
                img.addEventListener('error', function() {
                    console.error('Image failed to load:', this.src);
                    // এখানে আপনি এরর ট্র্যাকিং করতে পারেন
                });
            });
        });
    </script>
</body>
</html>