<?php
session_start();
include('db.php');
// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
// Initialize variables for balance and method information
$userId = $_SESSION['user_id'];
$balance = 0;
$paymentMethod = "";
$paymentNumber = "";
$method = $_GET['method'];
// Fetch the user's balance from the database
$userQuery = $conn->prepare("SELECT balance FROM users WHERE id = ?");
$userQuery->bind_param("i", $userId);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
if ($userData) {
    $balance = $userData['balance'];
}
// Fetch payment method details
$paymentMethodQuery = $conn->prepare("SELECT name, payment_number FROM payment_methods WHERE name = ?");
$paymentMethodQuery->bind_param("s", $method); // Bind the $method variable as a string
$paymentMethodQuery->execute();
$paymentMethodResult = $paymentMethodQuery->get_result();
$paymentMethodData = $paymentMethodResult->fetch_assoc();
if ($paymentMethodData) {
    $paymentMethod = $paymentMethodData['name'];
    $paymentNumber = $paymentMethodData['payment_number'];
}
// Handle form submission
$showToast = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $paymentNumberInput = $_POST['payment_number'];
    $amount = $_POST['amount'];
    // Insert the transaction into the database with "pending" status
    $insertQuery = $conn->prepare("INSERT INTO transactions (user_id, payment_method, payment_number, amount, status, title, type) VALUES (?, ?, ?, ?, 'pending', 'ADD MONEY', 'add')");
    $insertQuery->bind_param("issd", $userId, $paymentMethod, $paymentNumberInput, $amount);
    if ($insertQuery->execute()) {
        // Show the toast after a successful transaction
        function sendOneSignalNotificationToAll($title, $message, $url = null, $imageUrl = null) {
            $content = array(
                "en" => $message
            );
            $fields = array(
                'app_id' => "99424ad8-e933-4396-bc62-40c08c6d5b8d", // Your OneSignal App ID
                'included_segments' => array('All'), // Send to all users
                'headings' => array("en" => $title),
                'contents' => $content
            );
            // Add optional URL
            if ($url) {
                $fields['url'] = $url;
            }
            // Add optional Image URL
            if ($imageUrl) {
                $fields['big_picture'] = $imageUrl; // OneSignal specific key for large images
            }
            $fields = json_encode($fields);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Authorization: Basic NjdhMzQ5OTktNWU1NC00MDBjLWE1YjktMTBhZmU4YzNlZDJl' // Your OneSignal REST API Key
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            $response = curl_exec($ch);
            curl_close($ch);
            return $response;
        }
        // Example call for admin notification to all users
        $title = "Admin Notification";
        $message = "New transaction (add money)";
        $response = sendOneSignalNotificationToAll($title, $message);
        $showToast = true;
    } else {
        // Handle any errors (e.g., database errors)
        $error = "Error processing the payment. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট প্রক্রিয়া</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #00897b;
            --primary-light: #b2dfdb;
            --secondary-color: #4db6ac;
            --accent-color: #4db6ac;
            --light-bg: #f5f9f8;
            --card-bg: #ffffff;
            --text-primary: #00695c;
            --text-secondary: #00897b;
            --text-light: #ffffff;
            --shadow: 0 4px 15px rgba(0, 137, 123, 0.08);
            --shadow-hover: 0 8px 25px rgba(0, 137, 123, 0.12);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --radius: 20px;
            --success: #2ecc71;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Noto Sans Bengali', 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-primary);
            line-height: 1.6;
            padding-bottom: 80px;
            font-weight: 400;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: var(--text-light);
            padding: 18px 22px;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .back-icon {
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: var(--transition);
            background: rgba(255, 255, 255, 0.15);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            justify-content: center;
        }
        
        .back-icon:hover {
            transform: translateX(-3px);
            background: rgba(255, 255, 255, 0.25);
        }
        
        .back-icon i {
            font-size: 18px;
        }
        
        .header h3 {
            font-size: 20px;
            font-weight: 600;
            text-align: center;
            flex-grow: 1;
            margin: 0;
            text-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .balance {
            display: flex;
            align-items: center;
            background-color: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 15px;
            backdrop-filter: blur(5px);
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        
        .balance i {
            margin-right: 6px;
            color: var(--accent-color);
            font-size: 16px;
        }
        
        .main-container {
            max-width: 600px;
            margin: 25px auto;
            padding: 0 15px;
        }
        
        .notice-box {
            background: linear-gradient(135deg, #e0f7fa, #b2ebf2);
            border-radius: var(--radius);
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
            border-left: 4px solid var(--primary-color);
        }
        
        .notice-box p {
            font-size: 15px;
            color: #00695c;
            margin: 0;
            position: relative;
            padding-left: 30px;
            line-height: 1.6;
        }
        
        .notice-box p::before {
            content: '\f05a';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 0;
            top: 2px;
            color: var(--primary-color);
            font-size: 18px;
        }
        
        .inner-container {
            background: var(--card-bg);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }
        
        .inner-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
        }
        
        .inner-container:hover {
            box-shadow: var(--shadow-hover);
            transform: translateY(-3px);
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 10px;
            color: var(--secondary-color);
            font-size: 20px;
        }
        
        .payment-method {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
        }
        
        .method-info {
            display: flex;
            align-items: center;
        }
        
        .payment-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, var(--primary-light), #e0f2f1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: var(--primary-color);
            font-size: 20px;
            box-shadow: 0 4px 8px rgba(0, 137, 123, 0.1);
        }
        
        .method-info h4 {
            margin: 0;
            font-size: 18px;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .method-info span {
            font-size: 14px;
            color: var(--text-secondary);
            font-weight: 500;
        }
        
        .copy-button {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            padding: 10px 18px;
            border-radius: 30px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(0, 137, 123, 0.2);
        }
        
        .copy-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 137, 123, 0.3);
        }
        
        .copy-button i {
            margin-right: 6px;
            font-size: 14px;
        }
        
        .input-container {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        
        .input-group {
            position: relative;
        }
        
        .input-group i {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 16px;
            z-index: 1;
        }
        
        .input-container input {
            padding: 16px 16px 16px 48px;
            border: 2px solid #e0f2f1;
            border-radius: var(--radius);
            font-size: 15px;
            width: 100%;
            box-sizing: border-box;
            transition: var(--transition);
            background-color: var(--light-bg);
            font-weight: 500;
        }
        
        .input-container input:focus {
            border-color: var(--primary-color);
            background-color: var(--card-bg);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 137, 123, 0.08);
        }
        
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 16px;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            margin-top: 10px;
            transition: var(--transition);
            box-shadow: 0 4px 12px rgba(0, 137, 123, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 137, 123, 0.3);
        }
        
        .submit-btn i {
            margin-right: 8px;
            font-size: 16px;
        }
        
        .toast {
            visibility: hidden;
            min-width: 300px;
            margin-left: -150px;
            background: linear-gradient(135deg, var(--success), var(--primary-color));
            color: white;
            text-align: center;
            border-radius: 50px;
            padding: 15px 25px;
            position: fixed;
            z-index: 1000;
            left: 50%;
            top: 30px;
            font-size: 15px;
            font-weight: 500;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .toast i {
            margin-right: 10px;
            font-size: 18px;
        }
        
        .toast.show {
            visibility: visible;
            animation: slideIn 0.5s, slideOut 0.5s 2.5s;
        }
        
        @keyframes slideIn {
            from {top: -50px; opacity: 0;}
            to {top: 30px; opacity: 1;}
        }
        
        @keyframes slideOut {
            from {top: 30px; opacity: 1;}
            to {top: -50px; opacity: 0;}
        }
        
        /* Steps Section */
        .steps-container {
            background: var(--card-bg);
            border-radius: var(--radius);
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
        }
        
        .steps-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }
        
        .steps-title i {
            margin-right: 10px;
            color: var(--secondary-color);
        }
        
        .steps-list {
            list-style: none;
            counter-reset: step-counter;
        }
        
        .step-item {
            position: relative;
            padding-left: 40px;
            margin-bottom: 15px;
            counter-increment: step-counter;
            font-size: 15px;
            color: var(--text-secondary);
        }
        
        .step-item::before {
            content: counter(step-counter);
            position: absolute;
            left: 0;
            top: 0;
            width: 28px;
            height: 28px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 14px;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -3px 12px rgba(0, 0, 0, 0.06);
            z-index: 100;
            border-top: 1px solid rgba(0, 137, 123, 0.08);
        }
        
        .nav-list {
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
        }
        
        .nav-item {
            text-align: center;
            text-decoration: none;
            color: var(--text-secondary);
            transition: var(--transition);
            padding: 5px 8px;
            border-radius: 12px;
            min-width: 60px;
            position: relative;
        }
        
        .nav-item.active {
            color: var(--primary-color);
        }
        
        .nav-item.active::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 24px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 18px;
            margin-bottom: 3px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .header {
                padding: 14px 18px;
            }
            
            .header h3 {
                font-size: 18px;
            }
            
            .balance {
                font-size: 13px;
                padding: 6px 12px;
            }
            
            .notice-box p {
                font-size: 14px;
                padding-left: 25px;
            }
            
            .method-info h4 {
                font-size: 16px;
            }
            
            .method-info span {
                font-size: 13px;
            }
            
            .copy-button {
                padding: 8px 15px;
                font-size: 13px;
            }
            
            .input-container input {
                padding: 14px 14px 14px 45px;
            }
            
            .submit-btn {
                padding: 14px;
                font-size: 15px;
            }
        }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="back-icon" onclick="history.back()">
            <i class="fas fa-arrow-left"></i>
        </div>
        <h3>পেমেন্ট প্রক্রিয়া</h3>
        <div class="balance">
            <i class="fas fa-wallet"></i>
            ৳<?php echo number_format($balance, 2); ?>
        </div>
    </div>
    
    <!-- Main Container -->
    <div class="main-container">
        <!-- Notice Box -->
        <div class="notice-box">
            <p>নিজ অ্যাকাউন্টে ব্যালেন্স এড করার পূর্বে অবশ্যই কোম্পানির ডিপোজিট নাম্বারগুলো চেক দিয়ে টাকা পাঠাবেন। সর্বনিম্ন এড মানি ৫০০ টাকা</p>
        </div>
        
        <!-- Steps Section -->
        <div class="steps-container">
            <div class="steps-title">
                <i class="fas fa-list-ol"></i>
                পেমেন্ট প্রক্রিয়া
            </div>
            <ul class="steps-list">
                <li class="step-item">নিচে দেওয়া পেমেন্ট মেথড থেকে নাম্বার কপি করুন</li>
                <li class="step-item">সর্বনিম্ন ৫০০ টাকা পাঠিয়ে ট্রানজেকশন আইডি সংরক্ষণ করুন</li>
                <li class="step-item">নিচের ফর্মে আপনার পেমেন্ট নাম্বার ও পরিমাণ পূরণ করুন</li>
                <li class="step-item">সাবমিট করার পর অপেক্ষা করুন, টাকা অ্যাড হতে ২৪-৪৮ ঘন্টা সময় লাগতে পারে</li>
            </ul>
        </div>
        
        <!-- First Inner Container: Payment Method Information -->
        <div class="inner-container">
            <div class="section-title">
                <i class="fas fa-credit-card"></i>
                পেমেন্ট মেথড
            </div>
            <div class="payment-method">
                <div class="method-info">
                    <div class="payment-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div>
                        <h4><?php echo $paymentMethod; ?></h4>
                        <span><?php echo $paymentNumber; ?></span>
                    </div>
                </div>
                <button class="copy-button" onclick="copyToClipboard('<?php echo $paymentNumber; ?>')">
                    <i class="fas fa-copy"></i>
                    কপি করুন
                </button>
            </div>
        </div>
        
        <!-- Second Inner Container: Payment Input Section -->
        <div class="inner-container">
            <div class="section-title">
                <i class="fas fa-file-invoice-dollar"></i>
                পেমেন্ট বিবরণ
            </div>
            <form method="POST">
                <div class="input-container">
                    <div class="input-group">
                        <i class="fas fa-phone-alt"></i>
                        <input type="text" name="payment_number" placeholder="আপনার পেমেন্ট নাম্বার লিখুন" required>
                    </div>
                    <div class="input-group">
                        <i class="fas fa-money-bill"></i>
                        <input type="number" name="amount" placeholder="পরিমাণ লিখুন (ন্যূনতম ৳৫০০)" required min="500">
                    </div>
                </div>
                <button type="submit" class="submit-btn">
                    <i class="fas fa-paper-plane"></i>
                    সাবমিট করুন
                </button>
            </form>
        </div>
    </div>
    
    <!-- Bottom Navigation -->
    <div class="bottom-nav">
        <div class="nav-list">
            <a href="/" class="nav-item">
                <i class="fas fa-home nav-icon"></i>
                <div class="nav-label">হোম</div>
            </a>
            <a href="history.php" class="nav-item">
                <i class="fas fa-history nav-icon"></i>
                <div class="nav-label">ইতিহাস</div>
            </a>
            <a href="coin.php" class="nav-item">
                <i class="fas fa-qrcode nav-icon"></i>
                <div class="nav-label">স্ক্যান</div>
            </a>
            <a href="coin.php" class="nav-item">
                <img src="img/tt.png" alt="রিওয়ার্ড" style="width: 16px; height: 14px; margin-bottom: 1px;">
                <div class="nav-label">রিওয়ার্ড</div>
            </a>
            <a href="profile.php" class="nav-item">
                <i class="fas fa-user nav-icon"></i>
                <div class="nav-label">প্রোফাইল</div>
            </a>
        </div>
    </div>
    
    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <i class="fas fa-check-circle"></i>
        পেমেন্ট রিকোয়েস্ট সফলভাবে পাঠানো হয়েছে!
    </div>
    
    <?php if ($showToast): ?>
    <script>
        // Show toast and redirect after 3 seconds
        const toast = document.getElementById('toast');
        toast.className = 'toast show';
        // Redirect to dashboard after 3 seconds
        setTimeout(function() {
            window.location.href = "dashboard.php";
        }, 1000);
    </script>
    <?php endif; ?>
    
    <script>
        function copyToClipboard(text) {
            const tempInput = document.createElement('input');
            tempInput.value = text;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            // Show the toast message
            const toast = document.getElementById('toast');
            toast.innerHTML = '<i class="fas fa-check-circle"></i> ক্লিপবোর্ডে কপি হয়েছে!';
            toast.className = 'toast show';
            // Hide the toast after 2 seconds
            setTimeout(function() {
                toast.className = toast.className.replace('show', '');
                // Reset toast message
                setTimeout(function() {
                    toast.innerHTML = '<i class="fas fa-check-circle"></i> পেমেন্ট রিকোয়েস্ট সফলভাবে পাঠানো হয়েছে!';
                }, 500);
            }, 2000);
        }
    </script>
</body>
</html>