<?php
session_start();
include('db.php'); // Your database connection

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// Fetch all paybills
$paybillsQuery = "SELECT * FROM paybills";
$paybillsResult = $conn->query($paybillsQuery);

// Add new paybill
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['addPaybill'])) {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $logoUrl = '';

    // Handle logo upload
    if (!empty($_FILES['logo']['name'])) {
        $logoName = basename($_FILES['logo']['name']);
        $logoUrl = 'https://admin.ramitwallet.com/upload/' . $logoName;
        $uploadPath = 'upload/' . $logoName;
        move_uploaded_file($_FILES['logo']['tmp_name'], $uploadPath);
    }

    // Insert the new paybill into the database
    $insertQuery = "INSERT INTO paybills (name, description, logo_url) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($insertQuery);
    $stmt->bind_param('sss', $name, $description, $logoUrl);
    $stmt->execute();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Update paybill
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editPaybillId'])) {
    $paybillId = $_POST['editPaybillId'];
    $name = $_POST['editName'];
    $description = $_POST['editDescription'];
    $logoUrl = $_POST['existingLogoUrl'];

    // Handle logo upload
    if (!empty($_FILES['editLogo']['name'])) {
        $logoName = basename($_FILES['editLogo']['name']);
        $logoUrl = 'https://admin.ramitwallet.com/upload/' . $logoName;
        $uploadPath = 'upload/' . $logoName;
        move_uploaded_file($_FILES['editLogo']['tmp_name'], $uploadPath);
    }

    // Update the paybill in the database
    $updateQuery = "UPDATE paybills SET name = ?, description = ?, logo_url = ? WHERE id = ?";
    $stmt = $conn->prepare($updateQuery);
    $stmt->bind_param('sssi', $name, $description, $logoUrl, $paybillId);
    $stmt->execute();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Delete paybill
if (isset($_GET['delete'])) {
    $paybillId = $_GET['delete'];
    $deleteQuery = "DELETE FROM paybills WHERE id = ?";
    $stmt = $conn->prepare($deleteQuery);
    $stmt->bind_param('i', $paybillId);
    $stmt->execute();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Paybills</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .action-buttons {
            display: flex;
            gap: 10px;
        }
        .edit-btn, .delete-btn, .add-btn {
            padding: 5px 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .edit-btn {
            background-color: #4CAF50;
            color: white;
        }
        .delete-btn {
            background-color: #f44336;
            color: white;
        }
        .add-btn {
            background-color: #2196F3;
            color: white;
            margin-bottom: 20px;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 100;
            padding-top: 100px;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }
        .modal-content {
            background-color: #fff;
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        .close:hover, .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        .save-btn {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>Admin Panel - Paybills</h2>

        <button class="add-btn" onclick="showAddModal()">Add New Paybill</button>
        
        <table>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Description</th>
                <th>Logo URL</th>
                <th>Action</th>
            </tr>
            <?php if ($paybillsResult->num_rows > 0): ?>
                <?php while($paybill = $paybillsResult->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $paybill['id']; ?></td>
                    <td><?php echo htmlspecialchars($paybill['name']); ?></td>
                    <td><?php echo htmlspecialchars($paybill['description']); ?></td>
                    <td><?php echo htmlspecialchars($paybill['logo_url']); ?></td>
                    <td>
                        <div class="action-buttons">
                            <button class="edit-btn" onclick="showEditModal('<?php echo $paybill['id']; ?>', '<?php echo htmlspecialchars($paybill['name']); ?>', '<?php echo htmlspecialchars($paybill['description']); ?>', '<?php echo htmlspecialchars($paybill['logo_url']); ?>')">Edit</button>
                            <a href="?delete=<?php echo $paybill['id']; ?>" class="delete-btn" onclick="return confirm('Are you sure you want to delete this paybill?')">Delete</a>
                        </div>
                    </td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5">No paybills found.</td>
                </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Add Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal('addModal')">&times;</span>
            <h3>Add New Paybill</h3>
            <form method="POST" enctype="multipart/form-data">
                <div>
                    <label for="name">Name:</label>
                    <input type="text" name="name" required>
                </div>
                <div>
                    <label for="description">Description:</label>
                    <input type="text" name="description">
                </div>
                <div>
                    <label for="logo">Logo:</label>
                    <input type="file" name="logo" required>
                </div>
                <button type="submit" class="save-btn" name="addPaybill">Add Paybill</button>
            </form>
        </div>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal('editModal')">&times;</span>
            <h3>Edit Paybill</h3>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="editPaybillId" id="editPaybillId">
                <div>
                    <label for="editName">Name:</label>
                    <input type="text" name="editName" id="editName" required>
                </div>
                <div>
                    <label for="editDescription">Description:</label>
                    <input type="text" name="editDescription" id="editDescription">
                </div>
                <div>
                    <label for="editLogo">Logo:</label>
                    <input type="file" name="editLogo">
                    <input type="hidden" name="existingLogoUrl" id="existingLogoUrl">
                </div>
                <button type="submit" class="save-btn">Save Changes</button>
            </form>
        </div>
    </div>

    <script>
        // Show Add Modal
        function showAddModal() {
            document.getElementById('addModal').style.display = 'block';
        }

        // Show Edit Modal
        function showEditModal(id, name, description, logoUrl) {
            document.getElementById('editPaybillId').value = id;
            document.getElementById('editName').value = name;
            document.getElementById('editDescription').value = description;
            document.getElementById('existingLogoUrl').value = logoUrl;
            document.getElementById('editModal').style.display = 'block';
        }

        // Close Modal
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
    </script>

</body>
</html>
