<?php
session_start();
include('db.php'); // Include your database connection

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php"); // Redirect to login page if not logged in
    exit;
}

// Fetch settings from the database (id = 1)
$settingsQuery = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($settingsQuery);
$settings = $result->fetch_assoc();

// Update settings when form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $notice = $_POST['notice'];
    $home = $_POST['home'];
    $rechargeNotice = $_POST['recharge_notice'];
    $billNotice = $_POST['bill_notice'];
    $mbnkNotice = $_POST['mbnk_notice'];

    // Update the settings in the database
    $updateQuery = "UPDATE settings SET notice = ?, rechage_notice = ?, bill_notice = ?, mbnk_notice = ?, home = ? WHERE id = 1";
    $stmt = $conn->prepare($updateQuery);
    $stmt->bind_param('sssss', $notice, $rechargeNotice, $billNotice, $mbnkNotice, $home);
    $stmt->execute();

    // Redirect back to the same page to see the updated data
    header("Location: notice.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notice Management</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .header {
            display: flex;
            align-items: center;
            background-color: #4CAF50;
            color: white;
            padding: 15px;
            justify-content: space-between;
        }
        .back-icon {
            cursor: pointer;
        }
        .back-icon img {
            width: 18px;
            height: 18px;
        }
        .container {
            max-width: 800px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 8px;
        }
        .form-group textarea {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 5px;
            resize: vertical;
        }
        .btn-submit {
            padding: 10px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
    </style>
</head>
<body>

<!-- Header Section -->
<div class="header">
    <div class="back-icon" onclick="window.history.back()">
        <img src="https://cdn-icons-png.flaticon.com/512/93/93634.png" alt="Back">
    </div>
    <h2>Notice Management</h2>
</div>

<!-- Notice Management Form -->
<div class="container">
    <form method="post">
        <!-- General Notice -->
        <div class="form-group">
            <label for="notice">Home Notice</label>
            <textarea name="home" id="notice" rows="4"><?php echo htmlspecialchars($settings['home']); ?></textarea>
        </div>
        
        <!-- General Notice -->
        <div class="form-group">
            <label for="notice">Banking Notice</label>
            <textarea name="notice" id="notice" rows="4"><?php echo htmlspecialchars($settings['notice']); ?></textarea>
        </div>

        <!-- Recharge Notice -->
        <div class="form-group">
            <label for="recharge_notice">Recharge Notice</label>
            <textarea name="recharge_notice" id="recharge_notice" rows="4"><?php echo htmlspecialchars($settings['rechage_notice']); ?></textarea>
        </div>

        <!-- Bill Notice -->
        <div class="form-group">
            <label for="bill_notice">Bill Notice</label>
            <textarea name="bill_notice" id="bill_notice" rows="4"><?php echo htmlspecialchars($settings['bill_notice']); ?></textarea>
        </div>

        <!-- M-Bank Notice -->
        <div class="form-group">
            <label for="mbnk_notice">M-Bank Notice</label>
            <textarea name="mbnk_notice" id="mbnk_notice" rows="4"><?php echo htmlspecialchars($settings['mbnk_notice']); ?></textarea>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn-submit">Update Notices</button>
    </form>
</div>

</body>
</html>
