<?php
session_start();

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit;
}

// Database connection
include('db.php');

// Fetch total users
$totalUsersQuery = "SELECT COUNT(*) AS total_users FROM users";
$totalUsersResult = $conn->query($totalUsersQuery);
$totalUsers = $totalUsersResult->fetch_assoc()['total_users'];

// Fetch total balance
$totalBalanceQuery = "SELECT SUM(balance) AS total_balance FROM users";
$totalBalanceResult = $conn->query($totalBalanceQuery);
$totalBalance = $totalBalanceResult->fetch_assoc()['total_balance'];

// Fetch today's transactions total amount
$today = date('Y-m-d');
$todayTrxQuery = "SELECT COALESCE(SUM(amount), 0) AS total_trx FROM transactions WHERE DATE(date) = ?";
$stmt_today_trx = $conn->prepare($todayTrxQuery);
$stmt_today_trx->bind_param("s", $today);
$stmt_today_trx->execute();
$todayTrxResult = $stmt_today_trx->get_result();
$todayTrx = $todayTrxResult->fetch_assoc()['total_trx'];

// Fetch today's number of transactions
$todayCountQuery = "SELECT COUNT(*) AS total_count FROM transactions WHERE DATE(date) = ?";
$stmt_today_count = $conn->prepare($todayCountQuery);
$stmt_today_count->bind_param("s", $today);
$stmt_today_count->execute();
$todayCountResult = $stmt_today_count->get_result();
$todayCount = $todayCountResult->fetch_assoc()['total_count'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    
    <meta name="theme-name" content="RAYHAN" />
  
    <title>RAYHAN - Bootstrap Admin Dashboard Template by Themefisher.com</title>
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon.png">
    <link href="./plugins/pg-calendar/css/pignose.calendar.min.css" rel="stylesheet">
    <link rel="stylesheet" href="./plugins/chartist/css/chartist.min.css">
    <link rel="stylesheet" href="./plugins/chartist-plugin-tooltips/css/chartist-plugin-tooltip.css">
    <link href="css/style.css" rel="stylesheet">

</head>

<body>

    <div id="preloader">
        <div class="loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="3" stroke-miterlimit="10" />
            </svg>
        </div>
    </div>

    <div id="main-wrapper">

        <div class="nav-header">
            <div class="brand-logo">
                <a href="#">
                    <b class="logo-abbr"><img src="images/logo.png" alt=""> </b>
                    <span class="logo-compact"><img src="./images/logo-compact.png" alt=""></span>
                    <span class="brand-title">
                        <img src="images/logo-text.png" alt="">
                    </span>
                </a>
            </div>
        </div>

        <div class="header">    
            <div class="header-content clearfix">
                <div class="nav-control">
                    <div class="hamburger">
                        <span class="toggle-icon"><i class="icon-menu"></i></span>
                    </div>
                </div>
                <div class="header-left">
                    <div class="input-group icons">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-transparent border-0 pr-2 pr-sm-3" id="basic-addon1"><i class="mdi mdi-magnify"></i></span>
                        </div>
                        <input type="search" class="form-control" placeholder="Search Dashboard" aria-label="Search Dashboard">
                    </div>
                </div>
                <div class="header-right">
                    <ul class="clearfix">
                        <li class="icons dropdown">
                            <div class="user-img c-pointer position-relative" data-toggle="dropdown">
                                <span class="activity active"></span>
                                <img src="images/user/1.png" height="40" width="40" alt="">
                            </div>
                            <div class="drop-down dropdown-profile animated fadeIn dropdown-menu">
                                <div class="dropdown-content-body">
                                    <ul>
                                        <li><a href="admin_logout.php"><i class="icon-key"></i> <span>Logout</span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="nk-sidebar">           
            <div class="nk-nav-scroll">
                <ul class="metismenu" id="menu">
                    <li class="nav-label">Dashboard</li>
                    <li>
                        <a href="/" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <a href="users.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">User List</span>
                        </a>
                    </li>
                    <li>
                        <a href="mbank.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Banking</span>
                        </a>
                    </li>
                    <li>
                        <a href="addmoney.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add Money</span>
                        </a>
                    </li>
                    <li>
                        <a href="other.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Other Trx</span>
                        </a>
                    </li>
                    <li>
                        <a href="bnk-m.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add M-Bank</span>
                        </a>
                    </li>
                    <li>
                        <a href="add-m.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add Money Method</span>
                        </a>
                    </li>
                    <li>
                        <a href="add-bnk.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add Bank</span>
                        </a>
                    </li>
                    <li>
                        <a href="bill-add.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add Bill</span>
                        </a>
                    </li>
                    <li>
                        <a href="offer.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Add Offer</span>
                        </a>
                    </li>
                    <li>
                        <a href="notice.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Notice</span>
                        </a>
                    </li>
                    <li>
                        <a href="slider.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Slider Add</span>
                        </a>
                    </li>
                    <li>
                        <a href="noti.php" aria-expanded="false">
                            <i class="icon-badge menu-icon"></i><span class="nav-text">Notification</span>
                        </a>
                    </li>
                    <li>
    <a href="snote.php" aria-expanded="false">
        <i class="icon-badge menu-icon"></i><span class="nav-text">Slide Notice</span>
    </a>
</li>

                </ul>
            </div>
        </div>

        <div class="content-body">

            <div class="container-fluid mt-3">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-1">
                            <div class="card-body">
                                <h3 class="card-title text-white">Total Users</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $totalUsers; ?></h2>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-users"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-2">
                            <div class="card-body">
                                <h3 class="card-title text-white">Total Balance</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo number_format($totalBalance, 2); ?></h2>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-3">
                            <div class="card-body">
                                <h3 class="card-title text-white">Today's Total Transactions</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo number_format($todayTrx, 2); ?></h2>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-shopping-cart"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card gradient-4">
                            <div class="card-body">
                                <h3 class="card-title text-white">Today's Number of Transactions</h3>
                                <div class="d-inline-block">
                                    <h2 class="text-white"><?php echo $todayCount; ?></h2>
                                </div>
                                <span class="float-right display-5 opacity-5"><i class="fa fa-money"></i></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- #/ container -->
        </div>

        <div class="footer">
            <div class="copyright">
                <p>Copyright &copy; Designed & Developed by <a href="https://themeforest.net/user/RAYHAN">RAYHAN</a> 2024</p>
            </div>
        </div>
    </div>

    <script src="plugins/common/common.min.js"></script>
    <script src="js/custom.min.js"></script>
    <script src="js/settings.js"></script>
    <script src="js/gleek.js"></script>
    <script src="js/styleSwitcher.js"></script>
    <script src="./plugins/chart.js/Chart.bundle.min.js"></script>
    <script src="./plugins/circle-progress/circle-progress.min.js"></script>
    <script src="./plugins/d3v3/index.js"></script>
    <script src="./plugins/topojson/topojson.min.js"></script>
    <script src="./plugins/datamaps/datamaps.world.min.js"></script>
    <script src="./plugins/raphael/raphael.min.js"></script>
    <script src="./plugins/morris/morris.min.js"></script>
    <script src="./plugins/moment/moment.min.js"></script>
    <script src="./plugins/pg-calendar/js/pignose.calendar.min.js"></script>
    <script src="./plugins/chartist/js/chartist.min.js"></script>
    <script src="./plugins/chartist-plugin-tooltips/js/chartist-plugin-tooltip.min.js"></script>

    <script src="./js/dashboard/dashboard-1.js"></script>

</body>

</html>
